/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin.pilot;

import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicHandler;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.plugin.OMGraphicHandlerPlugIn;
import com.bbn.openmap.plugin.pilot.Pilot;
import com.bbn.openmap.plugin.pilot.PilotLoader;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.tools.drawing.OMDrawingTool;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;

public class PilotLoaderPlugIn
extends OMGraphicHandlerPlugIn {
    protected PilotLoader loader = null;
    protected OMDrawingTool dt = null;

    public PilotLoaderPlugIn() {
        this.setPilotLoader(new PilotLoader((OMGraphicHandler)this));
    }

    public PilotLoaderPlugIn(Component comp) {
        super(comp);
        this.setPilotLoader(new PilotLoader((OMGraphicHandler)this));
    }

    public OMGraphicList getRectangle(Projection p) {
        if (this.loader != null) {
            this.loader.setProjection(p);
        }
        OMGraphicList list = super.getList();
        list.generate(p);
        if (Debug.debugging((String)"pilotloader")) {
            Debug.output((String)("GraphicLoaderPlugIn returning list of " + list.size() + " objects."));
        }
        return list;
    }

    public synchronized void setList(OMGraphicList graphics) {
        super.setList(graphics);
        this.doPrepare();
    }

    public synchronized boolean doAction(OMGraphic graphic, OMAction action) {
        boolean ret = super.doAction(graphic, action);
        this.doPrepare();
        return ret;
    }

    public void setPilotLoader(PilotLoader pl) {
        this.loader = pl;
        this.setMapMouseListener((MapMouseListener)this.loader);
        try {
            this.loader.setBeanContext(this.getBeanContext());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public PilotLoader getPilotLoader() {
        return this.loader;
    }

    public Component getGUI() {
        if (this.loader != null) {
            return this.loader.getGUI();
        }
        return null;
    }

    public boolean mouseClicked(MouseEvent e) {
        OMGraphic graphic;
        OMGraphicList list = this.getList();
        if (list != null && (graphic = (OMGraphic)list.getContains(e.getX(), e.getY())) instanceof Pilot) {
            Pilot mp = (Pilot)graphic;
            mp.showPalette();
            return true;
        }
        return false;
    }

    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        super.setBeanContext(in_bc);
        if (this.loader != null) {
            this.loader.setBeanContext(in_bc);
        }
    }
}

