/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.j3d;

import com.bbn.openmap.geo.Geo;
import javax.vecmath.Point3d;

public class J3DGeo
extends Geo {
    public J3DGeo(double lat, double lon) {
        super(lat, lon);
    }

    public J3DGeo(double lat, double lon, boolean isDegrees) {
        super(lat, lon, isDegrees);
    }

    public J3DGeo(double lat, double lon, boolean isDegrees, double length) {
        super(lat, lon, isDegrees);
        this.setLength(length);
    }

    public J3DGeo(double x, double y, double z) {
        super(x, -z, y);
    }

    public J3DGeo(Geo geo) {
        super(geo);
    }

    public J3DGeo(Point3d pt) {
        this(pt.x, pt.y, pt.z);
    }

    public void initialize(double x, double y, double z) {
        super.initialize(x, -z, y);
    }

    public double getX() {
        return super.x();
    }

    public double getY() {
        return super.z();
    }

    public double getZ() {
        return -super.y();
    }

    protected J3DGeo create(double superX, double superY, double superZ) {
        return new J3DGeo(superX, superZ, -superY);
    }

    public Geo add(Geo b) {
        return this.create(this.x() + b.x(), this.y() + b.y(), this.z() + b.z());
    }

    public Geo subtract(Geo b) {
        return this.create(this.x() - b.x(), this.y() - b.y(), this.z() - b.z());
    }

    public Geo scale(double s) {
        return this.create(this.x() * s, this.y() * s, this.z() * s);
    }

    public Geo cross(Geo b) {
        return this.create(this.y() * b.z() - this.z() * b.y(), this.z() * b.x() - this.x() * b.z(), this.x() * b.y() - this.y() * b.x());
    }

    public Geo crossNormalize(Geo b) {
        double x = this.y() * b.z() - this.z() * b.y();
        double y = this.z() * b.x() - this.x() * b.z();
        double z = this.x() * b.y() - this.y() * b.x();
        double L = Math.sqrt(x * x + y * y + z * z);
        return this.create(x / L, y / L, z / L);
    }

    public Point3d getPoint3d() {
        return this.getPoint3d(new Point3d());
    }

    public Point3d getPoint3d(Point3d pt) {
        pt.set(this.getX(), this.getY(), this.getZ());
        return pt;
    }
}

