/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.j3d;

import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.ScaleFilterLayer;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicAdapter;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.tools.j3d.OMGraphicUtil;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.OrderedGroup;
import javax.media.j3d.Shape3D;

public class LayerMapContent
extends OrderedGroup {
    public static final double DEFAULT_LAYER_SEPARATION = 0.1;
    protected double layerSeparation = 0.1;

    public LayerMapContent(MapHandler mapHandler) {
        this.createMap(mapHandler);
    }

    public LayerMapContent(OMGraphicHandlerLayer layer) {
        this.addContent((Group)this, layer);
    }

    protected void createMap(MapHandler mapHandler) {
        double baselineHeight = this.layerSeparation;
        LayerHandler lh = (LayerHandler)mapHandler.get("com.bbn.openmap.LayerHandler");
        if (lh != null) {
            Debug.message((String)"3d", (String)"LayerMapContent: putting layer graphics on the map.");
            Layer[] layers = lh.getLayers();
            for (int i = layers.length - 1; i >= 0; --i) {
                Layer layer = layers[i];
                if (!layer.isVisible()) continue;
                if (layer instanceof ScaleFilterLayer) {
                    ScaleFilterLayer sfl = (ScaleFilterLayer)layer;
                    layer = sfl.getAppropriateLayer();
                }
                if (layer instanceof OMGraphicHandlerLayer) {
                    this.addContent((Group)this, (OMGraphicHandlerLayer)layer, baselineHeight += this.layerSeparation);
                    continue;
                }
                Debug.message((String)"3d", (String)("LayerMapContent: skipping layer " + layer.getName()));
            }
        }
        this.addSea((Group)this, mapHandler);
    }

    protected void addSea(Group bg, MapHandler mh) {
        MapBean map = (MapBean)mh.get("com.bbn.openmap.MapBean");
        if (map != null) {
            Debug.message((String)"3d", (String)"LayerMapContent: putting down sea.");
            Color seaColor = map.getBackground();
            Projection proj = map.getProjection();
            int width = proj.getWidth();
            int height = proj.getHeight();
            GeneralPath background = OMGraphicAdapter.createBoxShape((float)(-width), (float)(-height), (int)(width * 3), (int)(height * 3));
            this.addTo(bg, OMGraphicUtil.createShape3D(background, 0.0, seaColor, true));
        }
    }

    protected void addContent(Group bg, OMGraphicHandlerLayer layer) {
        this.addContent(bg, layer, 0.0);
    }

    protected void addContent(Group bg, OMGraphicHandlerLayer layer, double baselineHeight) {
        Debug.message((String)"3d", (String)("LayerMapContent: putting layer " + layer.getName() + " graphics on the map."));
        this.addTo(bg, OMGraphicUtil.createShape3D((OMGraphic)layer.getList(), baselineHeight));
    }

    public void setLayerSeparation(double separation) {
        this.layerSeparation = separation;
    }

    public double getLayerSeparation() {
        return this.layerSeparation;
    }

    protected void addTo(Group bg, Iterator shapeIterator) {
        while (shapeIterator.hasNext()) {
            try {
                Shape3D shape = (Shape3D)shapeIterator.next();
                if (shape == null) continue;
                bg.addChild((Node)shape);
            }
            catch (ClassCastException cce) {}
        }
    }
}

