/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.exportconfig;

import java.io.File;
import java.io.IOException;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ExportConfigPreferences {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ExportConfigPreferences.class);
    private static final ILogger s_log = LoggerController.createLogger(ExportConfigPreferences.class);
    private boolean _exportPreferences = true;
    private boolean _exportDrivers = true;
    private boolean _exportAliases = true;
    private boolean _includeUserNames = true;
    private boolean _includePasswords = true;
    private String _preferencesFileName;
    private String _driversFileName;
    private String _aliasesFileName;

    public ExportConfigPreferences() {
        File here = new File(".");
        ApplicationFiles appFiles = new ApplicationFiles();
        this._preferencesFileName = this.getFileName(here, appFiles.getUserPreferencesFile().getName());
        this._driversFileName = this.getFileName(here, appFiles.getDatabaseDriversFile().getName());
        this._aliasesFileName = this.getFileName(here, appFiles.getDatabaseAliasesFile().getName());
    }

    public boolean getExportPreferences() {
        return this._exportPreferences;
    }

    public void setExportPreferences(boolean value) {
        this._exportPreferences = value;
    }

    public boolean getExportDrivers() {
        return this._exportDrivers;
    }

    public void setExportDrivers(boolean value) {
        this._exportDrivers = value;
    }

    public boolean getExportAliases() {
        return this._exportAliases;
    }

    public void setExportAliases(boolean value) {
        this._exportAliases = value;
    }

    public boolean getIncludeUserNames() {
        return this._includeUserNames;
    }

    public void setIncludeUserNames(boolean value) {
        this._includeUserNames = value;
    }

    public boolean getIncludePasswords() {
        return this._includePasswords;
    }

    public void setIncludePasswords(boolean value) {
        this._includePasswords = value;
    }

    public String getPreferencesFileName() {
        return this._preferencesFileName;
    }

    public void setPreferencesFileName(String value) {
        this._preferencesFileName = value;
    }

    public String getDriversFileName() {
        return this._driversFileName;
    }

    public void setDriversFileName(String value) {
        this._driversFileName = value;
    }

    public String getAliasesFileName() {
        return this._aliasesFileName;
    }

    public void setAliasesFileName(String value) {
        this._aliasesFileName = value;
    }

    private String getFileName(File dir, String name) {
        return this.getFileName(new File(dir, name));
    }

    private String getFileName(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            s_log.error((Object)s_stringMgr.getString("exportconfig.errorResolvingFile"), (Throwable)ex);
            return file.getAbsolutePath();
        }
    }
}

