/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.exportconfig.action;

import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.fw.gui.ChooserPreviewer;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;
import net.sourceforge.squirrel_sql.plugins.exportconfig.ExportConfigPlugin;

abstract class AbstractSaveCommand
implements ICommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AbstractSaveCommand.class);
    private static final ILogger s_log = LoggerController.createLogger(AbstractSaveCommand.class);
    private static File s_lastDir;
    private final Frame _frame;
    private ExportConfigPlugin _plugin;

    AbstractSaveCommand(Frame frame, ExportConfigPlugin plugin) {
        if (frame == null) {
            throw new IllegalArgumentException("Frame == null");
        }
        if (plugin == null) {
            throw new IllegalArgumentException("ExportConfigPlugin == null");
        }
        this._frame = frame;
        this._plugin = plugin;
    }

    public void execute() throws BaseException {
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter((FileFilter)new FileExtensionFilter("XML files", new String[]{".xml"}));
        File file = null;
        file = s_lastDir != null ? new File(s_lastDir, this.getDefaultFilename()) : new File((File)null, this.getDefaultFilename());
        chooser.setSelectedFile(file);
        chooser.setAccessory((JComponent)new ChooserPreviewer());
        chooser.setDialogTitle("Save " + this.getSaveDescription());
        while (chooser.showSaveDialog(this._frame) != 1 && !this.saveFile(chooser.getSelectedFile())) {
        }
    }

    private boolean saveFile(File file) {
        if (file.exists()) {
            String msg = s_stringMgr.getString("exportconfig.fileExistsReplace", new Object[]{file.getAbsolutePath()});
            if (!Dialogs.showYesNo((Component)this._frame, (String)msg)) {
                return false;
            }
            if (!file.canWrite()) {
                msg = s_stringMgr.getString("exportconfig.fileExistsButReadOnly", new Object[]{file.getAbsolutePath()});
                Dialogs.showOk((Component)this._frame, (String)msg);
                return false;
            }
            file.delete();
        }
        s_lastDir = file.getParentFile();
        IApplication app = this._plugin.getApplication();
        try {
            this.writeToFile(file);
            String[] params = new String[]{this.getSaveDescription(), file.getAbsolutePath()};
            String msg = s_stringMgr.getString("exportconfig.fileSavedTo", params);
            Dialogs.showOk((Component)this._frame, (String)msg);
        }
        catch (IOException ex) {
            String msg = s_stringMgr.getString("exportconfig.ioErrorWritingTo", new Object[]{file.getAbsolutePath()});
            this._plugin.getApplication().showErrorDialog(msg, (Throwable)ex);
        }
        catch (XMLException ex) {
            String msg = s_stringMgr.getString("exportconfig.xmlErrorWritingTo", new Object[]{file.getAbsolutePath()});
            this._plugin.getApplication().showErrorDialog(msg, (Throwable)ex);
        }
        return true;
    }

    protected abstract String getSaveDescription();

    protected abstract String getDefaultFilename();

    protected abstract void writeToFile(File var1) throws IOException, XMLException;
}

