/*
 * Decompiled with CFR 0.152.
 */
package snow.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import snow.query.SNowQuery;
import unity.annotation.SourceField;
import unity.annotation.SourceTable;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.LQCondNode;
import unity.query.LQDupElimNode;
import unity.query.LQExprNode;
import unity.query.LQGroupByNode;
import unity.query.LQLimitNode;
import unity.query.LQNode;
import unity.query.LQOrderByNode;
import unity.query.LQProjNode;
import unity.query.LQSelNode;
import unity.util.StringFunc;

public class SNowBuilder {
    private LQNode startNode;
    private SourceTable table;
    private LQProjNode firstProj = null;
    private boolean fromSeen;
    private String serverURL;

    public SNowBuilder(String string, LQNode lQNode) {
        this.startNode = lQNode;
        this.serverURL = string;
    }

    public SNowQuery toQuery() throws SQLException {
        LQNode lQNode = this.startNode;
        SNowQuery sNowQuery = new SNowQuery("");
        this.processNode(sNowQuery, lQNode);
        return sNowQuery;
    }

    public void processNode(SNowQuery sNowQuery, LQNode lQNode) throws SQLException {
        if (lQNode != null) {
            if (lQNode.getType() == 1 && this.firstProj == null) {
                this.firstProj = (LQProjNode)lQNode;
            }
            if (lQNode.getNumChildren() > 1) {
                throw new SQLException("Too many children found at node " + lQNode.toString());
            }
            if (lQNode.getNumChildren() > 0) {
                this.processNode(sNowQuery, lQNode.getChild());
            }
            switch (lQNode.getType()) {
                case 1: {
                    this.buildProjection((LQProjNode)lQNode, sNowQuery);
                    break;
                }
                case 2: {
                    this.buildSelection((LQSelNode)lQNode, sNowQuery);
                    break;
                }
                case 6: 
                case 100: {
                    this.buildFrom(lQNode, sNowQuery);
                    break;
                }
                case 18: {
                    this.buildLimit((LQLimitNode)lQNode, sNowQuery);
                    break;
                }
                case 4: {
                    this.buildOrderBy((LQOrderByNode)lQNode, sNowQuery);
                    break;
                }
                case 5: {
                    this.buildGroupBy((LQGroupByNode)lQNode, sNowQuery);
                    break;
                }
                case 16: {
                    this.buildDistinct((LQDupElimNode)lQNode, sNowQuery);
                    break;
                }
                default: {
                    throw new SQLException("Unable to process query operation.  Operation not supported by driver: " + lQNode);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void buildProjection(LQProjNode lQProjNode, SNowQuery sNowQuery) throws SQLException {
        Object object;
        CharSequence charSequence;
        if (lQProjNode != this.firstProj) {
            return;
        }
        sNowQuery.setProjection(lQProjNode);
        ArrayList<LQExprNode> arrayList = lQProjNode.getExpressions();
        HashMap<CharSequence, void> hashMap = new HashMap<CharSequence, void>();
        for (LQExprNode lQExprNode : arrayList) {
            void object22;
            if (lQExprNode.getType() == 103) {
                LQExprNode lQExprNode2 = (LQExprNode)lQExprNode.getChild(0);
            }
            if (object22.getType() == 126) {
                throw new SQLException("Expressions in projection are not supported.");
            }
            if (object22.getType() == 120) {
                LQExprNode lQExprNode3 = (LQExprNode)object22.getContent();
                throw new SQLException("Expressions in projection are not supported.");
            }
            String[] stringArray = StringFunc.divideIdentifier(object22.toString());
            charSequence = stringArray[0];
            if (stringArray.length > 1) {
                charSequence = stringArray[stringArray.length - 1];
            }
            if (((String)charSequence).equals("*")) {
                lQProjNode.setSelectAll(true);
                break;
            }
            hashMap.put(charSequence, object22);
        }
        Iterator<Object> iterator = this.table.fieldIterator();
        Attribute[] attributeArray = new Attribute[arrayList.size()];
        int n = 0;
        charSequence = new StringBuilder();
        while (iterator.hasNext()) {
            object = (SourceField)iterator.next();
            String string = ((SourceField)object).getColumnName();
            LQExprNode lQExprNode = (LQExprNode)hashMap.get(string);
            if (lQExprNode == null) {
                lQExprNode = (LQExprNode)hashMap.get(StringFunc.delimitName(string, '\"'));
            }
            if (lQExprNode == null) {
                if (((StringBuilder)charSequence).length() > 0) {
                    ((StringBuilder)charSequence).append(",");
                }
                ((StringBuilder)charSequence).append(string);
                continue;
            }
            GQFieldRef gQFieldRef = (GQFieldRef)lQExprNode.getContent();
            attributeArray[n++] = new Attribute(string, ((SourceField)object).getDataType(), 0, gQFieldRef);
        }
        object = new Relation(attributeArray);
        sNowQuery.setTableRelation((Relation)object);
        ((Relation)object).setProperty("name", this.table.getTableName());
        sNowQuery.setRelation((Relation)object);
        lQProjNode.getChild(0).setOutputRelation((Relation)object);
        if (((StringBuilder)charSequence).length() > 0) {
            sNowQuery.setParameter("__exclude_columns", ((StringBuilder)charSequence).toString());
        }
    }

    private void buildCondition(LQCondNode lQCondNode, SNowQuery sNowQuery) throws SQLException {
        int n = lQCondNode.getType();
        switch (n) {
            case 118: {
                throw new SQLException("WHERE filters with XOR are not supported.");
            }
            case 112: {
                throw new SQLException("WHERE filters with NOT are not supported.");
            }
            case 110: {
                throw new SQLException("WHERE filters with OR are not supported.");
            }
            case 111: {
                LQCondNode lQCondNode2 = (LQCondNode)lQCondNode.getChild(0);
                LQCondNode lQCondNode3 = (LQCondNode)lQCondNode.getChild(1);
                this.buildCondition(lQCondNode2, sNowQuery);
                this.buildCondition(lQCondNode3, sNowQuery);
                break;
            }
            default: {
                this.buildExpression(lQCondNode, sNowQuery);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildExpression(LQCondNode lQCondNode, SNowQuery sNowQuery) throws SQLException {
        String string;
        String string2;
        int n = lQCondNode.getType();
        if (n != 114) throw new SQLException("Condition not supported: " + lQCondNode.toString());
        LQNode lQNode = lQCondNode.getChild(0);
        LQNode lQNode2 = lQCondNode.getChild(1);
        String string3 = (String)lQCondNode.getContent();
        if (string3.equals("=")) {
            int n2 = lQNode.getType();
            int n3 = lQNode2.getType();
            string2 = null;
            if (n2 == 100 && (n3 == 127 || n3 == 101 || n3 == 104 || n3 == 105 || n3 == 140 || n3 == 141 || n3 == 142)) {
                string = n3 == 140 || n3 == 141 || n3 == 142 ? (String)lQNode2.getReference() : lQNode2.getContent().toString();
                string2 = lQNode.getContent() + "=" + StringFunc.removeQuotes(string);
            } else {
                if (n3 != 100 || n2 != 127 && n2 != 101 && n2 != 104 && n2 != 105 && n2 != 140 && n2 != 141 && n2 != 142) throw new SQLException("Expression not supported: " + lQCondNode.toString());
                string = n2 == 140 || n2 == 141 || n2 == 142 ? (String)lQNode2.getReference() : lQNode2.getContent().toString();
                string2 = lQNode2.getContent() + "=" + StringFunc.removeQuotes(string);
            }
        } else {
            if (!string3.equals(">") && !string3.equals("<") && !string3.equals("!=") && !string3.equals("<>") && !string3.equals("<>") && !string3.equals("<=") && !string3.equals(">=")) throw new SQLException("Operator " + string3 + " is not supported.");
            throw new SQLException("Operator " + string3 + " is not supported.");
        }
        string = sNowQuery.getParameter("__encoded_query");
        string = string != null ? string + "^" + string2 : string2;
        sNowQuery.setParameter("__encoded_query", string);
    }

    private void buildSelection(LQSelNode lQSelNode, SNowQuery sNowQuery) throws SQLException {
        LQCondNode lQCondNode = lQSelNode.getCondition();
        this.buildCondition(lQCondNode, sNowQuery);
    }

    private void buildGroupBy(LQGroupByNode lQGroupByNode, SNowQuery sNowQuery) throws SQLException {
        throw new SQLException("GROUP BY is not currently supported.");
    }

    private void buildOrderBy(LQOrderByNode lQOrderByNode, SNowQuery sNowQuery) throws SQLException {
        if (lQOrderByNode.getOrderNumChildren() > 1) {
            throw new SQLException("ORDER BY only supports sorting on one field.");
        }
        LQNode lQNode = lQOrderByNode.getOrderChild(0);
        if (lQNode.getType() != 100) {
            throw new SQLException("ORDER BY only supports sorting on one field with no expressions.");
        }
        String string = ((GQFieldRef)lQNode.getContent()).toString();
        String string2 = lQOrderByNode.getDirection(0);
        if (string2.equals("DESC")) {
            sNowQuery.setParameter("__order_by_desc", string);
        } else {
            sNowQuery.setParameter("__order_by", string);
        }
    }

    private void buildFrom(LQNode lQNode, SNowQuery sNowQuery) throws SQLException {
        if (this.fromSeen) {
            throw new SQLException("Two tables were received. The driver only supports single table queries.");
        }
        this.fromSeen = true;
        GQTableRef gQTableRef = (GQTableRef)lQNode.getContent();
        String string = gQTableRef.getTable().getTableName();
        sNowQuery.setURL("https://" + this.serverURL + "/" + string + ".do?SOAP");
        this.table = gQTableRef.getTable();
    }

    private void buildLimit(LQLimitNode lQLimitNode, SNowQuery sNowQuery) throws SQLException {
        if (lQLimitNode.hasOffset()) {
            int n = lQLimitNode.getStart();
            int n2 = lQLimitNode.getCount();
            sNowQuery.setParameter("__first_row", "" + n);
            sNowQuery.setParameter("__last_row", "" + (n + n2));
        } else {
            sNowQuery.setParameter("__limit", "" + lQLimitNode.getCount());
        }
    }

    private void buildDistinct(LQDupElimNode lQDupElimNode, SNowQuery sNowQuery) throws SQLException {
        throw new SQLException("DISTINCT is not currently supported.");
    }

    public String toQueryString() throws SQLException {
        return this.toQuery().toString();
    }

    public String toString() {
        try {
            return this.toQueryString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }
}

