/*
 * Decompiled with CFR 0.152.
 */
package unity.generic.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import unity.engine.IServerConnection;
import unity.generic.jdbc.DatabaseMetaDataImpl;
import unity.generic.jdbc.PreparedStatementImpl;
import unity.generic.jdbc.StatementImpl;

public class ConnectionImpl
implements Connection {
    protected static final Locale locale = Locale.getDefault();
    protected static ResourceBundle resources = ResourceBundle.getBundle("resources/generic/ConnectionImpl", locale);
    protected boolean CLOSED = false;
    protected boolean READONLY = false;
    protected Statement currentStatement = null;
    protected SQLWarning firstWarning = null;
    protected boolean autoCommit = true;
    protected int rsHoldability = 2;
    protected Properties clientInfo;
    protected Map<String, Class<?>> typemap;
    protected IServerConnection connection;
    protected String url;
    protected static String notSupported = "notSupported";

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.firstWarning = null;
    }

    @Override
    public void close() throws SQLException {
        this.CLOSED = true;
        if (this.currentStatement != null) {
            this.currentStatement.close();
        }
        this.currentStatement = null;
        this.connection.close();
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new SQLException(resources.getString("commitError"));
        }
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        this.checkClosed();
        throw new SQLFeatureNotSupportedException(resources.getString(notSupported));
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        throw new SQLFeatureNotSupportedException(resources.getString(notSupported));
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        throw new SQLFeatureNotSupportedException(resources.getString(notSupported));
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        throw new SQLFeatureNotSupportedException(resources.getString(notSupported));
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        throw new SQLFeatureNotSupportedException(resources.getString(notSupported));
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 2);
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, 2);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n == 1005) {
            throw new SQLException(resources.getString("nosupportScrollSensitive"));
        }
        if (n2 == 1008) {
            throw new SQLException(resources.getString("nosupportConcurUpdatable"));
        }
        if (this.currentStatement != null) {
            this.currentStatement.close();
        }
        this.currentStatement = new StatementImpl(this, this.connection, n, n2);
        return this.currentStatement;
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        this.checkClosed();
        throw new SQLException(resources.getString(notSupported));
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return this.clientInfo;
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.checkClosed();
        return this.clientInfo.getProperty(string);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.rsHoldability;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new DatabaseMetaDataImpl(this, this.connection);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.typemap;
    }

    public String getURL() {
        return this.url;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.firstWarning;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.CLOSED;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.READONLY;
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException(resources.getString("invalidTimeout") + n);
        }
        return !this.CLOSED;
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007, 2);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string, n, n2, this.getHoldability());
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new SQLException(resources.getString(notSupported));
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new SQLException(resources.getString(notSupported));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return new PreparedStatementImpl(this, this.connection, n, n2, string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return new PreparedStatementImpl(this, this.connection, n, n2, string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString(notSupported));
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString(notSupported));
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString(notSupported));
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        if (this.autoCommit) {
            throw new SQLException(resources.getString("rollbackError"));
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString(notSupported));
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.autoCommit = bl;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        this.clientInfo.setProperty(string, string2);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.clientInfo = properties;
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.rsHoldability = n;
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.READONLY = bl;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        return null;
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString(notSupported));
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.typemap = map;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw new SQLException(resources.getString("abortExecutorError"));
        }
        this.close();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString(notSupported));
    }

    @Override
    public String getSchema() {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString(notSupported));
    }

    @Override
    public void setSchema(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString(notSupported));
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString(notSupported));
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(resources.getString(notSupported));
    }

    protected void checkClosed() throws SQLException {
        if (this.CLOSED) {
            throw new SQLException(resources.getString("closedError"));
        }
    }
}

