/*
 * Decompiled with CFR 0.152.
 */
package unity.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.AnnotatedSourceForeignKey;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceDatabase;
import unity.annotation.SourceField;
import unity.annotation.SourceForeignKey;
import unity.annotation.SourceKey;
import unity.annotation.SourceTable;
import unity.jdbc.LocalResultSet;
import unity.jdbc.UnityConnection;
import unity.jdbc.UnityDriver;
import unity.util.StringFunc;

public class UnityDatabaseMetaData
implements DatabaseMetaData {
    private String CATALOG_NAME = "unity";
    protected UnityConnection conn;
    protected GlobalSchema gs;

    public UnityDatabaseMetaData(GlobalSchema globalSchema, UnityConnection unityConnection) {
        this.gs = globalSchema;
        this.conn = unityConnection;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        int n = 21;
        String[] stringArray = new String[n];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(n);
        arrayList.add(new SourceField(null, null, null, "TYPE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "ATTR_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "DATA_TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "ATTR_TYPE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList.add(new SourceField(null, null, null, "ATTR_SIZE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 7, "YES"));
        arrayList.add(new SourceField(null, null, null, "DECIMAL_DIGITS", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 8, "YES"));
        arrayList.add(new SourceField(null, null, null, "NUM_PREC_RADIX", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 9, "YES"));
        arrayList.add(new SourceField(null, null, null, "NULLABLE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 10, "YES"));
        arrayList.add(new SourceField(null, null, null, "REMARKS", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 11, "YES"));
        arrayList.add(new SourceField(null, null, null, "ATTR_DEF", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 12, "YES"));
        arrayList.add(new SourceField(null, null, null, "SQL_DATA_TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 13, "YES"));
        arrayList.add(new SourceField(null, null, null, "SQL_DATETIME_SUB", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 14, "YES"));
        arrayList.add(new SourceField(null, null, null, "CHAR_OCTET_LENGTH", 4, "INTEGER", 255, 0, 0, 0, "", null, 0, 15, "YES"));
        arrayList.add(new SourceField(null, null, null, "ORDINAL_POSITION", 4, "INTEGER", 255, 0, 0, 0, "", null, 0, 16, "YES"));
        arrayList.add(new SourceField(null, null, null, "IS_NULLABLE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 17, "YES"));
        arrayList.add(new SourceField(null, null, null, "SCOPE_CATALOG", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 18, "YES"));
        arrayList.add(new SourceField(null, null, null, "SCOPE_SCHEMA", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 19, "YES"));
        arrayList.add(new SourceField(null, null, null, "SCOPE_TABLE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 20, "YES"));
        arrayList.add(new SourceField(null, null, null, "SOURCE_DATA_TYPE", 4, "INTEGER", 255, 0, 0, 0, "", null, 0, 21, "YES"));
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        String[] stringArray = new String[8];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(10);
        arrayList.add(new SourceField(null, null, null, "SCOPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "COLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "DATA_TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "COLUMN_SIZE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "BUFFER_LENGTH", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList.add(new SourceField(null, null, null, "DECIMAL_DIGITS", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 7, "YES"));
        arrayList.add(new SourceField(null, null, null, "PSEUDO_COLUMN", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 8, "YES"));
        for (int i = 0; i < 8; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        String[] stringArray = new String[1];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(1);
        arrayList.add(new SourceField(null, null, null, "TABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        for (int i = 0; i < 1; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        ArrayList<String> arrayList3 = new ArrayList<String>(1);
        arrayList3.add(this.CATALOG_NAME);
        arrayList2.add(arrayList3);
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "catalog";
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        int n = 4;
        String[] stringArray = new String[n];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(n);
        arrayList.add(new SourceField(null, null, null, "NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "MAX_LEN", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "DEFAULT_VALUE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "DESCRIPTION", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        String[] stringArray = new String[8];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(10);
        arrayList.add(new SourceField(null, null, null, "TABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "TABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "TABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "COLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "GRANTOR", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "GRANTEE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList.add(new SourceField(null, null, null, "PRIVILEGE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 7, "YES"));
        arrayList.add(new SourceField(null, null, null, "IS_GRANTABLE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 8, "YES"));
        for (int i = 0; i < 8; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        int n = 22;
        String[] stringArray = new String[n];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(n);
        arrayList.add(new SourceField(null, null, null, "TABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "TABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "TABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "COLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "DATA_TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList.add(new SourceField(null, null, null, "COLUMN_SIZE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 7, "YES"));
        arrayList.add(new SourceField(null, null, null, "BUFFER_LENGTH", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 8, "YES"));
        arrayList.add(new SourceField(null, null, null, "DECIMAL_DIGITS", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 9, "YES"));
        arrayList.add(new SourceField(null, null, null, "NUM_PREC_RADIX", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 10, "YES"));
        arrayList.add(new SourceField(null, null, null, "NULLABLE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 11, "YES"));
        arrayList.add(new SourceField(null, null, null, "REMARKS", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 12, "YES"));
        arrayList.add(new SourceField(null, null, null, "COLUMN_DEF", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 13, "YES"));
        arrayList.add(new SourceField(null, null, null, "SQL_DATA_TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 14, "YES"));
        arrayList.add(new SourceField(null, null, null, "SQL_DATETIME_SUB", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 15, "YES"));
        arrayList.add(new SourceField(null, null, null, "CHAR_OCTET_LENGTH", 4, "INTEGER", 255, 0, 0, 0, "", null, 0, 16, "YES"));
        arrayList.add(new SourceField(null, null, null, "ORDINAL_POSITION", 4, "INTEGER", 255, 0, 0, 0, "", null, 0, 17, "YES"));
        arrayList.add(new SourceField(null, null, null, "IS_NULLABLE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 18, "YES"));
        arrayList.add(new SourceField(null, null, null, "SCOPE_CATALOG", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 19, "YES"));
        arrayList.add(new SourceField(null, null, null, "SCOPE_SCHEMA", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 20, "YES"));
        arrayList.add(new SourceField(null, null, null, "SCOPE_TABLE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 21, "YES"));
        arrayList.add(new SourceField(null, null, null, "SOURCE_DATA_TYPE", 4, "INTEGER", 255, 0, 0, 0, "", null, 0, 22, "YES"));
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        ArrayList<SourceDatabase> arrayList3 = this.gs.getAnnotatedDatabasesByName();
        String string5 = StringFunc.convertSQLPatternToJavaPattern(string2);
        String string6 = StringFunc.convertSQLPatternToJavaPattern(string3);
        String string7 = StringFunc.convertSQLPatternToJavaPattern(string4);
        for (int i = 0; i < arrayList3.size(); ++i) {
            AnnotatedSourceDatabase annotatedSourceDatabase = (AnnotatedSourceDatabase)arrayList3.get(i);
            String string8 = annotatedSourceDatabase.getDatabaseName();
            if (string != null && !string.equals("") && !string.equals(this.CATALOG_NAME) || !StringFunc.compareIdentifierToPattern(string8, string5)) continue;
            ArrayList<SourceTable> arrayList4 = annotatedSourceDatabase.getSourceTablesByName();
            for (SourceTable sourceTable : arrayList4) {
                String string9 = sourceTable.getTableName();
                if (!StringFunc.compareIdentifierToPattern(string9, string6)) continue;
                ArrayList<SourceField> arrayList5 = sourceTable.getSourceFieldsByPosition();
                for (SourceField sourceField : arrayList5) {
                    String string10 = sourceField.getColumnName();
                    if (!StringFunc.compareIdentifierToPattern(string10, string7)) continue;
                    ArrayList<Object> arrayList6 = new ArrayList<Object>(n);
                    arrayList6.add(this.CATALOG_NAME);
                    arrayList6.add(string8);
                    arrayList6.add(StringFunc.undelimitName(string9, '\"'));
                    arrayList6.add(StringFunc.undelimitName(string10, '\"'));
                    arrayList6.add(new Integer(sourceField.getDataType()));
                    arrayList6.add(sourceField.getDataTypeName().toUpperCase());
                    arrayList6.add(sourceField.getColumnSize());
                    arrayList6.add(null);
                    arrayList6.add(new Integer(sourceField.getDecimalDigits()));
                    arrayList6.add(new Integer(10));
                    arrayList6.add(new Integer(sourceField.getNullable()));
                    arrayList6.add(sourceField.getRemarks());
                    arrayList6.add(null);
                    arrayList6.add(new Integer(sourceField.getDataType()));
                    arrayList6.add(0);
                    arrayList6.add(new Integer(sourceField.getCharacterOctetLength()));
                    arrayList6.add(new Integer(sourceField.getOrdinalPosition()));
                    arrayList6.add(sourceField.getIsNullable());
                    arrayList6.add(null);
                    arrayList6.add(null);
                    arrayList6.add(null);
                    arrayList6.add(new Integer(sourceField.getDataType()));
                    arrayList2.add(arrayList6);
                }
            }
        }
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        int n = 14;
        String[] stringArray = new String[n];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(n);
        arrayList.add(new SourceField(null, null, null, "PKTABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "PKTABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "PKTABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "PKCOLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "FKTABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "FKTABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList.add(new SourceField(null, null, null, "FKTABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 7, "YES"));
        arrayList.add(new SourceField(null, null, null, "PKCOLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 8, "YES"));
        arrayList.add(new SourceField(null, null, null, "KEY_SEQ", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 9, "YES"));
        arrayList.add(new SourceField(null, null, null, "UPDATE_RULE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 10, "YES"));
        arrayList.add(new SourceField(null, null, null, "DELETE_RULE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 11, "YES"));
        arrayList.add(new SourceField(null, null, null, "FK_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 12, "YES"));
        arrayList.add(new SourceField(null, null, null, "PK_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 13, "YES"));
        arrayList.add(new SourceField(null, null, null, "DEFERRABILITY", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 14, "YES"));
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 2;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "UnityJDBC";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return "4.2.243";
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return 4;
    }

    @Override
    public int getDriverMinorVersion() {
        return 2;
    }

    @Override
    public String getDriverName() throws SQLException {
        return "UnityJDBC";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "4.2.243";
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        String string4 = string2 != null ? string2 + '.' + string3 : string3;
        ArrayList<AnnotatedSourceTable> arrayList = this.gs.findTable(string2, string3);
        if (arrayList == null) {
            throw new SQLException(UnityDriver.i18n.getString("UnityDatabaseMetaData.ErrorTableNameNotFound") + string4);
        }
        if (arrayList.size() > 1) {
            // empty if block
        }
        AnnotatedSourceTable annotatedSourceTable = arrayList.get(0);
        AnnotatedSourceDatabase annotatedSourceDatabase = (AnnotatedSourceDatabase)annotatedSourceTable.getParentDatabase();
        int n = 14;
        String[] stringArray = new String[n];
        ArrayList<SourceField> arrayList2 = new ArrayList<SourceField>(n);
        arrayList2.add(new SourceField(null, null, null, "PKTABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList2.add(new SourceField(null, null, null, "PKTABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList2.add(new SourceField(null, null, null, "PKTABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList2.add(new SourceField(null, null, null, "PKCOLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList2.add(new SourceField(null, null, null, "FKTABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList2.add(new SourceField(null, null, null, "FKTABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList2.add(new SourceField(null, null, null, "FKTABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 7, "YES"));
        arrayList2.add(new SourceField(null, null, null, "FKCOLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 8, "YES"));
        arrayList2.add(new SourceField(null, null, null, "KEY_SEQ", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 9, "YES"));
        arrayList2.add(new SourceField(null, null, null, "UPDATE_RULE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 10, "YES"));
        arrayList2.add(new SourceField(null, null, null, "DELETE_RULE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 11, "YES"));
        arrayList2.add(new SourceField(null, null, null, "FK_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 12, "YES"));
        arrayList2.add(new SourceField(null, null, null, "PK_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 13, "YES"));
        arrayList2.add(new SourceField(null, null, null, "DEFERRABILITY", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 14, "YES"));
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((SourceField)arrayList2.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList3 = new ArrayList<ArrayList<Object>>();
        ArrayList<SourceDatabase> arrayList4 = this.gs.getAnnotatedDatabasesByName();
        for (int i = 0; i < arrayList4.size(); ++i) {
            annotatedSourceDatabase = (AnnotatedSourceDatabase)arrayList4.get(i);
            ArrayList<SourceTable> arrayList5 = annotatedSourceDatabase.getSourceTablesByName();
            for (SourceTable sourceTable : arrayList5) {
                ArrayList<SourceForeignKey> arrayList6 = sourceTable.getForeignKeys();
                for (int j = 0; j < arrayList6.size(); ++j) {
                    AnnotatedSourceForeignKey annotatedSourceForeignKey = (AnnotatedSourceForeignKey)arrayList6.get(j);
                    if (annotatedSourceForeignKey.getToSourceTable() != annotatedSourceTable) continue;
                    ArrayList<SourceField> arrayList7 = annotatedSourceForeignKey.getFields();
                    SourceKey sourceKey = annotatedSourceForeignKey.getToKey();
                    ArrayList<SourceField> arrayList8 = sourceKey.getFields();
                    for (int k = 0; k < arrayList7.size(); ++k) {
                        SourceField sourceField = arrayList7.get(k);
                        ArrayList<Object> arrayList9 = new ArrayList<Object>(n);
                        arrayList9.add(this.CATALOG_NAME);
                        arrayList9.add(StringFunc.undelimitName(sourceKey.getTable().getParentDatabase().getDatabaseName(), '\"'));
                        arrayList9.add(StringFunc.undelimitName(sourceKey.getTable().getTableName(), '\"'));
                        arrayList9.add(StringFunc.undelimitName(arrayList8.get(k).getColumnName(), '\"'));
                        arrayList9.add(this.CATALOG_NAME);
                        arrayList9.add(annotatedSourceForeignKey.getTable().getParentDatabase().getDatabaseName());
                        arrayList9.add(StringFunc.undelimitName(annotatedSourceForeignKey.getTable().getTableName(), '\"'));
                        arrayList9.add(StringFunc.undelimitName(sourceField.getColumnName(), '\"'));
                        arrayList9.add(new Integer(k));
                        arrayList9.add(new Integer(0));
                        arrayList9.add(new Integer(0));
                        arrayList9.add(annotatedSourceForeignKey.getName());
                        arrayList9.add(sourceKey.getName());
                        arrayList9.add(new Integer(0));
                        arrayList3.add(arrayList9);
                    }
                }
            }
        }
        return new LocalResultSet(arrayList3, stringArray, arrayList2);
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        int n = 17;
        String[] stringArray = new String[n];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(n);
        arrayList.add(new SourceField(null, null, null, "FUNCTION_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "FUNCTION_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "FUNCTION_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "COLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "COLUMN_TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "DATA_TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 7, "YES"));
        arrayList.add(new SourceField(null, null, null, "PRECISION", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 8, "YES"));
        arrayList.add(new SourceField(null, null, null, "LENGTH", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 9, "YES"));
        arrayList.add(new SourceField(null, null, null, "SCALE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 10, "YES"));
        arrayList.add(new SourceField(null, null, null, "RADIX", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 11, "YES"));
        arrayList.add(new SourceField(null, null, null, "NULLABLE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 12, "YES"));
        arrayList.add(new SourceField(null, null, null, "REMARKS", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 13, "YES"));
        arrayList.add(new SourceField(null, null, null, "CHAR_OCTET_LENGTH", 4, "INTEGER", 255, 0, 0, 0, "", null, 0, 14, "YES"));
        arrayList.add(new SourceField(null, null, null, "ORDINAL_POSITION", 4, "INTEGER", 255, 0, 0, 0, "", null, 0, 15, "YES"));
        arrayList.add(new SourceField(null, null, null, "IS_NULLABLE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 16, "YES"));
        arrayList.add(new SourceField(null, null, null, "SPECIFIC_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 17, "YES"));
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        int n = 6;
        String[] stringArray = new String[n];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(n);
        arrayList.add(new SourceField(null, null, null, "FUNCITON_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "FUNCITON_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "FUNCITON_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "REMARKS", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "FUNCTION_TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "SPECIFIC_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        String string4 = string2 != null ? string2 + "." + string3 : string3;
        ArrayList<AnnotatedSourceTable> arrayList = this.gs.findTable(string2, string3);
        if (arrayList == null) {
            throw new SQLException(UnityDriver.i18n.getString("UnityDatabaseMetaData.ErrorTableNameNotFound") + string4);
        }
        if (arrayList.size() > 1) {
            // empty if block
        }
        int n = 14;
        String[] stringArray = new String[n];
        ArrayList<SourceField> arrayList2 = new ArrayList<SourceField>(n);
        arrayList2.add(new SourceField(null, null, null, "PKTABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList2.add(new SourceField(null, null, null, "PKTABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList2.add(new SourceField(null, null, null, "PKTABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList2.add(new SourceField(null, null, null, "PKCOLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList2.add(new SourceField(null, null, null, "FKTABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList2.add(new SourceField(null, null, null, "FKTABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList2.add(new SourceField(null, null, null, "FKTABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 7, "YES"));
        arrayList2.add(new SourceField(null, null, null, "FKCOLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 8, "YES"));
        arrayList2.add(new SourceField(null, null, null, "KEY_SEQ", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 9, "YES"));
        arrayList2.add(new SourceField(null, null, null, "UPDATE_RULE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 10, "YES"));
        arrayList2.add(new SourceField(null, null, null, "DELETE_RULE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 11, "YES"));
        arrayList2.add(new SourceField(null, null, null, "FK_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 12, "YES"));
        arrayList2.add(new SourceField(null, null, null, "PK_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 13, "YES"));
        arrayList2.add(new SourceField(null, null, null, "DEFERRABILITY", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 14, "YES"));
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((SourceField)arrayList2.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList3 = new ArrayList<ArrayList<Object>>();
        AnnotatedSourceTable annotatedSourceTable = arrayList.get(0);
        ArrayList<SourceForeignKey> arrayList4 = annotatedSourceTable.getForeignKeys();
        for (int i = 0; i < arrayList4.size(); ++i) {
            AnnotatedSourceForeignKey annotatedSourceForeignKey = (AnnotatedSourceForeignKey)arrayList4.get(i);
            ArrayList<SourceField> arrayList5 = annotatedSourceForeignKey.getFields();
            SourceKey sourceKey = annotatedSourceForeignKey.getToKey();
            if (sourceKey == null) continue;
            ArrayList<SourceField> arrayList6 = sourceKey.getFields();
            for (int j = 0; j < arrayList5.size(); ++j) {
                SourceField sourceField = arrayList5.get(j);
                ArrayList<Object> arrayList7 = new ArrayList<Object>(n);
                arrayList7.add(this.CATALOG_NAME);
                arrayList7.add(sourceKey.getTable().getParentDatabase().getDatabaseName());
                arrayList7.add(StringFunc.undelimitName(sourceKey.getTable().getTableName(), '\"'));
                arrayList7.add(StringFunc.undelimitName(arrayList6.get(j).getColumnName(), '\"'));
                arrayList7.add(this.CATALOG_NAME);
                arrayList7.add(annotatedSourceForeignKey.getTable().getParentDatabase().getDatabaseName());
                arrayList7.add(StringFunc.undelimitName(annotatedSourceForeignKey.getTable().getTableName(), '\"'));
                arrayList7.add(StringFunc.undelimitName(sourceField.getColumnName(), '\"'));
                arrayList7.add(new Integer(j));
                arrayList7.add(new Integer(0));
                arrayList7.add(new Integer(0));
                arrayList7.add(annotatedSourceForeignKey.getName());
                arrayList7.add(sourceKey.getName());
                arrayList7.add(new Integer(0));
                arrayList3.add(arrayList7);
            }
        }
        return new LocalResultSet(arrayList3, stringArray, arrayList2);
    }

    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        int n = 13;
        String[] stringArray = new String[n];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(n);
        arrayList.add(new SourceField(null, null, null, "TABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "TABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "TABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "NON_UNIQUE", -7, "BOOLEAN", 1, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "INDEX_QUALIFIER", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "INDEX_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 7, "YES"));
        arrayList.add(new SourceField(null, null, null, "ORDINAL_POSITION", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 8, "YES"));
        arrayList.add(new SourceField(null, null, null, "COLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 9, "YES"));
        arrayList.add(new SourceField(null, null, null, "ASC_OR_DESC", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 10, "YES"));
        arrayList.add(new SourceField(null, null, null, "CARDINALITY", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 11, "YES"));
        arrayList.add(new SourceField(null, null, null, "PAGES", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 12, "YES"));
        arrayList.add(new SourceField(null, null, null, "FILTER_CONDITION", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 13, "YES"));
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 2;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 1000;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "MAX,MIN,SUM,AVG,COUNT,ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,INC,LN,LOG,LOG10,MOD,PI,POWER,RADIANS,RAND,RANDOM,ROUND,SIGN,SIN,SQRT,TAN";
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        String string4 = string2 != null && !string2.equals("") ? string2 + "." + string3 : string3;
        ArrayList<AnnotatedSourceTable> arrayList = this.gs.findTable(string2, string3);
        if (arrayList == null) {
            throw new SQLException(UnityDriver.i18n.getString("UnityDatabaseMetaData.ErrorTableNameNotFound") + string4);
        }
        if (arrayList.size() > 1) {
            throw new SQLException(UnityDriver.i18n.getString("UnityDatabaseMetaData.ErrorAmbiguousTableName") + string4);
        }
        int n = 6;
        String[] stringArray = new String[n];
        ArrayList<SourceField> arrayList2 = new ArrayList<SourceField>(n);
        arrayList2.add(new SourceField(null, null, null, "TABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList2.add(new SourceField(null, null, null, "TABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList2.add(new SourceField(null, null, null, "TABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList2.add(new SourceField(null, null, null, "COLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList2.add(new SourceField(null, null, null, "KEY_SEQ", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList2.add(new SourceField(null, null, null, "PK_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((SourceField)arrayList2.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList3 = new ArrayList<ArrayList<Object>>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>(n);
        AnnotatedSourceTable annotatedSourceTable = arrayList.get(0);
        SourceKey sourceKey = annotatedSourceTable.getPrimaryKey();
        if (sourceKey != null) {
            ArrayList<SourceField> arrayList5 = sourceKey.getFields();
            string4 = StringFunc.undelimitName(annotatedSourceTable.getTableName(), '\"');
            for (int i = 0; i < arrayList5.size(); ++i) {
                SourceField sourceField = arrayList5.get(i);
                arrayList4 = new ArrayList(n);
                arrayList4.add(this.CATALOG_NAME);
                arrayList4.add(annotatedSourceTable.getParentDatabase().getDatabaseName());
                arrayList4.add(string4);
                arrayList4.add(StringFunc.undelimitName(sourceField.getColumnName(), '\"'));
                arrayList4.add(new Integer(i));
                arrayList4.add(sourceKey.getName());
                arrayList3.add(arrayList4);
            }
        }
        return new LocalResultSet(arrayList3, stringArray, arrayList2);
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        String[] stringArray = new String[20];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(20);
        arrayList.add(new SourceField(null, null, null, "PROCEDURE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "PROCEDURE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "PROCEDURE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "COLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "COLUMN_TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "DATA_TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 7, "YES"));
        arrayList.add(new SourceField(null, null, null, "PRECISION", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 8, "YES"));
        arrayList.add(new SourceField(null, null, null, "LENGTH", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 9, "YES"));
        arrayList.add(new SourceField(null, null, null, "SCALE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 10, "YES"));
        arrayList.add(new SourceField(null, null, null, "RADIX", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 11, "YES"));
        arrayList.add(new SourceField(null, null, null, "NULLABLE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 12, "YES"));
        arrayList.add(new SourceField(null, null, null, "REMARKS", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 13, "YES"));
        arrayList.add(new SourceField(null, null, null, "COLUMN_DEF", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 14, "YES"));
        arrayList.add(new SourceField(null, null, null, "SQL_DATA_TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 15, "YES"));
        arrayList.add(new SourceField(null, null, null, "SQL_DATETIME_SUB", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 16, "YES"));
        arrayList.add(new SourceField(null, null, null, "CHAR_OCTET_LENGTH", 4, "INTEGER", 255, 0, 0, 0, "", null, 0, 17, "YES"));
        arrayList.add(new SourceField(null, null, null, "ORDINAL_POSITION", 4, "INTEGER", 255, 0, 0, 0, "", null, 0, 18, "YES"));
        arrayList.add(new SourceField(null, null, null, "IS_NULLABLE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 19, "YES"));
        arrayList.add(new SourceField(null, null, null, "SPECIFIC_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 20, "YES"));
        for (int i = 0; i < 20; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        String[] stringArray = new String[9];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(10);
        arrayList.add(new SourceField(null, null, null, "PROCEDURE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "PROCEDURE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "PROCEDURE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "reserved1", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "reserved2", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "reserved3", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList.add(new SourceField(null, null, null, "REMARKS", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 7, "YES"));
        arrayList.add(new SourceField(null, null, null, "PROCEDURE_TYPE", 5, "SMALLINT", 10, 0, 0, 0, "", null, 0, 8, "YES"));
        arrayList.add(new SourceField(null, null, null, "SPECIFIC_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 9, "YES"));
        for (int i = 0; i < 9; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "procedure";
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        return null;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        String[] stringArray = new String[2];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(2);
        arrayList.add(new SourceField(null, null, null, "TABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "TABLE_CATALOG", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        for (int i = 0; i < 2; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        ArrayList<SourceDatabase> arrayList3 = this.gs.getAnnotatedDatabasesByName();
        String string3 = StringFunc.convertSQLPatternToJavaPattern(string2);
        for (int i = 0; i < arrayList3.size(); ++i) {
            AnnotatedSourceDatabase annotatedSourceDatabase = (AnnotatedSourceDatabase)arrayList3.get(i);
            String string4 = annotatedSourceDatabase.getDatabaseName();
            if (!StringFunc.compareIdentifierToPattern(string4, string3)) continue;
            ArrayList<String> arrayList4 = new ArrayList<String>(2);
            arrayList4.add(string4);
            arrayList4.add(this.CATALOG_NAME);
            arrayList2.add(arrayList4);
        }
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "database";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "";
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "ASCII,BIT_LENGTH,CHAR,CHAR_LENGTH,CONCAT,CONCATENATE,INSTR,LCASE,LEFT,LEN,LENGTH,LOWER,LTRIM,OCTET_LENGTH,POSITION,REPLACE,REVERSE,RIGHT,RTRIM,SPACE,STUFF,SUBSTRING,TRIM,UCASE,UPPER";
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        String[] stringArray = new String[4];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(10);
        arrayList.add(new SourceField(null, null, null, "TYPE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "SUPERTYPE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        for (int i = 0; i < 4; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        String[] stringArray = new String[6];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(10);
        arrayList.add(new SourceField(null, null, null, "TYPE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "SUPERTYPE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "SUPERTYPE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "SUPERTYPE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        for (int i = 0; i < 6; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        String[] stringArray = new String[7];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(10);
        arrayList.add(new SourceField(null, null, null, "TABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "TABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "TABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "GRANTOR", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "GRANTEE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "PRIVILEGE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList.add(new SourceField(null, null, null, "IS_GRANTABLE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 7, "YES"));
        for (int i = 0; i < 7; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        String[] stringArray2 = new String[10];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(10);
        arrayList.add(new SourceField(null, null, null, "TABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "TABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "TABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "TABLE_TYPE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "REMARKS", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 7, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 8, "YES"));
        arrayList.add(new SourceField(null, null, null, "SELF_REFERENCING_COL_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 9, "YES"));
        arrayList.add(new SourceField(null, null, null, "REF_GENERATION", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 10, "YES"));
        for (int i = 0; i < 10; ++i) {
            stringArray2[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        ArrayList<SourceDatabase> arrayList3 = this.gs.getAnnotatedDatabasesByName();
        String string4 = StringFunc.convertSQLPatternToJavaPattern(string2);
        String string5 = StringFunc.convertSQLPatternToJavaPattern(string3);
        for (int i = 0; i < arrayList3.size(); ++i) {
            AnnotatedSourceDatabase annotatedSourceDatabase = (AnnotatedSourceDatabase)arrayList3.get(i);
            String string6 = annotatedSourceDatabase.getDatabaseName();
            if (string != null && !string.equals("") && !string.equals(this.CATALOG_NAME) || !StringFunc.compareIdentifierToPattern(string6, string4)) continue;
            ArrayList<SourceTable> arrayList4 = annotatedSourceDatabase.getSourceTablesByName();
            for (SourceTable sourceTable : arrayList4) {
                String string7 = sourceTable.getTableName();
                if (!StringFunc.compareIdentifierToPattern(string7, string5)) continue;
                ArrayList<String> arrayList5 = new ArrayList<String>(10);
                arrayList5.add(this.CATALOG_NAME);
                arrayList5.add(string6);
                arrayList5.add(StringFunc.undelimitName(string7, '\"'));
                arrayList5.add("TABLE");
                arrayList5.add(sourceTable.getComment());
                arrayList5.add(null);
                arrayList5.add(null);
                arrayList5.add(null);
                arrayList5.add(null);
                arrayList5.add(null);
                arrayList2.add(arrayList5);
            }
        }
        return new LocalResultSet(arrayList2, stringArray2, arrayList);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        String[] stringArray = new String[1];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(1);
        arrayList.add(new SourceField(null, null, null, "TABLE_TYPE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        stringArray[0] = ((SourceField)arrayList.get(0)).getColumnName();
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        ArrayList<String> arrayList3 = new ArrayList<String>(1);
        arrayList3.add("TABLE");
        arrayList2.add(arrayList3);
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "ADDDATE,ADDTIME,CURDATE,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURTIME,DATEADD,DATEDIFF,DAY,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,GETDATE,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,WEEK,YEAR";
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        String[] stringArray = new String[18];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(1);
        arrayList.add(new SourceField(null, null, null, "TYPE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "DATA_TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "PRECISION", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "LITERAL_PREFIX", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "LITERAL_SUFFIX", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "CREATE_PARAMS", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList.add(new SourceField(null, null, null, "NULLABLE", 5, "SMALLINT", 10, 0, 0, 0, "", null, 0, 7, "YES"));
        arrayList.add(new SourceField(null, null, null, "CASE_SENSITIVE", 16, "BOOLEAN", 1, 0, 0, 0, "", null, 0, 8, "YES"));
        arrayList.add(new SourceField(null, null, null, "SEARCHABLE", 5, "SMALLINT", 10, 0, 0, 0, "", null, 0, 9, "YES"));
        arrayList.add(new SourceField(null, null, null, "UNSIGNED_ATTRIBUTE", 16, "BOOLEAN", 1, 0, 0, 0, "", null, 0, 10, "YES"));
        arrayList.add(new SourceField(null, null, null, "FIXED_PREC_SCALE", 16, "BOOLEAN", 1, 0, 0, 0, "", null, 0, 11, "YES"));
        arrayList.add(new SourceField(null, null, null, "AUTO_INCREMENT", 16, "BOOLEAN", 1, 0, 0, 0, "", null, 0, 12, "YES"));
        arrayList.add(new SourceField(null, null, null, "LOCAL_TYPE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 13, "YES"));
        arrayList.add(new SourceField(null, null, null, "MINIMUM_SCALE", 5, "SMALLINT", 10, 0, 0, 0, "", null, 0, 14, "YES"));
        arrayList.add(new SourceField(null, null, null, "MAXIMUM_SCALE", 5, "SMALLINT", 10, 0, 0, 0, "", null, 0, 15, "YES"));
        arrayList.add(new SourceField(null, null, null, "SQL_DATA_TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 16, "YES"));
        arrayList.add(new SourceField(null, null, null, "SQL_DATETIME_SUB", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 17, "YES"));
        arrayList.add(new SourceField(null, null, null, "NUM_PREC_RADIX", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 18, "YES"));
        for (int i = 0; i < 18; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>(18);
        arrayList3.add("BIT");
        arrayList3.add(new Integer(-7));
        arrayList3.add(new Integer(1));
        arrayList3.add(null);
        arrayList3.add(null);
        arrayList3.add(null);
        arrayList3.add(new Short(1));
        arrayList3.add(Boolean.FALSE);
        arrayList3.add(new Short(2));
        arrayList3.add(null);
        arrayList3.add(Boolean.FALSE);
        arrayList3.add(null);
        arrayList3.add("BIT");
        arrayList3.add(new Short(0));
        arrayList3.add(new Short(0));
        arrayList3.add(null);
        arrayList3.add(null);
        arrayList3.add(null);
        arrayList2.add(arrayList3);
        arrayList3 = new ArrayList(18);
        arrayList3.add("INTEGER");
        arrayList3.add(new Integer(10));
        arrayList3.add(null);
        arrayList3.add(null);
        arrayList3.add(null);
        arrayList3.add(null);
        arrayList3.add(new Short(1));
        arrayList3.add(Boolean.FALSE);
        arrayList3.add(new Short(2));
        arrayList3.add(null);
        arrayList3.add(Boolean.FALSE);
        arrayList3.add(null);
        arrayList3.add("INTEGER");
        arrayList3.add(new Short(0));
        arrayList3.add(new Short(0));
        arrayList3.add(null);
        arrayList3.add(null);
        arrayList3.add(null);
        arrayList2.add(arrayList3);
        arrayList3 = new ArrayList(18);
        arrayList3.add("VARCHAR");
        arrayList3.add(new Integer(12));
        arrayList3.add(null);
        arrayList3.add(null);
        arrayList3.add(null);
        arrayList3.add(null);
        arrayList3.add(new Short(1));
        arrayList3.add(Boolean.FALSE);
        arrayList3.add(new Short(2));
        arrayList3.add(null);
        arrayList3.add(Boolean.FALSE);
        arrayList3.add(null);
        arrayList3.add("VARCHAR");
        arrayList3.add(new Short(0));
        arrayList3.add(new Short(0));
        arrayList3.add(null);
        arrayList3.add(null);
        arrayList3.add(null);
        arrayList2.add(arrayList3);
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        int n = 6;
        String[] stringArray = new String[n];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(n);
        arrayList.add(new SourceField(null, null, null, "TABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "CLASS_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "DATA_TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "REMARKS", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList.add(new SourceField(null, null, null, "BASE_TYPE", 5, "SMALLINT", 10, 0, 0, 0, "", null, 0, 6, "YES"));
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public String getURL() throws SQLException {
        return this.gs.getSourcesURL();
    }

    @Override
    public String getUserName() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        String[] stringArray = new String[8];
        ArrayList<SourceField> arrayList = new ArrayList<SourceField>(10);
        arrayList.add(new SourceField(null, null, null, "SCOPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 1, "YES"));
        arrayList.add(new SourceField(null, null, null, "COLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        arrayList.add(new SourceField(null, null, null, "DATA_TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 3, "YES"));
        arrayList.add(new SourceField(null, null, null, "TYPE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        arrayList.add(new SourceField(null, null, null, "COLUMN_SIZE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 5, "YES"));
        arrayList.add(new SourceField(null, null, null, "BUFFER_LENGTH", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 6, "YES"));
        arrayList.add(new SourceField(null, null, null, "DECIMAL_DIGITS", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 7, "YES"));
        arrayList.add(new SourceField(null, null, null, "PSEUDO_COLUMN", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 8, "YES"));
        for (int i = 0; i < 8; ++i) {
            stringArray[i] = ((SourceField)arrayList.get(i)).getColumnName();
        }
        ArrayList<ArrayList<Object>> arrayList2 = new ArrayList<ArrayList<Object>>();
        return new LocalResultSet(arrayList2, stringArray, arrayList);
    }

    @Override
    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return !this.nullsAreSortedHigh();
    }

    @Override
    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return true;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int n, int n2) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        return n != 1005;
    }

    @Override
    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetType(int n) throws SQLException {
        return n != 1005;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return (T)this;
    }

    @Override
    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return true;
    }

    public void setCatalogName(String string) {
        this.CATALOG_NAME = string;
    }
}

