/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import unity.engine.Tuple;
import unity.io.FileManager;
import unity.jdbc.UnityDriver;
import unity.operators.Operator;
import unity.predicates.SortComparator;
import unity.query.LQNode;

public class MergeSort
extends Operator {
    private static final long serialVersionUID = 1L;
    private Tuple[] buffer;
    private int arraySize;
    private BufferedOutputStream outFile;
    private BufferedInputStream[] mergeFile;
    private ArrayList<String> mergeFileName;
    private int numFiles;
    private boolean onePass;
    private int curTuple;
    private SortComparator sorter;
    private Operator input;
    private int tupleCount;

    public MergeSort(Operator operator, long l, SortComparator sortComparator, LQNode lQNode) {
        super(new Operator[]{operator}, l);
        this.queryNode = lQNode;
        this.mergeFileName = new ArrayList(20);
        this.input = operator;
        this.sorter = sortComparator;
        long l2 = l;
        if (l < 1000000L) {
            l2 = 1000000L;
        }
        this.arraySize = (int)(l2 / (long)operator.getOutputRelation().calculateSize());
        if (this.arraySize < 10000) {
            this.arraySize = 10000;
        }
        this.setOutputRelation(operator.getOutputRelation());
    }

    @Override
    public void init() throws SQLException {
        this.input.init();
        this.partition();
        if (!this.onePass) {
            this.mergeFile = new BufferedInputStream[this.numFiles];
            for (int i = 0; i < this.numFiles; ++i) {
                try {
                    this.mergeFile[i] = FileManager.openInputFile(this.mergeFileName.get(i));
                }
                catch (IOException iOException) {
                    throw new SQLException(iOException);
                }
                this.buffer[i] = new Tuple(this.input.getOutputRelation());
                if (this.buffer[i].read(this.mergeFile[i])) {
                    continue;
                }
                break;
            }
        } else {
            this.curTuple = 0;
        }
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        if (this.onePass) {
            if (this.curTuple < this.tupleCount) {
                tuple.copy(this.buffer[this.curTuple++]);
                return true;
            }
            return false;
        }
        if (this.numFiles > 0) {
            int n = 0;
            for (int i = 1; i < this.numFiles; ++i) {
                if (this.sorter.sqlcompare(this.buffer[i], this.buffer[n]) >= 0) continue;
                n = i;
            }
            tuple.copy(this.buffer[n]);
            if (!this.buffer[n].read(this.mergeFile[n])) {
                try {
                    FileManager.closeFile(this.mergeFile[n]);
                }
                catch (IOException iOException) {
                    throw new SQLException(iOException);
                }
                --this.numFiles;
                File file = new File(this.mergeFileName.get(n));
                file.delete();
                this.buffer[n] = this.buffer[this.numFiles];
                this.mergeFile[n] = this.mergeFile[this.numFiles];
                this.mergeFileName.set(n, this.mergeFileName.get(this.numFiles));
                this.mergeFileName.remove(this.numFiles);
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        if (UnityDriver.DEBUG) {
            System.out.println("Operation: " + this.toString() + " Rows output: " + this.rowsOut + " IO bytes: " + this.IOBytes);
        }
    }

    private void partition() throws SQLException {
        ArrayList<Tuple> arrayList = new ArrayList<Tuple>(10000);
        this.numFiles = 0;
        boolean bl = false;
        do {
            int n;
            for (n = 0; n < this.arraySize; ++n) {
                Tuple tuple = new Tuple(this.outputRelation);
                if (!this.input.next(tuple)) {
                    bl = true;
                    break;
                }
                arrayList.add(tuple);
            }
            this.tupleCount = n;
            if (this.buffer == null) {
                this.buffer = new Tuple[n];
                arrayList.toArray(this.buffer);
            }
            if (this.numFiles == 0 && n < this.arraySize) {
                this.incrementRowsOut(n);
                this.onePass = true;
                this.singlePass(n);
                return;
            }
            if (n <= 0) continue;
            Arrays.sort(this.buffer, 0, n, this.sorter);
            long l = 0L;
            try {
                this.outFile = FileManager.openOutputFile(this.generateTmpFileName(this.numFiles));
                for (int i = 0; i < n; ++i) {
                    this.buffer[i].write(this.outFile);
                    l += (long)this.buffer[i].getBytes().length;
                }
                FileManager.closeFile(this.outFile);
            }
            catch (IOException iOException) {
                throw new SQLException(iOException);
            }
            this.incrementRowsOut(n);
            this.incrementIOBytes(l * 2L);
            ++this.numFiles;
        } while (!bl);
        this.input.close();
    }

    private String generateTmpFileName(int n) {
        String string = FileManager.createTempFileName("merge_run" + n);
        this.mergeFileName.add(string);
        return string;
    }

    private void singlePass(int n) throws SQLException {
        Arrays.sort(this.buffer, 0, n, this.sorter);
        this.input.close();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append("MERGE SORT: ");
        stringBuilder.append(this.sorter.toString(this.outputRelation));
        stringBuilder.append(" (BufferSize=" + this.arraySize + ")");
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        return "MERGE SORT";
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    @Override
    public double getCost() {
        long l = this.input.getRows();
        double d = 0.0;
        double d2 = this.getIO();
        if (d2 <= 0.0) {
            d += (double)l * 1.0;
        } else {
            d += (double)l * 1.0;
            d += d2 * 0.005;
        }
        return d;
    }

    @Override
    public double getIO() {
        int n;
        long l = this.input.getRows();
        if (l * (long)(n = this.input.getRowSize()) < this.MEMORY_SIZE_IN_BYTES) {
            return 0.0;
        }
        return 3L * (l * (long)n);
    }
}

