/*
 * Decompiled with CFR 0.152.
 */
package unity.predicates;

import java.sql.SQLException;
import java.util.Comparator;
import unity.engine.Relation;
import unity.engine.Tuple;

public class SortComparator
implements Comparator<Object> {
    protected int[] attrLocs;
    protected boolean[] sortAsc;
    protected int numAttrs;

    public SortComparator() {
    }

    public SortComparator(int[] nArray, boolean[] blArray) {
        this.attrLocs = nArray;
        this.sortAsc = blArray;
        this.numAttrs = nArray.length;
    }

    @Override
    public int compare(Object object, Object object2) {
        try {
            return this.sqlcompare(object, object2);
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public int sqlcompare(Object object, Object object2) throws SQLException {
        Tuple tuple = (Tuple)object;
        Tuple tuple2 = (Tuple)object2;
        if (tuple.getNumFields() != tuple2.getNumFields()) {
            return 1;
        }
        for (int i = 0; i < this.numAttrs; ++i) {
            int n;
            Comparable comparable = (Comparable)tuple.getObject(this.attrLocs[i]);
            Comparable comparable2 = (Comparable)tuple2.getObject(this.attrLocs[i]);
            if (comparable == null && comparable2 == null) continue;
            if (comparable == null || comparable2 == null) {
                n = 1;
                n = comparable == null ? -1 : 1;
                if (!this.sortAsc[i]) {
                    n = -1 * n;
                }
                return n;
            }
            n = comparable.compareTo(comparable2);
            if (this.sortAsc[i]) {
                if (n > 0) {
                    return 1;
                }
                if (n >= 0) continue;
                return -1;
            }
            if (n < 0) {
                return 1;
            }
            if (n <= 0) continue;
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("Attr: " + this.attrLocs[0]);
        if (this.sortAsc[0]) {
            stringBuilder.append(" ASC");
        } else {
            stringBuilder.append(" DESC");
        }
        for (int i = 1; i < this.attrLocs.length; ++i) {
            stringBuilder.append(", Attr: " + this.attrLocs[i]);
            if (this.sortAsc[i]) {
                stringBuilder.append(" ASC");
                continue;
            }
            stringBuilder.append(" DESC");
        }
        return stringBuilder.toString();
    }

    public String toString(Relation relation) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(relation.getAttribute(this.attrLocs[0]).getName());
        if (this.sortAsc[0]) {
            stringBuffer.append(" ASC");
        } else {
            stringBuffer.append(" DESC");
        }
        for (int i = 1; i < this.attrLocs.length; ++i) {
            stringBuffer.append(", " + relation.getAttribute(this.attrLocs[i]).getName());
            if (this.sortAsc[i]) {
                stringBuffer.append(" ASC");
                continue;
            }
            stringBuffer.append(" DESC");
        }
        return stringBuffer.toString();
    }
}

