/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.functions.CaseExpr;
import unity.functions.CaseIfExpr;
import unity.functions.Expression;
import unity.mapping.DatabaseMapping;
import unity.operators.Operator;
import unity.predicates.SelectionPredicate;
import unity.query.GQDatabaseRef;
import unity.query.GlobalQuery;
import unity.query.LQCondNode;
import unity.query.LQExprNode;
import unity.query.LQNode;
import unity.query.SubQuery;

public class LQCaseExpr
extends LQExprNode
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private LQExprNode switchExpr;
    private ArrayList<LQNode> cases;
    private ArrayList<LQExprNode> values;
    private LQExprNode elseExpr;

    public void setSwitchExpr(LQExprNode lQExprNode) {
        this.switchExpr = lQExprNode;
    }

    public void setCases(ArrayList<LQNode> arrayList) {
        this.cases = arrayList;
    }

    public void setValues(ArrayList<LQExprNode> arrayList) {
        this.values = arrayList;
    }

    public void setElseExpr(LQExprNode lQExprNode) {
        this.elseExpr = lQExprNode;
    }

    @Override
    public String generateSQL() {
        String string = "CASE (simple)";
        if (this.switchExpr == null) {
            string = "CASE";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.switchExpr != null) {
            arrayList.add(this.switchExpr.generateSQL());
        }
        for (int i = 0; i < this.cases.size(); ++i) {
            arrayList.add(this.cases.get(i).generateSQL());
            arrayList.add(this.values.get(i).generateSQL());
        }
        if (this.elseExpr != null) {
            arrayList.add(this.elseExpr.generateSQL());
        }
        return DatabaseMapping.convertUnity(string, this, arrayList, this);
    }

    @Override
    public String toString() {
        return this.generateSQL();
    }

    @Override
    public Expression buildExpression(Relation relation, Attribute attribute, GlobalQuery globalQuery, SubQuery subQuery, Operator operator) throws SQLException {
        Expression expression = null;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        Expression expression2 = null;
        for (int i = 0; i < this.values.size(); ++i) {
            LQExprNode lQExprNode = this.values.get(i);
            arrayList.add(lQExprNode.buildExpression(relation, attribute, globalQuery, subQuery, operator));
        }
        if (this.elseExpr != null) {
            expression2 = this.elseExpr.buildExpression(relation, attribute, globalQuery, subQuery, operator);
        }
        if (this.switchExpr != null) {
            expression = this.switchExpr.buildExpression(relation, attribute, globalQuery, subQuery, operator);
            ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
            for (int i = 0; i < this.cases.size(); ++i) {
                LQExprNode lQExprNode = (LQExprNode)this.cases.get(i);
                arrayList2.add(lQExprNode.buildExpression(relation, attribute, globalQuery, subQuery, operator));
            }
            CaseExpr caseExpr = new CaseExpr(expression, arrayList2, arrayList, expression2);
            attribute.setType(caseExpr.getReturnType());
            return caseExpr;
        }
        ArrayList<SelectionPredicate> arrayList3 = new ArrayList<SelectionPredicate>();
        for (int i = 0; i < this.cases.size(); ++i) {
            LQCondNode lQCondNode = (LQCondNode)this.cases.get(i);
            arrayList3.add(lQCondNode.buildSelectionPredicate(relation, globalQuery, subQuery, operator));
        }
        CaseIfExpr caseIfExpr = new CaseIfExpr(arrayList3, arrayList, expression2);
        attribute.setType(caseIfExpr.getReturnType());
        return caseIfExpr;
    }

    @Override
    public Object clone() {
        try {
            LQExprNode lQExprNode = (LQExprNode)super.clone();
            if (this.children != null) {
                lQExprNode.children = new ArrayList(this.children.size());
                for (int i = 0; i < this.children.size(); ++i) {
                    lQExprNode.children.add((LQNode)((LQNode)this.children.get(i)).clone());
                }
            } else {
                lQExprNode.children = null;
            }
            return lQExprNode;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public ArrayList<Object> getRequiredFields() {
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = null;
        if (this.switchExpr != null) {
            arrayList2 = this.switchExpr.getRequiredFields();
            arrayList.addAll(arrayList2);
        }
        if (this.cases != null) {
            for (n = 0; n < this.cases.size(); ++n) {
                arrayList2 = this.cases.get(n).getRequiredFields();
                arrayList.addAll(arrayList2);
            }
        }
        if (this.values != null) {
            for (n = 0; n < this.values.size(); ++n) {
                arrayList2 = this.values.get(n).getRequiredFields();
                arrayList.addAll(arrayList2);
            }
        }
        if (this.elseExpr != null) {
            arrayList2 = this.elseExpr.getRequiredFields();
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    @Override
    public HashSet<GQDatabaseRef> getDatabaseRefs(GQDatabaseRef gQDatabaseRef, boolean bl) {
        GQDatabaseRef gQDatabaseRef2;
        int n;
        HashSet<GQDatabaseRef> hashSet = new HashSet<GQDatabaseRef>(5);
        if (bl) {
            this.database = GQDatabaseRef.UNITYJDBC_DBREF;
            hashSet.add(this.database);
            return hashSet;
        }
        if (this.database == null) {
            this.database = gQDatabaseRef;
        }
        String string = "CASE (Simple)";
        if (this.switchExpr == null) {
            string = "CASE";
        }
        if ((n = DatabaseMapping.isSupported(string, this.database, this)) != 0 && n != 1) {
            this.database = GQDatabaseRef.UNITYJDBC_DBREF;
            hashSet.add(this.database);
            return hashSet;
        }
        if (this.switchExpr != null && (gQDatabaseRef2 = this.switchExpr.setDatabase(gQDatabaseRef, bl)) != null) {
            hashSet.add(gQDatabaseRef2);
        }
        if (this.elseExpr != null && (gQDatabaseRef2 = this.elseExpr.setDatabase(gQDatabaseRef, bl)) != null) {
            hashSet.add(gQDatabaseRef2);
        }
        for (int i = 0; i < this.cases.size(); ++i) {
            gQDatabaseRef2 = this.cases.get(i).setDatabase(gQDatabaseRef, bl);
            if (gQDatabaseRef2 != null) {
                hashSet.add(gQDatabaseRef2);
            }
            if ((gQDatabaseRef2 = this.values.get(i).setDatabase(gQDatabaseRef, bl)) == null) continue;
            hashSet.add(gQDatabaseRef2);
        }
        return hashSet;
    }
}

