/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceTable;
import unity.engine.Tuple;
import unity.operators.Operator;
import unity.parser.SimpleNode;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.GlobalQuery;
import unity.query.LQNode;
import unity.query.LQTree;
import unity.query.LocalQuery;
import unity.query.Optimizer;
import unity.util.StringFunc;

public class SubQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LQTree logicalQueryTree;
    private ArrayList<LocalQuery> localQueries;
    private ArrayList<LQNode> localQueryNodes;
    private HashMap<String, GQTableRef> tableReferences = new HashMap();
    private HashMap<String, GQDatabaseRef> databaseReferences = new HashMap();
    private HashMap<String, GQFieldRef> fieldReferences = new HashMap();
    private ArrayList<GQFieldRef> outputFieldReferences = new ArrayList();
    private int outerJoins;
    private SubQuery parent = null;
    private SimpleNode parseNodeRoot;
    private boolean correlated = false;
    private Operator operator;
    private Tuple parentTuple;
    private GlobalQuery globalQuery;

    public int numLocalQueries() {
        return this.localQueryNodes.size();
    }

    public void addTableRef(String string, GQTableRef gQTableRef) {
        if (gQTableRef.getDefiningSubquery() == null) {
            gQTableRef.setDefiningSubquery(this);
        }
        this.tableReferences.put(string, gQTableRef);
    }

    public void addDatabaseRef(String string, GQDatabaseRef gQDatabaseRef) {
        this.databaseReferences.put(string, gQDatabaseRef);
    }

    public void addFieldRef(String string, GQFieldRef gQFieldRef) {
        this.fieldReferences.put(string, gQFieldRef);
    }

    public void addDatabaseRefs(HashMap<String, GQDatabaseRef> hashMap) {
        for (Map.Entry<String, GQDatabaseRef> entry : hashMap.entrySet()) {
            this.databaseReferences.put(entry.getKey(), entry.getValue());
        }
    }

    public void addOutputFieldRef(GQFieldRef gQFieldRef) {
        this.outputFieldReferences.add(gQFieldRef);
    }

    public GQDatabaseRef getDBRef(String string) {
        return this.databaseReferences.get(string);
    }

    public GQTableRef getTableRef(String string) {
        return this.tableReferences.get(string);
    }

    public GQTableRef getTableRef(GQDatabaseRef gQDatabaseRef) {
        Iterator<Map.Entry<String, GQTableRef>> iterator = this.tableReferences.entrySet().iterator();
        while (iterator.hasNext()) {
            GQTableRef gQTableRef = iterator.next().getValue();
            if (gQTableRef.getParentDB() != gQDatabaseRef) continue;
            return gQTableRef;
        }
        return null;
    }

    public GQFieldRef getFieldRef(String string) {
        return this.fieldReferences.get(string);
    }

    public void setLogicalQueryTree(LQTree lQTree) {
        this.logicalQueryTree = lQTree;
    }

    public int getNumTableRef() {
        return this.tableReferences.size();
    }

    public int getNumFieldRef() {
        return this.fieldReferences.size();
    }

    public int getNumDBRef() {
        return this.databaseReferences.size();
    }

    public ArrayList<GQTableRef> getTableRef(AnnotatedSourceTable annotatedSourceTable) {
        Iterator<Map.Entry<String, GQTableRef>> iterator = this.tableReferences.entrySet().iterator();
        ArrayList<GQTableRef> arrayList = new ArrayList<GQTableRef>();
        while (iterator.hasNext()) {
            GQTableRef gQTableRef = iterator.next().getValue();
            if (gQTableRef.getTable() != annotatedSourceTable) continue;
            arrayList.add(gQTableRef);
        }
        return arrayList;
    }

    public ArrayList<GQFieldRef> getOutputFieldReferences() {
        return this.outputFieldReferences;
    }

    public HashMap<String, GQTableRef> getTableRefs() {
        return this.tableReferences;
    }

    public HashMap<String, GQDatabaseRef> getDBRefs() {
        return this.databaseReferences;
    }

    public HashMap<String, GQFieldRef> getFieldRefs() {
        return this.fieldReferences;
    }

    public LQTree getLogicalQueryTree() {
        return this.logicalQueryTree;
    }

    public HashMap<String, GQTableRef> filterTableRefsByDB(GQDatabaseRef gQDatabaseRef) {
        HashMap<String, GQTableRef> hashMap = new HashMap<String, GQTableRef>();
        Iterator<Map.Entry<String, GQTableRef>> iterator = this.tableReferences.entrySet().iterator();
        while (iterator.hasNext()) {
            GQTableRef gQTableRef = iterator.next().getValue();
            if (gQTableRef.getParentDB() != gQDatabaseRef) continue;
            hashMap.put(gQTableRef.getName(), gQTableRef);
        }
        return hashMap;
    }

    public GQTableRef getFirstTableRef() {
        if (this.tableReferences.size() >= 1) {
            return this.tableReferences.entrySet().iterator().next().getValue();
        }
        return null;
    }

    public GQDatabaseRef getFirstDatabaseRef() {
        if (this.databaseReferences.size() >= 1) {
            return this.databaseReferences.entrySet().iterator().next().getValue();
        }
        return null;
    }

    public ArrayList<LocalQuery> getLocalQueries() {
        return this.localQueries;
    }

    public void setLocalQueries(ArrayList<LocalQuery> arrayList) {
        this.localQueries = arrayList;
    }

    public ArrayList<Object> findFieldWithTableRefs(ArrayList<AnnotatedSourceField> arrayList) {
        ArrayList<Object> arrayList2 = new ArrayList<Object>(3);
        int n = 0;
        arrayList2.add(new Integer(n));
        for (int i = 0; i < arrayList.size(); ++i) {
            AnnotatedSourceField annotatedSourceField = arrayList.get(i);
            AnnotatedSourceTable annotatedSourceTable = (AnnotatedSourceTable)annotatedSourceField.getParentTable();
            ArrayList<GQTableRef> arrayList3 = this.getTableRef(annotatedSourceTable);
            int n2 = arrayList3.size();
            if (n2 > 0 && n > 0 || n2 > 1) {
                arrayList2.set(0, new Integer(n2 + n));
                return arrayList2;
            }
            if (n2 != 1) continue;
            arrayList2.set(0, new Integer(n2));
            arrayList2.add(arrayList3.get(0));
            arrayList2.add(annotatedSourceField);
            n += n2;
        }
        return arrayList2;
    }

    public void setOuterJoins(int n) {
        this.outerJoins = n;
    }

    public int getOuterJoins() {
        return this.outerJoins;
    }

    public void setParent(SubQuery subQuery) {
        this.parent = subQuery;
    }

    public SubQuery getParent() {
        return this.parent;
    }

    public void setParseNodeRoot(SimpleNode simpleNode) {
        this.parseNodeRoot = simpleNode;
    }

    public SimpleNode getParseNodeRoot() {
        return this.parseNodeRoot;
    }

    public ArrayList<LQNode> getLocalQueryNodes() {
        return this.localQueryNodes;
    }

    public void setLocalQueryNodes(ArrayList<LQNode> arrayList) {
        this.localQueryNodes = arrayList;
    }

    public void setOutputFieldReferences(ArrayList<GQFieldRef> arrayList) {
        this.outputFieldReferences = arrayList;
    }

    public String toString() {
        LQTree lQTree = this.getLogicalQueryTree();
        if (lQTree == null) {
            return "(SUBQUERY)";
        }
        return "(" + StringFunc.oneLineSQL(Optimizer.buildSQL(lQTree.getRoot())) + ")";
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean isCorrelated() {
        return this.correlated;
    }

    public void setCorrelated(boolean bl) {
        this.correlated = bl;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public Tuple getParentTuple() {
        return this.parentTuple;
    }

    public void setParentTuple(Tuple tuple) {
        this.parentTuple = tuple;
    }

    public GlobalQuery getGlobalQuery() {
        return this.globalQuery;
    }

    public void setGlobalQuery(GlobalQuery globalQuery) {
        this.globalQuery = globalQuery;
    }

    public void merge(SubQuery subQuery) {
    }
}

