/*
 * Decompiled with CFR 0.152.
 */
package unity.util;

import com.mongodb.BasicDBObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import unity.query.LimitInfo;

public class StringFunc {
    public static HashMap<String, Object> SQLKeywords = new HashMap();
    private static final String chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static Random generator;

    public static String spaces(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public static String verifyTerminator(String string) {
        if (string != null) {
            String string2 = string.trim();
            if (string.charAt(string.length() - 1) != ';') {
                return string2 + ";";
            }
            return string2;
        }
        return null;
    }

    public static String oneLineSQL(String string) {
        return string.replaceAll("\n", " ");
    }

    public static String identifierHashKey(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String[] stringArray = StringFunc.divideIdentifier(string);
        StringBuilder stringBuilder = new StringBuilder(50);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].contains("\"")) {
                stringBuilder.append(stringArray[i]);
            } else {
                stringBuilder.append(stringArray[i].toLowerCase());
            }
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    public static String delimitName(String string, char c) {
        String string2 = string;
        if (StringFunc.delimitedIdentifier(string2) && !StringFunc.isDelimited(string2, c)) {
            if (StringFunc.isDelimited(string2, '\"')) {
                string2 = StringFunc.undelimitName(string2, '\"');
            }
            if (StringFunc.isDelimited(string2, '[')) {
                string2 = StringFunc.undelimitName(string2, '[');
            }
            if (c == '\"') {
                return "\"" + string2.replaceAll("\\\\", "\\\\\\\\") + "\"";
            }
            if (c == '[') {
                return '[' + string2 + ']';
            }
            return c + string2 + c;
        }
        return string2;
    }

    public static String undelimitName(String string, char c) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.charAt(0) != c) {
            return string;
        }
        return string.substring(1, string.length() - 1);
    }

    public static boolean isDelimited(String string, char c) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.charAt(0) == c && string.charAt(string.length() - 1) == c || string.charAt(0) == c && c == '[' && string.charAt(string.length() - 1) == ']' || string.charAt(0) == '(';
    }

    public static String removeQuotes(String string) {
        if (string.length() >= 2 && string.charAt(0) == '\'') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String replaceQuotes(String string) {
        return "\"" + StringFunc.removeQuotes(string) + "\"";
    }

    public static String removeDoubleQuotes(String string) {
        if (string.length() >= 2 && string.charAt(0) == '\"') {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static boolean delimitedIdentifier(String string) {
        String string2 = string;
        if (string2 == null || string2.equals("")) {
            return false;
        }
        char c = string2.charAt(0);
        if (c != '_' && !Character.isLetter(c)) {
            return true;
        }
        for (int i = 1; i < string2.length(); ++i) {
            char c2 = string2.charAt(i);
            if (Character.isLetterOrDigit(c2) || c2 == '_') continue;
            return true;
        }
        return SQLKeywords.containsKey(string2 = string2.toUpperCase());
    }

    public static String[] divideIdentifier(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        int n = -1;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) == '\"') {
                StringBuilder stringBuilder = new StringBuilder();
                ++i;
                stringBuilder.append('\"');
                while (i < n2) {
                    if (string.charAt(i) == '\\') {
                        ++i;
                    } else if (string.charAt(i) == '\"') {
                        stringBuilder.append(string.charAt(i++));
                        break;
                    }
                    stringBuilder.append(string.charAt(i));
                    ++i;
                }
                arrayList.add(stringBuilder.toString());
                continue;
            }
            n = i++;
            while (i < n2 && string.charAt(i) != '.') {
                ++i;
            }
            arrayList.add(string.substring(n, i).toLowerCase());
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String formatSQLValue(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Number) {
            return object.toString();
        }
        return "'" + object.toString() + "'";
    }

    public static String replaceLimit(String string, LimitInfo limitInfo) {
        String string2 = string;
        int n = string2.toLowerCase().lastIndexOf("limit");
        if (n < 0) {
            int n2 = string2.lastIndexOf(59);
            if (n2 > 0) {
                string2 = string2.substring(0, n2);
            }
        } else {
            string2 = string2.substring(0, n - 1);
        }
        string2 = string2 + " " + limitInfo.toString();
        return string2;
    }

    public static String resultSetToString(ResultSet resultSet) throws SQLException {
        return StringFunc.resultSetToString(resultSet, Integer.MAX_VALUE);
    }

    public static String resultSetToString(ResultSet resultSet, int n) throws SQLException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(5000);
        int n3 = 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        stringBuffer.append("Total columns: " + resultSetMetaData.getColumnCount());
        stringBuffer.append('\n');
        if (resultSetMetaData.getColumnCount() > 0) {
            stringBuffer.append(resultSetMetaData.getColumnName(1));
        }
        for (n2 = 2; n2 <= resultSetMetaData.getColumnCount(); ++n2) {
            stringBuffer.append(", " + resultSetMetaData.getColumnName(n2));
        }
        stringBuffer.append('\n');
        while (resultSet.next()) {
            if (n3 < n) {
                for (n2 = 0; n2 < resultSetMetaData.getColumnCount(); ++n2) {
                    Object object = resultSet.getObject(n2 + 1);
                    if (object instanceof ArrayList) {
                        stringBuffer.append(((ArrayList)object).toString());
                    } else if (object instanceof BasicDBObject) {
                        stringBuffer.append(((BasicDBObject)object).toString());
                    } else {
                        stringBuffer.append(object);
                    }
                    if (n2 == resultSetMetaData.getColumnCount() - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append('\n');
            }
            ++n3;
        }
        stringBuffer.append("Total results: " + n3);
        return stringBuffer.toString();
    }

    public static String resultSetMetaDataToString(ResultSetMetaData resultSetMetaData) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(5000);
        stringBuffer.append(resultSetMetaData.getColumnName(1) + " " + resultSetMetaData.getColumnType(1));
        for (int i = 2; i <= resultSetMetaData.getColumnCount(); ++i) {
            stringBuffer.append(", " + resultSetMetaData.getColumnName(i) + " " + resultSetMetaData.getColumnType(i));
        }
        return stringBuffer.toString();
    }

    public static Date convertStringToDate(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = simpleDateFormat.parse(string);
            return date;
        }
        catch (Exception exception) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                Date date = simpleDateFormat.parse(string);
                return date;
            }
            catch (Exception exception2) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    Date date = simpleDateFormat.parse(string);
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTime(date);
                    gregorianCalendar.set(12, 0);
                    gregorianCalendar.set(10, 0);
                    gregorianCalendar.set(13, 0);
                    return gregorianCalendar.getTime();
                }
                catch (Exception exception3) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                        Date date = simpleDateFormat.parse(string);
                        return date;
                    }
                    catch (Exception exception4) {
                        return null;
                    }
                }
            }
        }
    }

    public static String safeSQL(String string) {
        return string.replaceAll("'", "''");
    }

    public static String convertSQLPatternToJavaPattern(String string) {
        return StringFunc.convertSQLPatternToJavaPattern(string, '\\');
    }

    public static String convertSQLPatternToJavaPattern(String string, char c) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 10);
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                if (i + 1 < string.length()) {
                    c2 = string.charAt(i + 1);
                }
                ++i;
            } else {
                if (c2 == '%') {
                    stringBuilder.append(".*");
                    continue;
                }
                if (c2 == '_') {
                    stringBuilder.append(".");
                    continue;
                }
            }
            if (c2 == '\\' || c2 == '.' || c2 == '*' || c2 == '|' || c2 == '?' || c2 == '+' || c2 == '(' || c2 == ')' || c2 == '[' || c2 == ']' || c2 == '{' || c2 == '}' || c2 == '^' || c2 == '$') {
                stringBuilder.append("\\");
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String escapeSQLPattern(String string) {
        return string.replaceAll("%", "\\\\%").replaceAll("_", "\\\\_");
    }

    public static boolean compareIdentifierToPattern(String string, String string2) {
        if (string2 == null) {
            return true;
        }
        if (string.matches(string2)) {
            return true;
        }
        if (StringFunc.identifierHashKey(string).matches(StringFunc.identifierHashKey(string2))) {
            return true;
        }
        if (string.matches("\"" + string2 + "\"")) {
            return true;
        }
        String string3 = "\"" + string + "\"";
        return string3.matches(string2);
    }

    public static String stackTrace(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        printWriter.close();
        String string = ((Object)stringWriter).toString();
        return string;
    }

    public static String randomString(int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(chars.charAt(generator.nextInt(chars.length())));
        }
        return stringBuilder.toString();
    }

    public static String randomString(int n, int n2) {
        int n3 = n;
        if (n2 > n) {
            n3 += generator.nextInt(n2 - n);
        }
        return StringFunc.randomString(n3);
    }

    public static String encodeProperties(HashMap<String, Object> hashMap) {
        StringBuilder stringBuilder = new StringBuilder(1000);
        Iterator<Map.Entry<String, Object>> iterator = hashMap.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append('\"' + entry.getKey() + "\" : ");
            Object object = entry.getValue();
            if (object == null) {
                stringBuilder.append("null");
            } else if (object instanceof Number) {
                stringBuilder.append(object.toString());
            } else {
                stringBuilder.append('\"');
                stringBuilder.append(object.toString());
                stringBuilder.append('\"');
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public static LinkedHashMap<String, Object> decodeProperties(String string) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = true;
        String string2 = null;
        for (int i = 0; i < string.length(); ++i) {
            Object object;
            char c = string.charAt(i);
            if (c == '\"') {
                if (bl) {
                    if (bl2) {
                        string2 = stringBuilder.toString();
                        stringBuilder = new StringBuilder();
                        bl2 = false;
                    } else {
                        object = StringFunc.convertStringToObject(stringBuilder.toString());
                        linkedHashMap.put(string2, object);
                        stringBuilder = new StringBuilder();
                        bl2 = true;
                    }
                    bl = false;
                    continue;
                }
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append(c);
                continue;
            }
            if (c == ':') {
                if (!bl2) continue;
                string2 = stringBuilder.toString();
                stringBuilder = new StringBuilder();
                bl2 = false;
                continue;
            }
            if (c == ',') {
                if (bl2) continue;
                object = StringFunc.convertStringToObject(stringBuilder.toString());
                linkedHashMap.put(string2, object);
                stringBuilder = new StringBuilder();
                bl2 = true;
                continue;
            }
            if (c == '{') continue;
            if (c == '}') {
                bl2 = false;
                continue;
            }
            if (c == ' ') continue;
            stringBuilder.append(c);
        }
        if (!bl2) {
            Object object = StringFunc.convertStringToObject(stringBuilder.toString());
            linkedHashMap.put(string2, object);
            stringBuilder = new StringBuilder();
            bl2 = true;
        }
        return linkedHashMap;
    }

    public static Object convertStringToObject(String string) {
        if (string == null || string.trim().equals("") || string.equals("null")) {
            return null;
        }
        try {
            int n = Integer.parseInt(string);
            return n;
        }
        catch (Exception exception) {
            try {
                double d = Double.parseDouble(string);
                return d;
            }
            catch (Exception exception2) {
                return string;
            }
        }
    }

    public static ArrayList<String> divideQueries(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = string.indexOf(59);
        while (n2 > 0) {
            arrayList.add(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf(59, n);
        }
        if (n < string.length()) {
            arrayList.add(string.substring(n));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.println(arrayList.get(i));
        }
        return arrayList;
    }

    public static ArrayList<String> parseCSVLine(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        char c = '\\';
        if (string == null) {
            return arrayList;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                if (i + 1 < string.length()) {
                    c2 = string.charAt(i + 1);
                    stringBuilder.append(c2);
                }
                ++i;
                continue;
            }
            if (c2 == '\"') {
                if (bl) {
                    if (i + 1 < string.length() && string.charAt(i + 1) == '\"') {
                        stringBuilder.append('\"');
                        ++i;
                        continue;
                    }
                    arrayList.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    bl = false;
                    bl2 = true;
                    continue;
                }
                bl = true;
                bl2 = false;
                continue;
            }
            if (bl) {
                stringBuilder.append(c2);
                continue;
            }
            if (c2 == ',') {
                if (!bl2) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    continue;
                }
                bl2 = false;
                continue;
            }
            if (c2 == ' ' && bl2) continue;
            stringBuilder.append(c2);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    public static String getURL(String string) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string2;
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
                stringBuilder.append("\n");
            }
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            throw new SQLException("Unable to retrieve data from server url: " + string + "\nException: " + exception);
        }
    }

    static {
        SQLKeywords.put("ADD", null);
        SQLKeywords.put("ALL", null);
        SQLKeywords.put("ALTER", null);
        SQLKeywords.put("AND", null);
        SQLKeywords.put("ANY", null);
        SQLKeywords.put("AS", null);
        SQLKeywords.put("ASC", null);
        SQLKeywords.put("AUTHORIZATION", null);
        SQLKeywords.put("BACKUP", null);
        SQLKeywords.put("BEGIN", null);
        SQLKeywords.put("BETWEEN", null);
        SQLKeywords.put("BREAK", null);
        SQLKeywords.put("BROWSE", null);
        SQLKeywords.put("BULK", null);
        SQLKeywords.put("BY", null);
        SQLKeywords.put("CASCADE", null);
        SQLKeywords.put("CASE", null);
        SQLKeywords.put("CHECK", null);
        SQLKeywords.put("CHECKPOINT", null);
        SQLKeywords.put("CLOSE", null);
        SQLKeywords.put("CLUSTERED", null);
        SQLKeywords.put("COALESCE", null);
        SQLKeywords.put("COLLATE", null);
        SQLKeywords.put("COLUMN", null);
        SQLKeywords.put("COMMIT", null);
        SQLKeywords.put("COMPUTE", null);
        SQLKeywords.put("CONSTRAINT", null);
        SQLKeywords.put("CONTAINS", null);
        SQLKeywords.put("CONTAINSTABLE", null);
        SQLKeywords.put("CONTINUE", null);
        SQLKeywords.put("CONVERT", null);
        SQLKeywords.put("CREATE", null);
        SQLKeywords.put("CROSS", null);
        SQLKeywords.put("CURRENT", null);
        SQLKeywords.put("CURRENT_DATE", null);
        SQLKeywords.put("CURRENT_TIME", null);
        SQLKeywords.put("CURRENT_TIMESTAMP", null);
        SQLKeywords.put("CURRENT_USER", null);
        SQLKeywords.put("CURSOR", null);
        SQLKeywords.put("DATABASE", null);
        SQLKeywords.put("DATETIME", null);
        SQLKeywords.put("DBCC", null);
        SQLKeywords.put("DEALLOCATE", null);
        SQLKeywords.put("DECLARE", null);
        SQLKeywords.put("DEFAULT", null);
        SQLKeywords.put("DELETE", null);
        SQLKeywords.put("DENY", null);
        SQLKeywords.put("DESC", null);
        SQLKeywords.put("DISK", null);
        SQLKeywords.put("DISTINCT", null);
        SQLKeywords.put("DISTRIBUTED", null);
        SQLKeywords.put("DOUBLE", null);
        SQLKeywords.put("DROP", null);
        SQLKeywords.put("DUMMY", null);
        SQLKeywords.put("DUMP", null);
        SQLKeywords.put("ELSE", null);
        SQLKeywords.put("END", null);
        SQLKeywords.put("ERRLVL", null);
        SQLKeywords.put("ESCAPE", null);
        SQLKeywords.put("EXCEPT", null);
        SQLKeywords.put("EXEC", null);
        SQLKeywords.put("EXECUTE", null);
        SQLKeywords.put("EXISTS", null);
        SQLKeywords.put("EXIT", null);
        SQLKeywords.put("FETCH", null);
        SQLKeywords.put("FILE", null);
        SQLKeywords.put("FILLFACTOR", null);
        SQLKeywords.put("FOR", null);
        SQLKeywords.put("FOREIGN", null);
        SQLKeywords.put("FREETEXT", null);
        SQLKeywords.put("FREETEXTTABLE", null);
        SQLKeywords.put("FROM", null);
        SQLKeywords.put("FULL", null);
        SQLKeywords.put("FUNCTION", null);
        SQLKeywords.put("GOTO", null);
        SQLKeywords.put("GRANT", null);
        SQLKeywords.put("GROUP", null);
        SQLKeywords.put("HAVING", null);
        SQLKeywords.put("HOLDLOCK", null);
        SQLKeywords.put("IDENTITY", null);
        SQLKeywords.put("IDENTITY_INSERT", null);
        SQLKeywords.put("IDENTITYCOL", null);
        SQLKeywords.put("IF", null);
        SQLKeywords.put("IN", null);
        SQLKeywords.put("INDEX", null);
        SQLKeywords.put("INNER", null);
        SQLKeywords.put("INSERT", null);
        SQLKeywords.put("INTERSECT", null);
        SQLKeywords.put("INTO", null);
        SQLKeywords.put("IS", null);
        SQLKeywords.put("JOIN", null);
        SQLKeywords.put("KEY", null);
        SQLKeywords.put("KILL", null);
        SQLKeywords.put("LEFT", null);
        SQLKeywords.put("LIKE", null);
        SQLKeywords.put("LINENO", null);
        SQLKeywords.put("LOAD", null);
        SQLKeywords.put("NATIONAL", null);
        SQLKeywords.put("NOCHECK", null);
        SQLKeywords.put("NONCLUSTERED", null);
        SQLKeywords.put("NOT", null);
        SQLKeywords.put("NULL", null);
        SQLKeywords.put("NULLIF", null);
        SQLKeywords.put("OF", null);
        SQLKeywords.put("OFF", null);
        SQLKeywords.put("OFFSETS", null);
        SQLKeywords.put("ON", null);
        SQLKeywords.put("OPEN", null);
        SQLKeywords.put("OPENDATASOURCE", null);
        SQLKeywords.put("OPENQUERY", null);
        SQLKeywords.put("OPENROWSET", null);
        SQLKeywords.put("OPENXML", null);
        SQLKeywords.put("OPTION", null);
        SQLKeywords.put("OR", null);
        SQLKeywords.put("ORDER", null);
        SQLKeywords.put("OUTER", null);
        SQLKeywords.put("OVER", null);
        SQLKeywords.put("PERCENT", null);
        SQLKeywords.put("PLAN", null);
        SQLKeywords.put("PRECISION", null);
        SQLKeywords.put("PRIMARY", null);
        SQLKeywords.put("PRINT", null);
        SQLKeywords.put("PROC", null);
        SQLKeywords.put("PROCEDURE", null);
        SQLKeywords.put("PUBLIC", null);
        SQLKeywords.put("RAISERROR", null);
        SQLKeywords.put("READ", null);
        SQLKeywords.put("READTEXT", null);
        SQLKeywords.put("RECONFIGURE", null);
        SQLKeywords.put("REFERENCES", null);
        SQLKeywords.put("REPLICATION", null);
        SQLKeywords.put("RESTORE", null);
        SQLKeywords.put("RESTRICT", null);
        SQLKeywords.put("RETURN", null);
        SQLKeywords.put("REVOKE", null);
        SQLKeywords.put("RIGHT", null);
        SQLKeywords.put("ROLLBACK", null);
        SQLKeywords.put("ROWCOUNT", null);
        SQLKeywords.put("ROWGUIDCOL", null);
        SQLKeywords.put("RULE", null);
        SQLKeywords.put("SAVE", null);
        SQLKeywords.put("SCHEMA", null);
        SQLKeywords.put("SELECT", null);
        SQLKeywords.put("SESSION_USER", null);
        SQLKeywords.put("SET", null);
        SQLKeywords.put("SETUSER", null);
        SQLKeywords.put("SHUTDOWN", null);
        SQLKeywords.put("SOME", null);
        SQLKeywords.put("STATISTICS", null);
        SQLKeywords.put("SYSTEM_USER", null);
        SQLKeywords.put("TABLE", null);
        SQLKeywords.put("TEXTSIZE", null);
        SQLKeywords.put("THEN", null);
        SQLKeywords.put("TO", null);
        SQLKeywords.put("TOP", null);
        SQLKeywords.put("TRAN", null);
        SQLKeywords.put("TRANSACTION", null);
        SQLKeywords.put("TRIGGER", null);
        SQLKeywords.put("TRUNCATE", null);
        SQLKeywords.put("TSEQUAL", null);
        SQLKeywords.put("UNION", null);
        SQLKeywords.put("UNIQUE", null);
        SQLKeywords.put("UPDATE", null);
        SQLKeywords.put("UPDATETEXT", null);
        SQLKeywords.put("USE", null);
        SQLKeywords.put("USER", null);
        SQLKeywords.put("VALUES", null);
        SQLKeywords.put("VARYING", null);
        SQLKeywords.put("VIEW", null);
        SQLKeywords.put("WAITFOR", null);
        SQLKeywords.put("WHEN", null);
        SQLKeywords.put("WHERE", null);
        SQLKeywords.put("WHILE", null);
        SQLKeywords.put("WITH", null);
        SQLKeywords.put("WITHTEXT", null);
        generator = new Random();
    }
}

