/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.netezza.tab;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.util.codereformat.ICodeReformator;

public class NetezzaProcedureFormator
implements ICodeReformator {
    private final String stmtSep;

    public NetezzaProcedureFormator(String stmtSep) {
        this.stmtSep = stmtSep;
    }

    public String reformat(String in) {
        StringBuilder result = new StringBuilder();
        String newLinesStripped = in.replace("/n", " ");
        List<String> parts = this.breakApartNewLines(newLinesStripped.split("\\s+"), this.stmtSep);
        boolean foundAs = false;
        boolean inDeclaration = false;
        boolean inMainSection = false;
        boolean inCreateSection = true;
        for (String part : parts) {
            if (inCreateSection && !part.equalsIgnoreCase("AS")) {
                result.append(part);
                result.append(" ");
                continue;
            }
            if (part.equalsIgnoreCase("AS") && !foundAs) {
                foundAs = true;
                inCreateSection = false;
                result.append("AS\n");
                continue;
            }
            if (part.equalsIgnoreCase("BEGIN_PROC") && !inMainSection) {
                result.append("BEGIN_PROC\n");
                continue;
            }
            if (part.equalsIgnoreCase("DECLARE")) {
                result.append("DECLARE\n");
                inDeclaration = true;
                continue;
            }
            if (inDeclaration && !part.equalsIgnoreCase("BEGIN")) {
                if (!part.endsWith(this.stmtSep)) {
                    result.append("\t");
                }
                result.append(part);
                if (part.endsWith(this.stmtSep)) {
                    result.append("\n");
                    continue;
                }
                result.append(" ");
                continue;
            }
            if (inDeclaration && part.equalsIgnoreCase("BEGIN")) {
                result.append("BEGIN\n\t");
                inDeclaration = false;
                inMainSection = true;
                continue;
            }
            if (inMainSection) {
                if (part.equalsIgnoreCase("END" + this.stmtSep) || part.equalsIgnoreCase("END")) {
                    inMainSection = false;
                    result.setLength(result.length() - 1);
                    result.append(part);
                    if (!part.endsWith(this.stmtSep)) {
                        result.append(this.stmtSep);
                    }
                    result.append("\n");
                    continue;
                }
                result.append(part);
                result.append(" ");
                if (!part.endsWith(this.stmtSep)) continue;
                result.append("\n\t");
                continue;
            }
            result.append(part);
            result.append(this.stmtSep);
            result.append("\n");
        }
        return result.toString();
    }

    private List<String> breakApartNewLines(String[] in, String stmtSep) {
        ArrayList<String> result = new ArrayList<String>();
        for (String part : in) {
            if (part.contains(stmtSep)) {
                String[] subparts = part.split(stmtSep);
                int i = 1;
                for (String subpart : subparts) {
                    if (i++ < subparts.length) {
                        result.add(subpart + stmtSep);
                        continue;
                    }
                    result.add(subpart);
                }
                continue;
            }
            result.add(part);
        }
        return result;
    }
}

