/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dataimport.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.NumberFormat;
import java.util.List;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.sourceforge.squirrel_sql.client.gui.IOkClosePanelListener;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanel;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanelEvent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.dataimport.ImportDataIntoTableExecutor;
import net.sourceforge.squirrel_sql.plugins.dataimport.gui.ColumnMappingTableModel;
import net.sourceforge.squirrel_sql.plugins.dataimport.gui.SpecialColumnMapping;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.IFileImporter;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.csv.CSVFileImporter;

public class ImportFileDialog
extends DialogWidget {
    private static final String PREF_KEY_IMPORT_DIALOG_WIDTH = "Squirrel.dataimport.dialog.width";
    private static final String PREF_KEY_IMPORT_DIALOG_HEIGHT = "Squirrel.dataimport.dialog.width";
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(ImportFileDialog.class);
    public static final int DEFAULT_COMMIT_AFTER_INSERTS_COUNT = 100;
    private String[][] previewData = null;
    private List<String> importerColumns = new Vector<String>();
    private JTable previewTable = null;
    private JTable mappingTable = null;
    private JCheckBox headersIncluded = null;
    private JCheckBox suggestColumns = null;
    private JCheckBox suggestColumnsIgnoreCase = null;
    private JCheckBox oneToOneMapping = null;
    private JCheckBox safeMode = null;
    private OkClosePanel btnsPnl = new OkClosePanel();
    private ISession session = null;
    private File _importFile;
    private IFileImporter importer = null;
    private ITableInfo table = null;
    private TableColumnInfo[] columns = null;
    private JCheckBox _chkSingleTransaction;
    private JFormattedTextField _txtCommitAfterInserts;
    private JLabel _lblCommitAfterInsertBegin;
    private JLabel _lblCommitAfterInsertEnd;

    public ImportFileDialog(ISession session, File importFile, IFileImporter importer, ITableInfo table, TableColumnInfo[] columns) {
        super(stringMgr.getString("ImportFileDialog.fileImport"), true, session.getApplication());
        this.session = session;
        this._importFile = importFile;
        this.importer = importer;
        this.table = table;
        this.columns = columns;
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        JPanel content = new JPanel(new BorderLayout());
        content.add(this.createMainPanel(), "Center");
        this.setContentPane(content);
        this.btnsPnl.makeOKButtonDefault();
        this.btnsPnl.getRootPane().setDefaultButton(this.btnsPnl.getOKButton());
        this.setSize(this.getDimension());
    }

    private Dimension getDimension() {
        return new Dimension(Preferences.userRoot().getInt("Squirrel.dataimport.dialog.width", 600), Preferences.userRoot().getInt("Squirrel.dataimport.dialog.width", 600));
    }

    public void dispose() {
        Dimension size = this.getSize();
        Preferences.userRoot().putInt("Squirrel.dataimport.dialog.width", size.width);
        Preferences.userRoot().putInt("Squirrel.dataimport.dialog.width", size.height);
        super.dispose();
    }

    private Component createMainPanel() {
        this.btnsPnl.addListener((IOkClosePanelListener)new MyOkClosePanelListener());
        this.previewTable = new JTable();
        JScrollPane scrollPane = new JScrollPane(this.previewTable);
        this.mappingTable = new JTable(new ColumnMappingTableModel(this.columns));
        JScrollPane scrollPane2 = new JScrollPane(this.mappingTable);
        this.headersIncluded = new JCheckBox(stringMgr.getString("ImportFileDialog.headersIncluded"));
        this.headersIncluded.setSelected(true);
        this.headersIncluded.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ImportFileDialog.this.updatePreviewData();
                    }
                });
            }
        });
        this.suggestColumns = new JCheckBox(stringMgr.getString("ImportFileDialog.suggestColumns"));
        this.suggestColumns.setSelected(false);
        this.suggestColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ImportFileDialog.this.oneToOneMapping.isSelected()) {
                            ImportFileDialog.this.oneToOneMapping.setSelected(false);
                        }
                        ImportFileDialog.this.suggestColumns();
                    }
                });
            }
        });
        this.suggestColumnsIgnoreCase = new JCheckBox(stringMgr.getString("ImportFileDialog.suggestColumnsIgnoreCase"));
        this.suggestColumnsIgnoreCase.setSelected(false);
        this.suggestColumnsIgnoreCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ImportFileDialog.this.suggestColumns();
                    }
                });
            }
        });
        this.oneToOneMapping = new JCheckBox(stringMgr.getString("ImportFileDialog.oneToOneMapping"));
        this.oneToOneMapping.setSelected(false);
        this.oneToOneMapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ImportFileDialog.this.suggestColumns.isSelected()) {
                            ImportFileDialog.this.suggestColumns.setSelected(false);
                        }
                        if (ImportFileDialog.this.suggestColumnsIgnoreCase.isSelected()) {
                            ImportFileDialog.this.suggestColumnsIgnoreCase.setSelected(false);
                        }
                        ImportFileDialog.this.oneToOneColumns();
                    }
                });
            }
        });
        this.safeMode = new JCheckBox(stringMgr.getString("ImportFileDialog.safetySwitch"));
        this.safeMode.setSelected(true);
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0);
        ret.add((Component)new JLabel(stringMgr.getString("ImportFileDialog.dataPreview", new Object[]{this._importFile.getAbsolutePath()})), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.headersIncluded, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)scrollPane, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.suggestColumns, gbc);
        gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.suggestColumnsIgnoreCase, gbc);
        gbc = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.oneToOneMapping, gbc);
        gbc = new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.safeMode, gbc);
        gbc = new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.createTransactionPanel(), gbc);
        gbc = new GridBagConstraints(0, 8, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)scrollPane2, gbc);
        gbc = new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 10, 10), 0, 0);
        ret.add((Component)this.btnsPnl, gbc);
        return ret;
    }

    private JPanel createTransactionPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this._chkSingleTransaction = new JCheckBox(stringMgr.getString("ImportFileDialog.singleTransaction"));
        ret.add((Component)this._chkSingleTransaction, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0);
        this._lblCommitAfterInsertBegin = new JLabel(stringMgr.getString("ImportFileDialog.commitAfterInsert.begin"));
        ret.add((Component)this._lblCommitAfterInsertBegin, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        this._txtCommitAfterInserts = new JFormattedTextField(NumberFormat.getInstance());
        this._txtCommitAfterInserts.setColumns(7);
        ret.add((Component)this._txtCommitAfterInserts, gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0);
        this._lblCommitAfterInsertEnd = new JLabel(stringMgr.getString("ImportFileDialog.commitAfterInsert.end"));
        ret.add((Component)this._lblCommitAfterInsertEnd, gbc);
        gbc = new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        this._chkSingleTransaction.setSelected(true);
        this._txtCommitAfterInserts.setText("100");
        this._chkSingleTransaction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportFileDialog.this.updateTransactionPanel();
            }
        });
        this.updateTransactionPanel();
        return ret;
    }

    private void updateTransactionPanel() {
        boolean intermediateCommits = false == this._chkSingleTransaction.isSelected();
        this._txtCommitAfterInserts.setEnabled(intermediateCommits);
        this._lblCommitAfterInsertBegin.setEnabled(intermediateCommits);
        this._lblCommitAfterInsertEnd.setEnabled(intermediateCommits);
    }

    public void setPreviewData(String[][] data) {
        this.previewData = data;
        this.updatePreviewData();
    }

    private void updatePreviewData() {
        JComboBox<String> editBox = new JComboBox<String>();
        editBox.addItem(SpecialColumnMapping.SKIP.getVisibleString());
        editBox.addItem(SpecialColumnMapping.FIXED_VALUE.getVisibleString());
        editBox.addItem(SpecialColumnMapping.AUTO_INCREMENT.getVisibleString());
        editBox.addItem(SpecialColumnMapping.NULL.getVisibleString());
        editBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = ImportFileDialog.this.mappingTable.getSelectedRow();
                if (selectedRow == -1) {
                    return;
                }
                TableModel model = ImportFileDialog.this.mappingTable.getModel();
                String comboValue = ((JComboBox)e.getSource()).getSelectedItem().toString();
                int fixedValueColumnIdx = 2;
                if (comboValue.equals(SpecialColumnMapping.AUTO_INCREMENT.getVisibleString())) {
                    if (model.getValueAt(selectedRow, fixedValueColumnIdx) == null || "".equals(model.getValueAt(selectedRow, fixedValueColumnIdx))) {
                        model.setValueAt("0", selectedRow, fixedValueColumnIdx);
                    }
                } else if (!comboValue.equals(SpecialColumnMapping.FIXED_VALUE.getVisibleString())) {
                    model.setValueAt("", selectedRow, fixedValueColumnIdx);
                }
                ImportFileDialog.this.mappingTable.clearSelection();
            }
        });
        if (this.previewData != null && this.previewData.length > 0) {
            int i;
            Object[] headers = new String[this.previewData[0].length];
            Object[][] data = this.previewData;
            if (this.headersIncluded.isSelected()) {
                for (i = 0; i < headers.length; ++i) {
                    headers[i] = data[0][i];
                }
                data = new String[this.previewData.length - 1][];
                for (i = 1; i < this.previewData.length; ++i) {
                    data[i - 1] = this.previewData[i];
                }
            } else {
                for (i = 0; i < headers.length; ++i) {
                    headers[i] = stringMgr.getString("ImportFileDialog.column") + i;
                }
            }
            this.importerColumns.clear();
            for (i = 0; i < headers.length; ++i) {
                this.importerColumns.add(headers[i]);
            }
            for (String string : headers) {
                editBox.addItem(string);
            }
            this.previewTable.setModel(new DefaultTableModel(data, headers));
        }
        this.mappingTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(editBox));
        ((ColumnMappingTableModel)this.mappingTable.getModel()).resetMappings();
        if (this.suggestColumns.isSelected()) {
            this.suggestColumns();
        } else if (this.oneToOneMapping.isSelected()) {
            this.oneToOneColumns();
        }
    }

    public void suggestColumns() {
        ColumnMappingTableModel columnMappingTableModel = (ColumnMappingTableModel)this.mappingTable.getModel();
        boolean ignorecase = this.suggestColumnsIgnoreCase.isSelected();
        if (this.suggestColumns.isSelected()) {
            for (String importerColumn : this.importerColumns) {
                TableColumnInfo suggestedColumn;
                if (null == importerColumn || importerColumn.isEmpty() || (suggestedColumn = this.suggestColumn(importerColumn, ignorecase)) == null) continue;
                String suggestedColumnName = suggestedColumn.getColumnName();
                int row = columnMappingTableModel.findTableColumn(suggestedColumnName);
                columnMappingTableModel.setValueAt(importerColumn, row, 1);
            }
        } else {
            columnMappingTableModel.resetMappings();
        }
    }

    protected void oneToOneColumns() {
        ColumnMappingTableModel columnMappingTableModel = (ColumnMappingTableModel)this.mappingTable.getModel();
        if (this.oneToOneMapping.isSelected()) {
            int i = 0;
            for (String importerColumn : this.importerColumns) {
                TableColumnInfo suggestedColumn;
                if (null == importerColumn || importerColumn.isEmpty() || i >= this.columns.length || (suggestedColumn = this.columns[i++]) == null) continue;
                String suggestedColumnName = suggestedColumn.getColumnName();
                int row = columnMappingTableModel.findTableColumn(suggestedColumnName);
                columnMappingTableModel.setValueAt(importerColumn, row, 1);
            }
        } else {
            columnMappingTableModel.resetMappings();
        }
    }

    private TableColumnInfo suggestColumn(String importerColumn, boolean ignoreCase) {
        for (TableColumnInfo colInfo : this.columns) {
            if (!ignoreCase && colInfo.getColumnName().equals(importerColumn)) {
                return colInfo;
            }
            if (!ignoreCase || !colInfo.getColumnName().equalsIgnoreCase(importerColumn)) continue;
            return colInfo;
        }
        return null;
    }

    public void ok() {
        this.dispose();
        if (this.importer instanceof CSVFileImporter) {
            ((CSVFileImporter)this.importer).setSafetySwitch(this.safeMode.isSelected());
        }
        int commitAfterEveryInsertsCount = 100;
        if (null != this._txtCommitAfterInserts.getText()) {
            try {
                int buf = Integer.valueOf(this._txtCommitAfterInserts.getText());
                if (commitAfterEveryInsertsCount >= 0) {
                    commitAfterEveryInsertsCount = buf;
                }
            }
            catch (NumberFormatException buf) {
                // empty catch block
            }
        }
        ImportDataIntoTableExecutor executor = new ImportDataIntoTableExecutor(this.session, this.table, this.columns, this.importerColumns, (ColumnMappingTableModel)this.mappingTable.getModel(), this.importer, this._chkSingleTransaction.isSelected(), commitAfterEveryInsertsCount);
        executor.setSkipHeader(this.headersIncluded.isSelected());
        executor.execute();
    }

    private final class MyOkClosePanelListener
    implements IOkClosePanelListener {
        private MyOkClosePanelListener() {
        }

        public void okPressed(OkClosePanelEvent evt) {
            ImportFileDialog.this.ok();
        }

        public void closePressed(OkClosePanelEvent evt) {
            ImportFileDialog.this.dispose();
        }

        public void cancelPressed(OkClosePanelEvent evt) {
            ImportFileDialog.this.dispose();
        }
    }
}

