/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres.commands;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.ErrorDialog;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.plugins.postgres.commands.AbstractPostgresCommand;
import net.sourceforge.squirrel_sql.plugins.postgres.commands.SQLResultListener;

public abstract class AbstractPostgresDialogCommand
extends AbstractPostgresCommand {
    public AbstractPostgresDialogCommand(ISession session) {
        super(session);
    }

    protected abstract void executeScript(String var1);

    protected class ExecuteListener
    implements ActionListener,
    SQLResultListener {
        protected ExecuteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractPostgresDialogCommand.this.getSQLStatements(this);
        }

        @Override
        public void finished(String[] stmts) {
            if (stmts == null || stmts.length == 0) {
                AbstractPostgresDialogCommand.this._session.showMessage("No changes have been done.");
                return;
            }
            StringBuilder script = new StringBuilder();
            for (String stmt : stmts) {
                script.append(stmt).append("\n");
            }
            AbstractPostgresDialogCommand.this.executeScript(script.toString());
        }
    }

    protected class EditSQLListener
    implements ActionListener,
    SQLResultListener {
        private final JDialog _parentDialog;

        public EditSQLListener(JDialog parentDialog) {
            this._parentDialog = parentDialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractPostgresDialogCommand.this.getSQLStatements(this);
        }

        @Override
        public void finished(String[] stmts) {
            if (stmts == null || stmts.length == 0) {
                AbstractPostgresDialogCommand.this._session.showMessage("No changes have been done.");
                return;
            }
            final StringBuilder script = new StringBuilder();
            for (String stmt : stmts) {
                script.append(stmt).append("\n\n");
            }
            GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    EditSQLListener.this._parentDialog.setVisible(false);
                    AbstractPostgresDialogCommand.this._session.getSQLPanelAPIOfActiveSessionWindow().appendSQLScript(script.substring(0, script.length() - 2), true);
                    AbstractPostgresDialogCommand.this._session.selectMainTab(1);
                }
            });
        }
    }

    protected class ShowSQLListener
    implements ActionListener,
    SQLResultListener {
        private final String _dialogTitle;
        private final JDialog _parentDialog;

        public ShowSQLListener(String dialogTitle, JDialog parentDialog) {
            this._dialogTitle = dialogTitle;
            this._parentDialog = parentDialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractPostgresDialogCommand.this.getSQLStatements(this);
        }

        @Override
        public void finished(String[] stmts) {
            if (stmts == null || stmts.length == 0) {
                AbstractPostgresDialogCommand.this._session.showMessage("No changes have been done.");
                return;
            }
            StringBuilder script = new StringBuilder();
            for (String stmt : stmts) {
                script.append(stmt).append("\n\n");
            }
            ErrorDialog sqldialog = new ErrorDialog((Dialog)this._parentDialog, script.substring(0, script.length() - 2));
            sqldialog.setTitle(this._dialogTitle);
            sqldialog.setVisible(true);
        }
    }
}

