/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.userscript.kernel;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.GenerateTemplateDialog;

public class GenerateTemplateController {
    private GenerateTemplateDialog m_dlg;

    GenerateTemplateController(JFrame owner) {
        this.m_dlg = new GenerateTemplateDialog(owner);
        GUIUtils.centerWithinParent((Window)this.m_dlg);
        this.m_dlg.setVisible(true);
        this.m_dlg.txtCodeTemplate.setText("package pack;\n\nimport java.sql.Connection;\nimport java.sql.DriverManager;\nimport java.io.PrintStream;\nimport java.lang.reflect.Method;\n\npublic class TemplateUserScript\n{\n\tpublic static final String DB_OBJECT_TYPE_TABLE = \"TABLE\";\n\tpublic static final String DB_OBJECT_TYPE_VIEW = \"VIEW\";\n\tpublic static final String DB_OBJECT_TYPE_PROCEDURE = \"PROCEDURE\";\n\tpublic static final String DB_OBJECT_TYPE_CONNECTION = \"CONNECTION\";\n\tpublic static final String DB_OBJECT_TYPE_SQL_STATEMENT = \"SQL\";\n\n\t/**\n\t * Will be set from inside SQuirreL via reflection.\n\t */\n\tpublic Object environment;\n\n\t/**\n\t *\n\t * Place your script code in this method.\n\t *\n\t * @param dbObjectType one of the DB_OBJECT_TYPE_... constants\n\t * @param info\n\t *        table name if DB_OBJECT_TYPE_TABLE.equals(DB_OBJECT_TYPE_TABLE)\n\t *        view name if DB_OBJECT_TYPE_TABLE.equals(DB_OBJECT_TYPE_VIEW)\n\t *        procedure name if DB_OBJECT_TYPE_TABLE.equals(DB_OBJECT_TYPE_PROCEDURE)\n\t *        null if DB_OBJECT_TYPE_TABLE.equals(DB_OBJECT_TYPE_CONNECTION)\n\t *        SQL String if DB_OBJECT_TYPE_TABLE.equals(DB_OBJECT_TYPE_SQL_STATEMENT)\n\t * @param con The connection of the DB session. If you work with transactions your\n\t *        script will executed in the same transaction. Closing the the connection will break the session.\n\t */\n\tpublic void execute(String dbObjectType, String info, Connection con)\n\t\tthrows Exception\n\t{\n\t\tPrintStream ps;\n\t\tps = createPrintStream();\n\t\tps.println(\"PS 1\");\n\t\tps.println(\"type: \" + dbObjectType);\n\t\tps.println(\"info: \" + info);\n\t\tps.println(\"URL: \" + con.getMetaData().getURL());\n\n\t\tps = createPrintStream(\"Bean\");\n\t\tps.println(\"PS 2\");\n\t\tps.println(\"type: \" + dbObjectType);\n\t\tps.println(\"info: \" + info);\n\t\tps.println(\"URL: \" + con.getMetaData().getURL());\n\n\t\tps = getSQLAreaPrintStream();\n\t\tps.println(\"To SQL Area: \" + dbObjectType);\n\t\tps.println(\"type: \" + dbObjectType);\n\t\tps.println(\"info: \" + info);\n\t\tps.println(\"URL: \" + con.getMetaData().getURL());\n\n\t}\n\n\n\t//////////////////////////////////////////////////////////////////////////////\n\t// Service Methods\n\t//////////////////////////////////////////////////////////////////////////////\n\n\n\t/**\n\t * The output to these print streams will be presented in a tabbed window.\n\t */\n\tPrintStream createPrintStream()\n\t{\n\t\treturn createPrintStream(null);\n\t}\n\n\t/**\n\t * The output to these print streams will be presented in a tabbed window.\n\t */\n\tPrintStream createPrintStream(String tabTitle)\n\t{\n\t\ttry\n\t\t{\n\t\t\tMethod m = environment.getClass().getMethod(\"createPrintStream\", new Class[]{String.class});\n\t\t\treturn (PrintStream) m.invoke(environment, new Object[]{tabTitle});\n\t\t}\n\t\tcatch (Exception e)\n\t\t{\n\t\t\tthrow new RuntimeException(e);\n\t\t}\n\t}\n\n\t/**\n\t * The output to this print stream will be appended to the  SQL text area of the db session\n\t */\n\tPrintStream getSQLAreaPrintStream()\n\t{\n\t\ttry\n\t\t{\n\t\t\tMethod m = environment.getClass().getMethod(\"getSQLAreaPrintStream\", new Class[0]);\n\t\t\treturn (PrintStream) m.invoke(environment, new Object[0]);\n\t\t}\n\t\tcatch (Exception e)\n\t\t{\n\t\t\tthrow new RuntimeException(e);\n\t\t}\n\t}\n\n\n\n\n\t///////////////////////////////////////////////////////////////////////////\n\t// To test the script outside SQuirreL\n\t//////////////////////////////////////////////////////////////////////////\n\tpublic static void main(String[] args)\n\t\tthrows Exception\n\t{\n\t\tClass.forName(\"COM.ibm.db2.jdbc.net.DB2Driver\");\n\t\tConnection con = DriverManager.getConnection(\"jdbc:db2://localhost/TestDB\", \"db2inst1\", \"db2inst1\");\n\n\n\t\tTemplateUserScript s = new TemplateUserScript();\n\t\ts.environment = new TestEnvironment();\n\t\ts.execute(DB_OBJECT_TYPE_TABLE, \"MyTable\", con);\n\t}\n\n}\n\n\nclass TestEnvironment\n{\n\n\tpublic PrintStream createPrintStream()\n\t{\n\t\treturn System.out;\n\t}\n\n\tpublic PrintStream getSQLAreaPrintStream()\n\t{\n\t\treturn System.out;\n\t}\n} ");
        this.m_dlg.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateTemplateController.this.onSave();
            }
        });
    }

    private void onSave() {
        try {
            JFileChooser fc = new JFileChooser();
            if (0 == fc.showSaveDialog(this.m_dlg)) {
                FileOutputStream fos = new FileOutputStream(fc.getSelectedFile());
                fos.write(this.m_dlg.txtCodeTemplate.getText().getBytes());
                fos.flush();
                fos.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

