/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.userscript.kernel;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import javax.swing.Action;
import javax.swing.JFrame;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.plugins.userscript.FrameWorkAcessor;
import net.sourceforge.squirrel_sql.plugins.userscript.UserScriptPlugin;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.GenericScriptPopupAction;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.Script;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.ScriptEnvironment;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.ScriptProps;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.ScriptTarget;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.ScriptTargetCollection;

public class UserScriptAdmin {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(UserScriptAdmin.class);
    public static final String SCRIPT_PROPERTIES_FILE = "UserScriptProperties.xml";
    public static final boolean TARGET_TYPE_DB_OBJECT = false;
    public static final boolean TARGET_TYPE_SQL = true;
    private UserScriptPlugin m_plugin;
    private ISession m_session;

    public UserScriptAdmin(UserScriptPlugin plugin, ISession session) {
        try {
            this.m_plugin = plugin;
            this.m_session = session;
            ScriptProps props = this.readScriptProps();
            if (null != props) {
                for (int i = 0; i < props.getScripts().length; ++i) {
                    if (!props.getScripts()[i].isShowInStandard()) continue;
                    GenericScriptPopupAction actDbObject = new GenericScriptPopupAction(props.getScripts()[i], this, false);
                    IObjectTreeAPI api = FrameWorkAcessor.getObjectTreeAPI(this.m_session, this.m_plugin);
                    api.addToPopup(DatabaseObjectType.TABLE, (Action)actDbObject);
                    api.addToPopup(DatabaseObjectType.PROCEDURE, (Action)actDbObject);
                    api.addToPopup(DatabaseObjectType.SESSION, (Action)actDbObject);
                    GenericScriptPopupAction actSql = new GenericScriptPopupAction(props.getScripts()[i], this, true);
                    FrameWorkAcessor.getSQLPanelAPI(this.m_session, this.m_plugin).addToSQLEntryAreaMenu((Action)actSql);
                }
            }
            this.initUserScriptClassLoader(props);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    ScriptProps readScriptProps() {
        try {
            if (this.getScriptPropertiesFile().exists()) {
                XMLBeanReader br = new XMLBeanReader();
                br.load(this.getScriptPropertiesFile(), this.getClass().getClassLoader());
                return (ScriptProps)br.iterator().next();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initUserScriptClassLoader(ScriptProps props) {
        try {
            URL[] cp;
            if (null == props) {
                cp = new URL[]{};
            } else {
                cp = new URL[props.getExtraClassPath().length];
                for (int i = 0; i < props.getExtraClassPath().length; ++i) {
                    String path = props.getExtraClassPath()[i].getEntry();
                    cp[i] = new File(path).toURI().toURL();
                }
            }
            this.m_plugin.setUserScriptClassLoader(URLClassLoader.newInstance(cp));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private File getScriptPropertiesFile() {
        try {
            return new File(this.m_plugin.getPluginUserSettingsFolder().getPath() + File.separator + SCRIPT_PROPERTIES_FILE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ScriptTargetCollection getTargets(boolean targetType) {
        if (!targetType) {
            IObjectTreeAPI api = FrameWorkAcessor.getObjectTreeAPI(this.m_session, this.m_plugin);
            IDatabaseObjectInfo[] dbObjs = api.getSelectedDatabaseObjects();
            ScriptTargetCollection targets = new ScriptTargetCollection();
            for (int i = 0; i < dbObjs.length; ++i) {
                if (dbObjs[i].getDatabaseObjectType().equals(DatabaseObjectType.TABLE)) {
                    ITableInfo tableInfo = (ITableInfo)dbObjs[i];
                    if ("VIEW".equals(tableInfo.getType())) {
                        targets.add(new ScriptTarget(dbObjs[i].getSimpleName(), "VIEW"));
                        continue;
                    }
                    if (!"TABLE".equals(tableInfo.getType()) && !"SYSTEM TABLE".equals(tableInfo.getType())) continue;
                    targets.add(new ScriptTarget(dbObjs[i].getSimpleName(), "TABLE"));
                    continue;
                }
                if (dbObjs[i].getDatabaseObjectType().equals(DatabaseObjectType.PROCEDURE)) {
                    targets.add(new ScriptTarget(dbObjs[i].getSimpleName(), "PROCEDURE"));
                    continue;
                }
                if (!dbObjs[i].getDatabaseObjectType().equals(DatabaseObjectType.SESSION)) continue;
                targets.add(new ScriptTarget(dbObjs[i].getSimpleName(), "CONNECTION"));
            }
            return targets;
        }
        ScriptTargetCollection targets = new ScriptTargetCollection();
        String sql = FrameWorkAcessor.getSQLPanelAPI(this.m_session, this.m_plugin).getSQLScriptToBeExecuted();
        targets.add(new ScriptTarget(sql, "SQL"));
        return targets;
    }

    public UserScriptPlugin getPlugin() {
        return this.m_plugin;
    }

    public ISession getSession() {
        return this.m_session;
    }

    public void writeScriptProps(ScriptProps scriptProps) {
        try {
            XMLBeanWriter bw = new XMLBeanWriter((Object)scriptProps);
            bw.save(this.getScriptPropertiesFile());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void refreshExtraClassPath() {
        this.initUserScriptClassLoader(this.readScriptProps());
    }

    public void executeScript(JFrame ownerFrame, Script script, ScriptTargetCollection targets) {
        ScriptEnvironment env = new ScriptEnvironment(FrameWorkAcessor.getSQLPanelAPI(this.m_session, this.m_plugin), ownerFrame);
        try {
            URLClassLoader loader = this.m_plugin.getUserScriptClassLoader();
            Class<?> scriptClass = Class.forName(script.getScriptClass(), false, loader);
            Object scriptInst = scriptClass.newInstance();
            Field f = scriptInst.getClass().getField("environment");
            f.set(scriptInst, env);
            Method m = scriptInst.getClass().getMethod("execute", String.class, String.class, Connection.class);
            ScriptTarget[] buf = targets.getAll();
            for (int i = 0; i < buf.length; ++i) {
                m.invoke(scriptInst, buf[i].getTargetType(), buf[i].getTargetInfo(), this.m_session.getSQLConnection().getConnection());
                env.flushAll();
            }
            env.setExecutionFinished(true);
        }
        catch (Exception e) {
            e.printStackTrace(env.createPrintStream(s_stringMgr.getString("userscript.scriptAdminErr")));
            env.flushAll();
            env.setExecutionFinished(false);
            throw new RuntimeException(e);
        }
    }
}

