/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.squirrel.act;

import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.ICommand;

abstract class AbstractMultipleSQLCommand
implements ICommand {
    private ISession _session;
    private final IPlugin _plugin;

    public AbstractMultipleSQLCommand(ISession session, IPlugin plugin) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        if (plugin == null) {
            throw new IllegalArgumentException("IPlugin == null");
        }
        this._session = session;
        this._plugin = plugin;
    }

    public void execute() {
        StringBuffer buf = new StringBuffer(2048);
        String sep = "\n" + this._session.getQueryTokenizer().getSQLStatementSeparator();
        IObjectTreeAPI api = this._session.getSessionInternalFrame().getObjectTreeAPI();
        IDatabaseObjectInfo[] dbObjs = api.getSelectedDatabaseObjects();
        for (int i = 0; i < dbObjs.length; ++i) {
            String cmd = this.getSQL(dbObjs[i]);
            if (cmd == null || cmd.length() <= 0) continue;
            buf.append(cmd).append(sep).append('\n');
        }
        if (buf.length() > 0) {
            this._session.getSessionInternalFrame().getSQLPanelAPI().appendSQLScript(buf.toString(), true);
            this._session.getSessionInternalFrame().getSQLPanelAPI().executeCurrentSQL();
            this._session.selectMainTab(1);
        }
    }

    protected abstract String getSQL(IDatabaseObjectInfo var1);
}

