/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.tab;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BasePreparedStatementTab;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.oracle.OraclePlugin;

public class InstanceDetailsTab
extends BasePreparedStatementTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(InstanceDetailsTab.class);
    private static String SQL = "select instance_number, instance_name, host_name, version, startup_time, status, parallel, thread#, archiver, log_switch_wait, logins, shutdown_pending, database_status, instance_role from sys.v_$instance where instance_number = ?";
    private static String CHECK_ACCESS_SQL = "select instance_number, instance_name, host_name, version, startup_time, status, parallel, thread#, archiver, log_switch_wait, logins, shutdown_pending, database_status, instance_role from sys.v_$instance";

    public InstanceDetailsTab() {
        super(i18n.TITLE, i18n.HINT, true);
    }

    protected PreparedStatement createStatement() throws SQLException {
        ISession session = this.getSession();
        PreparedStatement pstmt = session.getSQLConnection().prepareStatement(SQL);
        IDatabaseObjectInfo doi = this.getDatabaseObjectInfo();
        pstmt.setLong(1, Long.parseLong(doi.getSimpleName()));
        return pstmt;
    }

    public static boolean isAccessible(ISession session) {
        return OraclePlugin.checkObjectAccessible(session, CHECK_ACCESS_SQL);
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface i18n {
        public static final String TITLE = InstanceDetailsTab.access$000().getString("oracle.instanceDetails");
        public static final String HINT = InstanceDetailsTab.access$000().getString("oracle.displaySnstanceDetails");
    }
}

