/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane;

import java.awt.Point;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane.DnDTabbedPaneData;
import net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane.DndTabUtils;
import net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane.GhostGlassPane;
import net.sourceforge.squirrel_sql.client.gui.builders.dndtabbedpane.OutwardDndTabbedPaneChanel;

class DndTabbedPaneDragSourceListener
implements DragSourceListener {
    private final GhostGlassPane _glassPane;
    private final DnDTabbedPaneData _dnDTabbedPaneData;
    private OutwardDndTabbedPaneChanel _outwardDndTabbedPaneChanel;

    public DndTabbedPaneDragSourceListener(GhostGlassPane glassPane, DnDTabbedPaneData dnDTabbedPaneData, OutwardDndTabbedPaneChanel outwardDndTabbedPaneChanel) {
        this._glassPane = glassPane;
        this._dnDTabbedPaneData = dnDTabbedPaneData;
        this._outwardDndTabbedPaneChanel = outwardDndTabbedPaneChanel;
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
        if (null != this._outwardDndTabbedPaneChanel) {
            this._outwardDndTabbedPaneChanel.setDndTabbedPaneData(this._dnDTabbedPaneData);
        }
        e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
    }

    @Override
    public void dragExit(DragSourceEvent e) {
        e.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        this._dnDTabbedPaneData.getTargetLineRectBuffer().setRect(0.0, 0.0, 0.0, 0.0);
        this._glassPane.setPoint(new Point(-1000, -1000));
        this._glassPane.repaint();
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
        e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        this._glassPane.setCursor(DragSource.DefaultMoveDrop);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
        this._dnDTabbedPaneData.getTargetLineRectBuffer().setRect(0.0, 0.0, 0.0, 0.0);
        this._dnDTabbedPaneData.setDragTabIndex(-1);
        DndTabUtils.hideGlassPane(this._glassPane, this._dnDTabbedPaneData);
        if (null != this._outwardDndTabbedPaneChanel) {
            this._outwardDndTabbedPaneChanel.dragDropEnd();
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }
}

