/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.util.codereformat;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.FormatSqlPanel;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.FormatSqlPref;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.FormatSqlPrefReader;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.KeywordBehaviourPref;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformatorConfig;
import net.sourceforge.squirrel_sql.client.util.codereformat.ColumnListSpiltMode;
import net.sourceforge.squirrel_sql.client.util.codereformat.CommentSpec;
import net.sourceforge.squirrel_sql.client.util.codereformat.PieceMarkerSpec;

public class CodeReformatorConfigFactory {
    public static final CommentSpec[] DEFAULT_COMMENT_SPECS = new CommentSpec[]{new CommentSpec("/*", "*/"), new CommentSpec("--", "\n")};
    public static final String DEFAULT_STATEMENT_SEPARATOR = ";";

    public static CodeReformatorConfig createConfig(ISession sess) {
        String statementSep = sess.getQueryTokenizer().getSQLStatementSeparator();
        return CodeReformatorConfigFactory.createConfig(statementSep);
    }

    public static CodeReformatorConfig createConfig(String statementSep) {
        return CodeReformatorConfigFactory.createConfig(statementSep, DEFAULT_COMMENT_SPECS);
    }

    public static CodeReformatorConfig createConfig(String statementSeparator, CommentSpec[] commentSpecs) {
        FormatSqlPref formatSqlPref = FormatSqlPrefReader.loadPref();
        return CodeReformatorConfigFactory.createConfig(statementSeparator, commentSpecs, formatSqlPref);
    }

    public static CodeReformatorConfig createConfig(FormatSqlPref formatSqlPref) {
        return CodeReformatorConfigFactory.createConfig(DEFAULT_STATEMENT_SEPARATOR, DEFAULT_COMMENT_SPECS, formatSqlPref);
    }

    public static CodeReformatorConfig createConfig(String statementSeparator, CommentSpec[] commentSpecs, FormatSqlPref formatSqlPref) {
        String indent = "";
        for (int i = 0; i < formatSqlPref.getIndent(); ++i) {
            indent = indent + " ";
        }
        int trySplitLineLen = formatSqlPref.getPreferedLineLength();
        ArrayList<PieceMarkerSpec> specs = new ArrayList<PieceMarkerSpec>();
        for (KeywordBehaviourPref keywordBehaviourPref : formatSqlPref.getKeywordBehaviourPrefs()) {
            specs.addAll(CodeReformatorConfigFactory.createPieceMarkerSpecs(keywordBehaviourPref));
        }
        return new CodeReformatorConfig(statementSeparator, commentSpecs, indent, trySplitLineLen, formatSqlPref.isDoInsertValuesAlign(), specs, formatSqlPref.isIndentSections(), formatSqlPref.isLineBreakFor_AND_OR_in_FROM_clause(), formatSqlPref.isCommasAtLineBegin(), ColumnListSpiltMode.valueOf(formatSqlPref.getColumnListSplitMode()));
    }

    private static ArrayList<PieceMarkerSpec> createPieceMarkerSpecs(KeywordBehaviourPref keywordBehaviourPref) {
        ArrayList<PieceMarkerSpec> ret = new ArrayList<PieceMarkerSpec>();
        String keyWord = keywordBehaviourPref.getKeyWord();
        Integer pieceMarkerSpecType = FormatSqlPanel.KeywordBehaviour.forId(keywordBehaviourPref.getKeywordBehaviourId()).getPieceMarkerSpecType();
        if ("INNER/LEFT/RIGHT JOIN".equals(keyWord)) {
            if (null != pieceMarkerSpecType) {
                ret.add(new PieceMarkerSpec("JOIN", pieceMarkerSpecType));
                ret.add(new PieceMarkerSpec("INNER JOIN", pieceMarkerSpecType));
                ret.add(new PieceMarkerSpec("LEFT JOIN", pieceMarkerSpecType));
                ret.add(new PieceMarkerSpec("RIGHT JOIN", pieceMarkerSpecType));
                ret.add(new PieceMarkerSpec("LEFT OUTER JOIN", pieceMarkerSpecType));
                ret.add(new PieceMarkerSpec("RIGHT OUTER JOIN", pieceMarkerSpecType));
            }
        } else if (null != pieceMarkerSpecType) {
            ret.add(new PieceMarkerSpec(keyWord, pieceMarkerSpecType));
        }
        return ret;
    }
}

