/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.showreferences;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.SimpleSessionListener;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformator;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformatorConfigFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.showreferences.JoinSQLInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.showreferences.ReferenceKey;
import net.sourceforge.squirrel_sql.fw.gui.action.showreferences.ReferenceType;
import net.sourceforge.squirrel_sql.fw.gui.action.showreferences.References;
import net.sourceforge.squirrel_sql.fw.gui.action.showreferences.RootTable;
import net.sourceforge.squirrel_sql.fw.gui.action.showreferences.ShowQualifiedListener;
import net.sourceforge.squirrel_sql.fw.gui.action.showreferences.ShowReferencesUtil;
import net.sourceforge.squirrel_sql.fw.gui.action.showreferences.ShowReferencesWindow;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ShowReferencesCtrl {
    private static final String PREF_KEY_SHOW_REFERENCES_WIDTH = "Squirrel.showReferencesWidth";
    private static final String PREF_KEY_SHOW_REFERENCES_HEIGHT = "Squirrel.showReferencesHeight";
    private static final String PREF_KEY_SHOW_REFERENCES_QUALIFIED = "Squirrel.showReferencesHeight.qualified";
    static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ShowReferencesCtrl.class);
    private final ShowReferencesWindow _window;
    private final DefaultTreeModel _treeModel;
    private ArrayList<ShowQualifiedListener> _showQualifiedListeners = new ArrayList();
    private ISession _session;

    public ShowReferencesCtrl(ISession session, JFrame owningFrame, RootTable rootTable, References references) {
        this._session = session;
        this._window = new ShowReferencesWindow(this._session, owningFrame, s_stringMgr.getString("ShowReferencesCtrl.window.title", rootTable.getFrameTitle()));
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootTable);
        this._treeModel = new DefaultTreeModel(root);
        this.createChildReferenceKeyNodes(root, references);
        this.initShowQualifiedListeners(references);
        this._window.tree.getSelectionModel().setSelectionMode(1);
        this._window.tree.setModel(this._treeModel);
        this._window.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                ShowReferencesCtrl.this.onExpanded(event);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this._session.addSimpleSessionListener(new SimpleSessionListener(){

            @Override
            public void sessionClosed() {
                ShowReferencesCtrl.this.close();
            }
        });
        this._window.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ShowReferencesCtrl.this.onTreeSelectionChanged(e);
            }
        });
        this._window.tree.expandPath(new TreePath(root));
        GUIUtils.enableCloseByEscape(this._window);
        int width = Preferences.userRoot().getInt(PREF_KEY_SHOW_REFERENCES_WIDTH, 300);
        int height = Preferences.userRoot().getInt(PREF_KEY_SHOW_REFERENCES_HEIGHT, 300);
        this._window.setSize(width, height);
        GUIUtils.centerWithinParent(this._window);
        this._window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ShowReferencesCtrl.this.onClose();
            }
        });
        this._window.chkShowQualified.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowReferencesCtrl.this.onChkShowQualified();
            }
        });
        this._window.chkShowQualified.setSelected(Preferences.userRoot().getBoolean(PREF_KEY_SHOW_REFERENCES_QUALIFIED, false));
        this.onChkShowQualified();
        this._window.setVisible(true);
    }

    private void initShowQualifiedListeners(References references) {
        for (ReferenceKey referenceKey : references.getAll()) {
            this._showQualifiedListeners.add(referenceKey.getShowQualifiedListener());
        }
    }

    private void onChkShowQualified() {
        for (ShowQualifiedListener showQualifiedListener : this._showQualifiedListeners) {
            showQualifiedListener.showQualifiedChanged(this._window.chkShowQualified.isSelected());
        }
        this._window.tree.setModel(null);
        this._window.tree.setModel(this._treeModel);
    }

    private void close() {
        this.onClose();
        this._window.setVisible(false);
        this._window.dispose();
    }

    private void onTreeSelectionChanged(TreeSelectionEvent e) {
        Object[] path = e.getPath().getPath();
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path[path.length - 1];
        if (selectedNode.getUserObject() instanceof ReferenceType) {
            return;
        }
        JoinSQLInfo joinSQLInfo = ShowReferencesUtil.generateJoinSQLInfo(path);
        CodeReformator cr = new CodeReformator(CodeReformatorConfigFactory.createConfig(this._session));
        this._window.resultExecuterPanel.executeSQL(cr.reformat(joinSQLInfo.getSql()), joinSQLInfo.getTableToBeEdited());
    }

    private void createChildReferenceKeyNodes(DefaultMutableTreeNode parent, References references) {
        DefaultMutableTreeNode refTypeNode;
        if (0 < references.getFkName_exportedKeys().size()) {
            refTypeNode = new DefaultMutableTreeNode((Object)ReferenceType.EXPORTED_KEY);
            parent.add(refTypeNode);
            this.appendReferenceChilds(refTypeNode, references.getFkName_exportedKeys().values());
        }
        if (0 < references.getFkName_importedKeys().size()) {
            refTypeNode = new DefaultMutableTreeNode((Object)ReferenceType.IMPORTED_KEY);
            parent.add(refTypeNode);
            this.appendReferenceChilds(refTypeNode, references.getFkName_importedKeys().values());
        }
    }

    private void appendReferenceChilds(DefaultMutableTreeNode refTypeNode, Collection<ReferenceKey> referenceKeys) {
        for (ReferenceKey referenceKey : referenceKeys) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(referenceKey){

                @Override
                public boolean isLeaf() {
                    return false;
                }
            };
            child.setAllowsChildren(true);
            refTypeNode.add(child);
        }
    }

    private void onExpanded(TreeExpansionEvent event) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        if (0 < parentNode.getChildCount()) {
            return;
        }
        ReferenceKey parentReferenceKey = (ReferenceKey)parentNode.getUserObject();
        References references = ReferenceType.EXPORTED_KEY == parentReferenceKey.getReferenceType() ? ShowReferencesUtil.getReferences(parentReferenceKey.getFkResultMetaDataTable(), this._session) : ShowReferencesUtil.getReferences(parentReferenceKey.getPkResultMetaDataTable(), this._session);
        this.initShowQualifiedListeners(references);
        this.createChildReferenceKeyNodes(parentNode, references);
        this._treeModel.nodeStructureChanged(parentNode);
    }

    private void onClose() {
        Preferences.userRoot().putInt(PREF_KEY_SHOW_REFERENCES_WIDTH, this._window.getSize().width);
        Preferences.userRoot().putInt(PREF_KEY_SHOW_REFERENCES_HEIGHT, this._window.getSize().height);
        Preferences.userRoot().putBoolean(PREF_KEY_SHOW_REFERENCES_QUALIFIED, this._window.chkShowQualified.isSelected());
    }
}

