/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects;

import java.util.List;
import javax.swing.SwingWorker;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.JdbcConnectionData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HqlQueryResult;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ObjectSubstituteRoot;
import net.sourceforge.squirrel_sql.plugins.hibernate.util.HqlQueryErrorUtil;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.QueryListCreatorListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.WaitPanel;

public class QueryListCreator
extends SwingWorker<HqlQueryResult, Object> {
    private static ILogger s_log = LoggerController.createLogger(QueryListCreator.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(QueryListCreator.class);
    private QueryListCreatorListener _queryListCreatorListener;
    private String _hqlQuery;
    private int _maxNumResults;
    private boolean _useSessionJdbData;
    private HibernateConnection _con;
    private ISession _session;
    private WaitPanel _waitPanel;
    private volatile long _duration;
    private HqlQueryResult _hqlQueryResult;

    public QueryListCreator(QueryListCreatorListener queryListCreatorListener, String hqlQuery, int maxNumResults, boolean useSessionJdbData, HibernateConnection con, ISession session, WaitPanel waitPanel) {
        this._queryListCreatorListener = queryListCreatorListener;
        this._hqlQuery = hqlQuery;
        this._maxNumResults = maxNumResults;
        this._useSessionJdbData = useSessionJdbData;
        this._con = con;
        this._session = session;
        this._waitPanel = waitPanel;
    }

    @Override
    protected HqlQueryResult doInBackground() {
        JdbcConnectionData jdbcData = null;
        if (this._useSessionJdbData) {
            jdbcData = this._session.getJdbcData();
        }
        long begin = System.currentTimeMillis();
        HqlQueryResult queryRes = this._con.createQueryList(this._hqlQuery, this._maxNumResults, jdbcData);
        this._duration = System.currentTimeMillis() - begin;
        return queryRes;
    }

    @Override
    protected void done() {
        try {
            this._hqlQueryResult = (HqlQueryResult)this.get();
            for (String msgKey : this._hqlQueryResult.getSessionAdminExceptions().keySet()) {
                s_log.error((Object)msgKey, this._hqlQueryResult.getSessionAdminExceptions().get(msgKey));
            }
            if (null != this._hqlQueryResult.getExceptionOccuredWhenExecutingQuery()) {
                this._waitPanel.displayHqlQueryError(HqlQueryErrorUtil.handleHqlQueryError(this._hqlQueryResult.getExceptionOccuredWhenExecutingQuery(), this._session, false));
                return;
            }
            if (null != this._hqlQueryResult.getMessagePanelInfoText()) {
                this._session.getApplication().getMessageHandler().showMessage(this._hqlQueryResult.getMessagePanelInfoText());
            }
            if (null == this._hqlQueryResult.getQueryResultList()) {
                if (null != this._hqlQueryResult.getUpdateCount()) {
                    this._session.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("ObjectResultController.hqlDataUpdateSuccess", new Object[]{this._hqlQueryResult.getUpdateCount(), this._duration}));
                } else {
                    s_log.error((Object)new NullPointerException("HqlQueryResult didn't contain a resultlist although it should according to its error state."));
                }
            } else {
                this._session.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("ObjectResultController.hqlReadObjectsSuccess", new Object[]{this._hqlQueryResult.getQueryResultList().size(), this._duration}));
            }
        }
        catch (Throwable t) {
            s_log.error((Object)t);
            this._waitPanel.displayError(t);
        }
        finally {
            this._queryListCreatorListener.queryExecuted(this);
        }
    }

    public List<ObjectSubstituteRoot> getList() {
        return this._hqlQueryResult.getQueryResultList();
    }

    public int getMaxNumResults() {
        return this._maxNumResults;
    }

    public HibernateConnection getConnection() {
        return this._con;
    }

    public String getHqlQuery() {
        return this._hqlQuery;
    }

    public WaitPanel getWaitPanel() {
        return this._waitPanel;
    }
}

