/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.i18n;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.i18n.I18nBundle;
import net.sourceforge.squirrel_sql.plugins.i18n.I18nProps;

public class BundlesTableModel
extends DefaultTableModel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(I18nProps.class);
    private I18nBundle[] _bundles;

    public BundlesTableModel() {
        this.addColumn(s_stringMgr.getString("i18n.bundle"));
        this.addColumn(s_stringMgr.getString("i18n.missingTarnslation"));
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public int getRowCount() {
        if (null == this._bundles) {
            return 0;
        }
        return this._bundles.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (0 == column) {
            return this._bundles[row].getName();
        }
        if (1 == column) {
            return this._bundles[row].getMissingTranslationsCount();
        }
        throw new IllegalArgumentException("Unknown column " + column);
    }

    public void setBundles(I18nBundle[] bundles) {
        this._bundles = bundles;
        Arrays.sort(this._bundles);
        this.fireTableDataChanged();
    }

    public I18nBundle[] getBundlesForRows(int[] rows) {
        ArrayList<I18nBundle> ret = new ArrayList<I18nBundle>(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            ret.add(this._bundles[rows[i]]);
        }
        return ret.toArray(new I18nBundle[ret.size()]);
    }
}

