/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.i18n;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.i18n.DevelopersPanel;
import net.sourceforge.squirrel_sql.plugins.i18n.I18nParseException;
import net.sourceforge.squirrel_sql.plugins.i18n.I18nUtils;

public class DevelopersController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DevelopersController.class);
    private DevelopersPanel _panel;
    private IApplication _app;
    private static final String PREF_KEY_SOURCE_DIR = "SquirrelSQL.i18n.sourceDir";
    private static final String PREF_KEY_INCLUDE_TIMESTAMP = "SquirrelSQL.i18n.includeTimestamp";
    private static Preferences prefs = null;

    public DevelopersController(DevelopersPanel pnlDevelopers) {
        this._panel = pnlDevelopers;
        this._panel.btnChooseSourceDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevelopersController.this.onChooseSourceDir();
            }
        });
        this._panel.btnAppendI18nInCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevelopersController.this.onAppendI18nInCode();
            }
        });
        prefs = Preferences.userRoot();
        String sourceDir = prefs.get(PREF_KEY_SOURCE_DIR, null);
        this._panel.txtSourceDir.setText(sourceDir);
    }

    private void onChooseSourceDir() {
        String startDir = System.getProperties().getProperty("user.home");
        if (this._panel.txtSourceDir.getText() != null && !"".equals(this._panel.txtSourceDir.getText())) {
            startDir = this._panel.txtSourceDir.getText();
        }
        JFileChooser chooser = new JFileChooser(startDir);
        chooser.setFileSelectionMode(1);
        chooser.showOpenDialog((Component)this._app.getMainFrame());
        if (null != chooser.getSelectedFile()) {
            this._panel.txtSourceDir.setText(chooser.getSelectedFile().getPath());
        }
    }

    private void onAppendI18nInCode() {
        File sourceDir = this.getSourceDir();
        if (null == sourceDir) {
            return;
        }
        this.appendProps(sourceDir);
        this._app.getMessageHandler().showMessage(s_stringMgr.getString("i18n.ParsingFinish"));
    }

    private void appendProps(File sourceDir) {
        try {
            FileInputStream fis;
            File[] files = sourceDir.listFiles();
            ArrayList<String> newProps = new ArrayList<String>();
            ArrayList<String> replaceProps = new ArrayList<String>();
            File i18nStringFile = new File(sourceDir, "I18NStrings.properties");
            Properties curProps = new Properties();
            if (i18nStringFile.exists()) {
                fis = new FileInputStream(i18nStringFile);
                curProps.load(fis);
                fis.close();
            }
            for (int i = 0; i < files.length; ++i) {
                Object[] params;
                if (files[i].isDirectory() && !"CVS".equals(files[i].getName())) {
                    this.appendProps(files[i]);
                    continue;
                }
                if (!files[i].getName().endsWith(".java")) continue;
                int occurrences = 0;
                StringBuffer code = new StringBuffer();
                fis = new FileInputStream(files[i]);
                int buf = fis.read();
                while (-1 != buf) {
                    code.append((char)buf);
                    buf = fis.read();
                }
                fis.close();
                try {
                    int occurrencesFound;
                    occurrences = this.parseProps(code.toString(), curProps, newProps, replaceProps);
                    if (occurrences <= 0 || occurrences == (occurrencesFound = this.fixSourceFile(files[i].getAbsolutePath()))) continue;
                    params = new Object[]{occurrences, occurrencesFound, files[i].getPath()};
                    String msg = s_stringMgr.getString("i18n.unequalOccurrences", params);
                    this._app.getMessageHandler().showErrorMessage(msg);
                    continue;
                }
                catch (Exception e) {
                    params = new Object[]{files[i].getPath(), e.toString()};
                    this._app.getMessageHandler().showErrorMessage(s_stringMgr.getString("i18n.failedToParse", params));
                }
            }
            if (0 < newProps.size() || 0 < replaceProps.size()) {
                int j;
                FileOutputStream fos = new FileOutputStream(i18nStringFile, true);
                PrintWriter ps = new PrintWriter(fos);
                String includeTimestamp = prefs.get(PREF_KEY_INCLUDE_TIMESTAMP, "true");
                if (includeTimestamp.equals("true")) {
                    ps.println("\n#\n#Missing/changed properties generated by I18n Plugin on " + new Date() + "\n#");
                }
                Collections.sort(newProps);
                for (j = 0; j < newProps.size(); ++j) {
                    ps.println((String)newProps.get(j));
                }
                for (j = 0; j < replaceProps.size(); ++j) {
                    ps.println();
                    ps.println("# A T T E N T I O N: REPLACES SAME KEY ABOVE");
                    ps.println(replaceProps.get(j));
                }
                ps.flush();
                fos.flush();
                ps.close();
                fos.close();
                Object[] params = new Object[]{newProps.size(), replaceProps.size(), i18nStringFile.getPath()};
                this._app.getMessageHandler().showMessage(s_stringMgr.getString("i18n.parseSuccess", params));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int parseProps(String code, Properties curProps, ArrayList<String> newProps, ArrayList<String> replaceProps) throws I18nParseException {
        int occurrences = 0;
        code = code.replace('\r', ' ');
        Pattern pat = Pattern.compile("//\\x20*i18n\\[(.*)");
        Matcher m = pat.matcher(code);
        int[] propBounds = new int[]{0, 0};
        while (m.find(propBounds[1])) {
            ++occurrences;
            propBounds[0] = m.start(m.groupCount());
            String prop = this.getProp(code, propBounds);
            int equalsPos = prop.indexOf(61);
            if (0 > equalsPos) {
                throw new I18nParseException("Property " + prop + " has no key.");
            }
            String key = prop.substring(0, equalsPos);
            String val = prop.substring(equalsPos + 1).trim();
            if (curProps.containsKey(key) && !val.equals(I18nUtils.normalizePropVal((String)curProps.get(key)))) {
                replaceProps.add(prop);
                continue;
            }
            if (curProps.containsKey(key)) continue;
            boolean found = false;
            for (int i = 0; i < newProps.size(); ++i) {
                if (!newProps.get(i).split("=")[0].startsWith(key.split("=")[0])) continue;
                found = true;
                replaceProps.add(prop);
                break;
            }
            if (found) continue;
            newProps.add(prop);
        }
        return occurrences;
    }

    private String getProp(String code, int[] propBounds) throws I18nParseException {
        boolean isInComment = true;
        boolean isABracket = false;
        boolean isASlash = false;
        boolean isInCommentBegin = false;
        StringBuffer ret = new StringBuffer();
        for (int i = propBounds[0]; i < code.length(); ++i) {
            if (isInComment && isABracket && ']' != code.charAt(i)) {
                if (isABracket) {
                    propBounds[1] = i;
                    return I18nUtils.normalizePropVal(ret.toString());
                }
            } else if (isInComment && ']' == code.charAt(i)) {
                isABracket = !isABracket;
                isASlash = false;
            } else if (isInComment && '\n' == code.charAt(i)) {
                isInComment = false;
                isABracket = false;
                isASlash = false;
            } else {
                if (!isInComment && '\n' == code.charAt(i)) {
                    throw new I18nParseException("Property " + ret.toString() + " does not end with ]");
                }
                if (!isInComment && !isASlash && '/' == code.charAt(i)) {
                    isASlash = true;
                    isABracket = false;
                } else if (!isInComment && isASlash && '/' == code.charAt(i)) {
                    isInComment = true;
                    isInCommentBegin = true;
                    isABracket = false;
                    isASlash = false;
                }
            }
            if (isInComment && !isInCommentBegin && !isABracket) {
                ret.append(code.charAt(i));
            }
            isInCommentBegin = false;
        }
        if (ret.toString().length() > 50) {
            ret.setLength(50);
        }
        throw new I18nParseException("Property " + ret.toString() + " does not end with ]");
    }

    private File getSourceDir() {
        String msg;
        String buf = this._panel.txtSourceDir.getText();
        if (null == buf || 0 == buf.trim().length()) {
            String msg2 = s_stringMgr.getString("I18n.NoSourceDir");
            JOptionPane.showMessageDialog((Component)this._app.getMainFrame(), msg2);
            return null;
        }
        File sourceDir = new File(buf);
        if (!sourceDir.isDirectory()) {
            msg = s_stringMgr.getString("I18n.SourceDirIsNotADirectory", new Object[]{sourceDir.getPath()});
            JOptionPane.showMessageDialog((Component)this._app.getMainFrame(), msg);
        }
        if (!sourceDir.exists()) {
            msg = s_stringMgr.getString("I18n.SourceDirDoesNotExist", new Object[]{sourceDir.getPath()});
            JOptionPane.showMessageDialog((Component)this._app.getMainFrame(), msg);
            return null;
        }
        return sourceDir;
    }

    private int fixSourceFile(String filename) throws Exception {
        String nextLine;
        BufferedReader in = new BufferedReader(new FileReader(filename));
        String lineToPrint = nextLine = in.readLine();
        int occurrencesReplaced = 0;
        boolean writeFixFile = false;
        ArrayList<String> linesToPrint = new ArrayList<String>();
        Pattern pat = Pattern.compile("\\s*//\\s*i18n\\[(.*)");
        Pattern commentLinePattern = Pattern.compile("\\s*//");
        while (nextLine != null) {
            String[] parts;
            Matcher m = pat.matcher(nextLine);
            if (m.matches() && 1 < (parts = nextLine.split("\\[")).length && 0 < (parts = parts[1].split("\\]")).length && 1 < (parts = parts[0].split("=")).length) {
                String key = parts[0];
                String val = parts[1];
                linesToPrint.add(nextLine);
                nextLine = in.readLine();
                Matcher commentMatch = commentLinePattern.matcher(nextLine);
                if (!commentMatch.matches()) {
                    String quotedVal = "\"" + val + "\"";
                    int indexOfQuotedVal = nextLine.indexOf(quotedVal);
                    lineToPrint = nextLine;
                    if (-1 < indexOfQuotedVal) {
                        String stringManager = "s_stringMgr.getString(\"" + key + "\")";
                        lineToPrint = nextLine.substring(0, indexOfQuotedVal) + stringManager + nextLine.substring(indexOfQuotedVal + quotedVal.length());
                        writeFixFile = true;
                        ++occurrencesReplaced;
                    } else {
                        String stringManagerBegin = "s_stringMgr.getString(\"" + key + "\"";
                        if (-1 < nextLine.indexOf(stringManagerBegin)) {
                            ++occurrencesReplaced;
                        }
                    }
                } else {
                    lineToPrint = nextLine;
                }
            }
            linesToPrint.add(lineToPrint);
            lineToPrint = nextLine = in.readLine();
        }
        in.close();
        if (writeFixFile) {
            String outFileName = filename + ".fixed";
            PrintWriter out = new PrintWriter(new FileOutputStream(outFileName));
            for (int i = 0; i < linesToPrint.size(); ++i) {
                out.println((String)linesToPrint.get(i));
            }
            out.flush();
            out.close();
            this._app.getMessageHandler().showMessage(s_stringMgr.getString("i18n.wroteFixedFile", new Object[]{outFileName}));
        }
        return occurrencesReplaced;
    }

    public void initialize(IApplication app) {
        this._app = app;
    }

    public void uninitialize() {
        Preferences.userRoot().put(PREF_KEY_SOURCE_DIR, this._panel.txtSourceDir.getText());
    }
}

