/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;

public class KunststoffTextFieldUI
extends BasicTextFieldUI {
    protected JComponent myComponent;

    public KunststoffTextFieldUI() {
    }

    KunststoffTextFieldUI(JComponent c) {
        this.myComponent = c;
    }

    public static ComponentUI createUI(JComponent c) {
        return new KunststoffTextFieldUI(c);
    }

    protected void paintBackground(Graphics g) {
        ColorUIResource colorShadow;
        super.paintBackground(g);
        ColorUIResource colorReflection = KunststoffLookAndFeel.getTextComponentGradientColorReflection();
        if (colorReflection != null) {
            Color colorReflectionFaded = KunststoffUtilities.getTranslucentColor(colorReflection, 0);
            Rectangle rect = new Rectangle(0, 0, this.myComponent.getWidth(), this.myComponent.getHeight() / 2);
            KunststoffUtilities.drawGradient(g, colorReflection, colorReflectionFaded, rect, true);
        }
        if ((colorShadow = KunststoffLookAndFeel.getTextComponentGradientColorShadow()) != null) {
            Color colorShadowFaded = KunststoffUtilities.getTranslucentColor(colorShadow, 0);
            Rectangle rect = new Rectangle(0, this.myComponent.getHeight() / 2, this.myComponent.getWidth(), this.myComponent.getHeight() / 2);
            KunststoffUtilities.drawGradient(g, colorShadowFaded, colorShadow, rect, true);
        }
    }
}

