/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.informix.tab;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.informix.tab.InformixSourceTab;

public class TriggerSourceTab
extends InformixSourceTab {
    private static String SQL = "SELECT  T2.data, T2.datakey, T2.seqno FROM    informix.systriggers AS T1, informix.systrigbody AS T2 WHERE   trigname = ? AND     T2.trigid = T1.trigid AND     datakey IN ('D', 'A') ORDER   BY datakey DESC, seqno ";
    private static final ILogger s_log = LoggerController.createLogger(TriggerSourceTab.class);

    public TriggerSourceTab(String hint) {
        super(hint);
        this.sourceType = 2;
    }

    protected PreparedStatement createStatement() throws SQLException {
        ISession session = this.getSession();
        IDatabaseObjectInfo doi = this.getDatabaseObjectInfo();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Running SQL: " + SQL));
            s_log.debug((Object)("trigname=" + doi.getSimpleName()));
        }
        ISQLConnection conn = session.getSQLConnection();
        PreparedStatement pstmt = conn.prepareStatement(SQL);
        pstmt.setString(1, doi.getSimpleName());
        return pstmt;
    }
}

