/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlbookmark;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.Bookmark;
import net.sourceforge.squirrel_sql.plugins.sqlbookmark.BookmarkEditDialog;

public class BookmarEditController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(BookmarEditController.class);
    private boolean _canceled;
    private BookmarkEditDialog _dlg;
    private Bookmark _mark;

    public BookmarEditController(Frame owner, Bookmark mark, boolean editable) {
        this._mark = mark;
        this._dlg = new BookmarkEditDialog(owner, null == this._mark);
        this._dlg.btnOk.setEnabled(editable);
        if (null != this._mark) {
            this._dlg.txtName.setText(this._mark.getName());
            this._dlg.txtDescription.setText(this._mark.getDescription());
            this._dlg.txtSql.setText(this._mark.getSql());
        }
        this._dlg.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarEditController.this.onOK();
            }
        });
        this._dlg.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarEditController.this.onCancel();
            }
        });
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BookmarEditController.this.onCancel();
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        this._dlg.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        this._dlg.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        this._dlg.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        this._dlg.getRootPane().getActionMap().put("CloseAction", closeAction);
        this._dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BookmarEditController.this._canceled = true;
            }
        });
        GUIUtils.centerWithinParent((Window)this._dlg);
        this._dlg.setVisible(true);
    }

    private void onOK() {
        String name = this._dlg.txtName.getText();
        if (null == name || 0 == name.trim().length() || this.containsWhiteSpaces(name)) {
            JOptionPane.showMessageDialog(this._dlg, s_stringMgr.getString("sqlbookmark.enterName"));
            return;
        }
        String description = this._dlg.txtDescription.getText();
        if (null == description || 0 == description.trim().length()) {
            JOptionPane.showMessageDialog(this._dlg, s_stringMgr.getString("sqlbookmark.enterDescription"));
            return;
        }
        String sql = this._dlg.txtSql.getText();
        if (null == sql || 0 == sql.trim().length()) {
            JOptionPane.showMessageDialog(this._dlg, s_stringMgr.getString("sqlbookmark.enterSql"));
            return;
        }
        if (null == this._mark) {
            this._mark = new Bookmark(name.trim(), description.trim(), sql.trim());
        } else {
            this._mark.setName(name.trim());
            this._mark.setDescription(description.trim());
            this._mark.setSql(sql.trim());
        }
        this._dlg.setVisible(false);
        this._canceled = false;
    }

    private boolean containsWhiteSpaces(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isWhitespace(name.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private void onCancel() {
        this._dlg.setVisible(false);
        this._canceled = true;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void setCanceled(boolean status) {
        this._canceled = status;
    }

    public Bookmark getBookmark() {
        return this._mark;
    }
}

