/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql.tab;

import java.awt.Component;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseObjectTab;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetScrollingPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.MapDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

abstract class BaseSQLTab
extends BaseObjectTab {
    private final String _title;
    private final String _hint;
    private boolean _firstRowOnly;
    private DataSetScrollingPanel _comp;
    private static final ILogger s_log = LoggerController.createLogger(BaseSQLTab.class);

    public BaseSQLTab(String title, String hint) {
        this(title, hint, false);
    }

    public BaseSQLTab(String title, String hint, boolean firstRowOnly) {
        if (title == null) {
            throw new IllegalArgumentException("Title == null");
        }
        this._title = title;
        this._hint = hint != null ? hint : title;
        this._firstRowOnly = firstRowOnly;
    }

    public String getTitle() {
        return this._title;
    }

    public String getHint() {
        return this._hint;
    }

    public void clear() {
    }

    public Component getComponent() {
        if (this._comp == null) {
            ISession session = this.getSession();
            SessionProperties props = session.getProperties();
            String destClassName = props.getMetaDataOutputClassName();
            try {
                this._comp = new DataSetScrollingPanel(destClassName, null, session);
            }
            catch (Exception e) {
                s_log.error((Object)("Unexpected exception from call to getComponent: " + e.getMessage()), (Throwable)e);
            }
        }
        return this._comp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshComponent() throws DataSetException {
        ISession session = this.getSession();
        if (session == null) {
            throw new IllegalStateException("Null ISession");
        }
        try {
            Statement stmt = session.getSQLConnection().createStatement();
            try {
                ResultSet rs = stmt.executeQuery(this.getSQL());
                try {
                    this._comp.load(this.createDataSetFromResultSet(rs));
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            throw new DataSetException((Throwable)ex);
        }
    }

    protected abstract String getSQL() throws SQLException;

    protected IDataSet createDataSetFromResultSet(ResultSet rs) throws DataSetException {
        ResultSetDataSet rsds = new ResultSetDataSet();
        rsds.setResultSet(rs, DialectType.MYSQL);
        if (!this._firstRowOnly) {
            return rsds;
        }
        int columnCount = rsds.getColumnCount();
        ColumnDisplayDefinition[] colDefs = rsds.getDataSetDefinition().getColumnDefinitions();
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (rsds.next(null)) {
            for (int i = 0; i < columnCount; ++i) {
                data.put(colDefs[i].getColumnName(), rsds.get(i));
            }
        }
        return new MapDataSet(data);
    }
}

