/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class AuthPanel
extends Panel
implements ActionListener {
    Label title;
    Label retry;
    Label prompt;
    TextField password;
    Button ok;
    Label promptuser;
    TextField username;
    boolean mslogon = false;

    public AuthPanel(boolean bl) {
        this.mslogon = bl;
        this.title = new Label("VNC Authentication", 1);
        this.title.setFont(new Font("Helvetica", 1, 18));
        this.prompt = new Label("Password:", 1);
        this.password = new TextField(10);
        this.password.setForeground(Color.black);
        this.password.setBackground(Color.white);
        this.password.setEchoChar('*');
        if (this.mslogon) {
            this.promptuser = new Label("Username:", 1);
            this.username = new TextField(10);
            this.username.setForeground(Color.black);
            this.username.setBackground(Color.white);
        }
        this.ok = new Button("OK");
        this.retry = new Label("", 1);
        this.retry.setFont(new Font("Courier", 1, 16));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.title, gridBagConstraints);
        this.add(this.title);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.retry, gridBagConstraints);
        this.add(this.retry);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        if (this.mslogon) {
            gridBagLayout.setConstraints(this.promptuser, gridBagConstraints);
            this.add(this.promptuser);
            gridBagLayout.setConstraints(this.username, gridBagConstraints);
            this.add(this.username);
            this.username.addActionListener(this);
        }
        gridBagLayout.setConstraints(this.prompt, gridBagConstraints);
        this.add(this.prompt);
        gridBagLayout.setConstraints(this.password, gridBagConstraints);
        this.add(this.password);
        this.password.addActionListener(this);
        gridBagConstraints.ipady = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        gridBagConstraints.ipadx = 40;
        gridBagLayout.setConstraints(this.ok, gridBagConstraints);
        this.add(this.ok);
        this.ok.addActionListener(this);
    }

    public void setmslogon(boolean bl) {
        this.mslogon = bl;
    }

    public void moveFocusToUsernameField() {
        if (this.mslogon) {
            this.username.requestFocus();
        } else {
            this.moveFocusToPasswordField();
        }
    }

    public void setUserName(String string) {
        this.username.setText(string);
    }

    public void moveFocusToPasswordField() {
        this.password.requestFocus();
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.password || actionEvent.getSource() == this.ok) {
            this.password.setEnabled(false);
            this.notify();
        }
    }

    public void retry() {
        this.retry.setText("Sorry. Try again.");
        this.password.setEnabled(true);
        this.password.setText("");
        this.moveFocusToPasswordField();
    }
}

