/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf.corba;

import com.bbn.openmap.image.JPEGHelper;
import com.bbn.openmap.layer.rpf.RpfCacheHandler;
import com.bbn.openmap.layer.rpf.RpfColortable;
import com.bbn.openmap.layer.rpf.RpfCoverageBox;
import com.bbn.openmap.layer.rpf.RpfFrameCacheHandler;
import com.bbn.openmap.layer.rpf.RpfIndexedImageData;
import com.bbn.openmap.layer.rpf.RpfTocHandler;
import com.bbn.openmap.layer.rpf.RpfViewAttributes;
import com.bbn.openmap.layer.rpf.corba.CRpfFrameProvider.CRFPCADRGProjection;
import com.bbn.openmap.layer.rpf.corba.CRpfFrameProvider.CRFPCoverageBox;
import com.bbn.openmap.layer.rpf.corba.CRpfFrameProvider.CRFPViewAttributes;
import com.bbn.openmap.layer.rpf.corba.CRpfFrameProvider.RawImage;
import com.bbn.openmap.layer.rpf.corba.CRpfFrameProvider.ServerPOA;
import com.bbn.openmap.layer.rpf.corba.CRpfFrameProvider.XYPoint;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.corba.CORBASupport;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Timer;

public class CRFPServer
extends ServerPOA
implements ActionListener {
    protected static String iorfile = null;
    protected static String naming = null;
    Hashtable caches = new Hashtable();
    Hashtable viewAttributeLists = new Hashtable();
    protected RpfFrameCacheHandler currentCache;
    protected RpfViewAttributes currentViewAttributes;
    protected String[] rpfpaths;
    protected RpfTocHandler[] tocs;
    Hashtable timestamps = new Hashtable();
    Timer timer;
    public static final int DEFAULT_MAX_USERS = 10;
    protected int maxUsers = 10;
    public static final int DEFAULT_TIME_WINDOW = 300000;
    protected long timeWindow = 300000L;

    public CRFPServer() {
        this("Default");
    }

    public CRFPServer(String name) {
    }

    protected RpfFrameCacheHandler getCurrentCache(String uniqueID) {
        RpfFrameCacheHandler cache = (RpfFrameCacheHandler)this.caches.get(uniqueID);
        if (cache == null && this.tocs != null) {
            Debug.message((String)"crfp", (String)"CRFPServer: Creating cache for new client");
            cache = new RpfFrameCacheHandler(this.tocs);
            this.caches.put(uniqueID, cache);
        }
        this.timestamps.put(uniqueID, new Long(System.currentTimeMillis()));
        return cache;
    }

    protected void cleanCache(long timeWindow) {
        long currentTime = System.currentTimeMillis();
        Enumeration keys = this.timestamps.keys();
        while (keys.hasMoreElements()) {
            Object tester = keys.nextElement();
            Long time = (Long)this.timestamps.get(tester);
            if (currentTime - time < timeWindow) continue;
            this.caches.remove(tester);
            this.timestamps.remove(tester);
            this.viewAttributeLists.remove(tester);
            if (!Debug.debugging((String)"crfp")) continue;
            Debug.output((String)("Expired cache, removing, have " + this.caches.size() + " caches left."));
        }
    }

    protected RpfCacheHandler sweepCaches() {
        if (this.caches.size() < this.maxUsers) {
            return null;
        }
        long diff = Long.MAX_VALUE;
        Enumeration keys = this.timestamps.keys();
        Object getRid = null;
        while (keys.hasMoreElements()) {
            Object tester = keys.nextElement();
            Long time = (Long)this.timestamps.get(tester);
            if (time >= diff) continue;
            getRid = tester;
            diff = time;
        }
        boolean DEBUG = false;
        if (getRid != null) {
            if (Debug.debugging((String)"crfp")) {
                DEBUG = true;
            }
            if (DEBUG) {
                Debug.output((String)("Removing cache for new user, was " + this.caches.size()));
            }
            this.caches.remove(getRid);
            this.timestamps.remove(getRid);
            this.viewAttributeLists.remove(getRid);
            if (DEBUG) {
                Debug.output((String)("  now " + this.caches.size()));
            }
        }
        if (this.caches.size() >= this.maxUsers) {
            return this.sweepCaches();
        }
        return getRid;
    }

    protected RpfViewAttributes getCurrentViewAttributes(String uniqueID) {
        RpfViewAttributes va = (RpfViewAttributes)this.viewAttributeLists.get(uniqueID);
        if (va == null) {
            Debug.message((String)"crfp", (String)"CRFPServer: Creating attributes for new client");
            va = new RpfViewAttributes();
            this.viewAttributeLists.put(uniqueID, va);
        }
        return va;
    }

    public void setViewAttributes(CRFPViewAttributes va, String uniqueID) {
        this.currentViewAttributes = this.getCurrentViewAttributes(uniqueID);
        this.currentViewAttributes.numberOfColors = va.numberOfColors;
        this.currentViewAttributes.opaqueness = va.opaqueness;
        this.currentViewAttributes.scaleImages = va.scaleImages;
        this.currentViewAttributes.imageScaleFactor = va.imageScaleFactor;
        this.currentViewAttributes.chartSeries = va.chartSeries;
        if (Debug.debugging((String)"crfp")) {
            Debug.output((String)("CRFPServer: Setting attributes for client:\n    " + this.currentViewAttributes));
        }
    }

    public CRFPCoverageBox[] getCoverage(double ullat, double ullon, double lrlat, double lrlon, CRFPCADRGProjection p, String uniqueID) {
        Debug.message((String)"crfp", (String)"CRFPServer: Handling coverage request for client");
        this.currentCache = this.getCurrentCache(uniqueID);
        this.currentViewAttributes = this.getCurrentViewAttributes(uniqueID);
        this.currentCache.setViewAttributes(this.currentViewAttributes);
        LatLonPoint.Double llpoint = new LatLonPoint.Double((double)p.center.lat, (double)p.center.lon);
        CADRG proj = new CADRG((LatLonPoint)llpoint, p.scale, (int)p.width, (int)p.height);
        Vector vector = this.currentCache.getCoverage(ullat, ullon, lrlat, lrlon, (Projection)proj);
        return this.vectorToCRFPCoverageBoxes(vector);
    }

    public CRFPCoverageBox[] getCatalogCoverage(double ullat, double ullon, double lrlat, double lrlon, CRFPCADRGProjection p, String chartSeriesCode, String uniqueID) {
        Debug.message((String)"crfp", (String)"CRFPServer: handling catalog request for client");
        this.currentCache = this.getCurrentCache(uniqueID);
        this.currentViewAttributes = this.getCurrentViewAttributes(uniqueID);
        this.currentCache.setViewAttributes(this.currentViewAttributes);
        LatLonPoint.Float llpoint = new LatLonPoint.Float(p.center.lat, p.center.lon);
        CADRG proj = new CADRG((LatLonPoint)llpoint, p.scale, (int)p.width, (int)p.height);
        Vector vector = this.currentCache.getCatalogCoverage(ullat, ullon, lrlat, lrlon, (Projection)proj, chartSeriesCode);
        return this.vectorToCRFPCoverageBoxes(vector);
    }

    protected CRFPCoverageBox[] vectorToCRFPCoverageBoxes(Vector vector) {
        int size = vector.size();
        CRFPCoverageBox[] rets = new CRFPCoverageBox[size];
        for (int i = 0; i < size; ++i) {
            RpfCoverageBox box = (RpfCoverageBox)vector.elementAt(i);
            if (box == null) continue;
            rets[i] = new CRFPCoverageBox((float)box.nw_lat, (float)box.nw_lon, (float)box.se_lat, (float)box.se_lon, box.subframeLatInterval, box.subframeLonInterval, box.chartCode, (short)box.zone, new XYPoint((short)box.startIndexes.x, (short)box.startIndexes.y), new XYPoint((short)box.endIndexes.x, (short)box.endIndexes.y), (short)box.tocNumber, (short)box.entryNumber, box.scale, box.percentCoverage);
        }
        return rets;
    }

    public byte[] getSubframeData(short tocNumber, short entryNumber, short x, short y, float jpegQuality, String uniqueID) {
        block5: {
            Debug.message((String)"crfpdetail", (String)"CRFPServer: handling subframe request for client");
            try {
                this.currentCache = this.getCurrentCache(uniqueID);
                int[] pixels = this.currentCache.getSubframeData((int)tocNumber, (int)entryNumber, (int)x, (int)y);
                if (pixels == null) break block5;
                byte[] compressed = null;
                try {
                    compressed = JPEGHelper.encodeJPEG((int)256, (int)256, (int[])pixels, (float)jpegQuality);
                }
                catch (Exception e) {
                    Debug.error((String)("CRFPServer: JPEG Compression error: " + e));
                    compressed = new byte[]{};
                }
                if (Debug.debugging((String)"crfpdetail")) {
                    Debug.output((String)("CRFPServer: subframe is " + compressed.length + " bytes"));
                }
                return compressed;
            }
            catch (OutOfMemoryError oome) {
                this.handleMemoryShortage();
            }
        }
        return new byte[0];
    }

    public RawImage getRawSubframeData(short tocNumber, short entryNumber, short x, short y, String uniqueID) {
        Debug.message((String)"crfpdetail", (String)"CRFPServer: handling raw subframe request for client");
        RawImage ri = new RawImage();
        RpfIndexedImageData riid = null;
        try {
            this.currentCache = this.getCurrentCache(uniqueID);
            riid = this.currentCache.getRawSubframeData((int)tocNumber, (int)entryNumber, (int)x, (int)y);
        }
        catch (OutOfMemoryError oome) {
            this.handleMemoryShortage();
            riid = null;
        }
        if (riid == null || riid.imageData == null) {
            Debug.message((String)"crfpdetail", (String)"CRFPServer: null image data");
            ri.imagedata = new byte[0];
            ri.colortable = new int[0];
        } else {
            ri.imagedata = riid.imageData;
            RpfColortable colortable = this.currentCache.getColortable();
            ri.colortable = new int[colortable.colors.length];
            for (int i = 0; i < colortable.colors.length; ++i) {
                ri.colortable[i] = colortable.colors[i].getRGB();
            }
            Debug.message((String)"crfpdetail", (String)"CRFPServer: GOOD image data");
        }
        return ri;
    }

    public String getSubframeAttributes(short tocNumber, short entryNumber, short x, short y, String uniqueID) {
        Debug.message((String)"crfpdetail", (String)"CRFPServer: handling subframe attribute request for client");
        try {
            this.currentCache = this.getCurrentCache(uniqueID);
            return this.currentCache.getSubframeAttributes((int)tocNumber, (int)entryNumber, (int)x, (int)y);
        }
        catch (OutOfMemoryError oome) {
            this.handleMemoryShortage();
            return new String();
        }
    }

    public void signoff(String uniqueID) {
        Debug.message((String)"crfp", (String)("CRFPServer: Client" + uniqueID + " signing off!"));
        this.caches.remove(uniqueID);
        this.viewAttributeLists.remove(uniqueID);
        this.timestamps.remove(uniqueID);
    }

    protected void handleMemoryShortage() {
        Debug.error((String)"CRFPServer out of memory! Dumping all caches!");
        this.caches.clear();
        this.viewAttributeLists.clear();
        this.timestamps.clear();
    }

    public void start(String[] args) {
        CORBASupport cs = new CORBASupport();
        if (args != null) {
            this.parseArgs(args);
        }
        cs.start(this, args, iorfile, naming);
    }

    public void setMaxUsers(String number) {
        try {
            this.setMaxUsers(Integer.parseInt(number));
        }
        catch (NumberFormatException nfe) {
            this.setMaxUsers(10);
        }
    }

    public void setMaxUsers(int number) {
        if (number >= 1) {
            this.maxUsers = number;
        } else {
            Debug.output((String)("Max users of " + number + " not supported, set to " + 10));
            this.maxUsers = 10;
        }
    }

    public int getMaxUsers() {
        return this.maxUsers;
    }

    public void setTimeWindow(String number) {
        try {
            this.setTimeWindow(Long.parseLong(number));
        }
        catch (NumberFormatException nfe) {
            this.setTimeWindow(300000L);
        }
    }

    public void setTimeWindow(long number) {
        if (this.timer == null) {
            this.timer = new Timer((int)number, this);
        }
        if (number >= 1L) {
            this.timeWindow = number;
            Debug.output((String)("Timer enabled,  set to " + number / 1000L + " seconds"));
        } else {
            if (number == 0L) {
                this.timer.stop();
                return;
            }
            this.timeWindow = 300000L;
            Debug.output((String)"Timer enabled,  set to 300 seconds");
        }
        this.timer.start();
    }

    public long getTimeWindow() {
        return this.timeWindow;
    }

    public void actionPerformed(ActionEvent ae) {
        if (Debug.debugging((String)"crfp")) {
            Debug.output((String)"Ping! checking cache...");
        }
        this.cleanCache(this.getTimeWindow());
    }

    public void parseArgs(String[] args) {
        this.rpfpaths = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-ior")) {
                    iorfile = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-name")) {
                    naming = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-help")) {
                    this.printHelp();
                    continue;
                }
                if (args[i].equalsIgnoreCase("-rpfpaths")) {
                    this.rpfpaths = this.getPaths(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-maxusers")) {
                    this.setMaxUsers(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-timewindow")) {
                    this.setTimeWindow(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-verbose")) {
                    Debug.put((String)"crfp");
                    continue;
                }
                if (!args[i].equalsIgnoreCase("-h")) continue;
                this.printHelp();
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.printHelp();
        }
        if (iorfile == null && naming == null) {
            Debug.error((String)"CRFPServer: IOR file and name service name are null!  Use `-ior' or '-name' flag!");
            System.exit(-1);
        }
        if (this.rpfpaths == null) {
            Debug.error((String)"CRFPServer: No RPF directory paths specified!  Use `-rpfpaths' flag!");
            System.exit(-1);
        } else {
            this.tocs = RpfFrameCacheHandler.createTocHandlers((String[])this.rpfpaths);
            Debug.output((String)"CRFPServer: CRFPServer!  Running with paths => ");
            for (int j = 0; j < this.rpfpaths.length; ++j) {
                Debug.output((String)("     " + this.rpfpaths[j]));
            }
        }
    }

    private String[] getPaths(String str) {
        StringTokenizer tok = new StringTokenizer(str, ";");
        int len = tok.countTokens();
        String[] paths = new String[len];
        for (int j = 0; j < len; ++j) {
            paths[j] = tok.nextToken();
        }
        return paths;
    }

    public void printHelp() {
        Debug.output((String)"usage: java CRFPServer [-ior <file> || -name <NAME>] -rpfpaths \"<path to rpf dir>;<path to rpf dir>;<...>\" -maxusers <max number of users to cache> -timewindow <milliseconds for idle cache removal>");
        System.exit(1);
    }

    public static void main(String[] args) {
        Debug.init((Properties)System.getProperties());
        CRFPServer srv = new CRFPServer("CRFPServer");
        srv.start(args);
    }
}

