/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist;

import com.bbn.openmap.corba.CSpecialist.ButtonBox;
import com.bbn.openmap.corba.CSpecialist.CheckBox;
import com.bbn.openmap.corba.CSpecialist.CheckButton;
import com.bbn.openmap.corba.CSpecialist.ListBox;
import com.bbn.openmap.corba.CSpecialist.RadioBox;
import com.bbn.openmap.corba.CSpecialist.Slider;
import com.bbn.openmap.corba.CSpecialist.TextBox;
import com.bbn.openmap.corba.CSpecialist.UWidget;
import com.bbn.openmap.layer.specialist.CSpecLayer;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.Palette;
import com.bbn.openmap.util.PaletteHelper;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CSpecPalette
extends JPanel
implements Palette {
    private String clientID = null;
    private CSpecLayer layer = null;
    private GridBagLayout gridbag = null;
    private GridBagConstraints constraints = null;

    protected CSpecPalette(UWidget[] widgets, String clientID, CSpecLayer layer) {
        this.clientID = clientID;
        this.layer = layer;
        this.gridbag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.setLayout(this.gridbag);
        this.constraints.fill = 2;
        this.constraints.gridwidth = 0;
        this.constraints.anchor = 13;
        this.createPalette(widgets);
        this.setSize(150, 300);
    }

    private void createPalette(UWidget[] widgets) {
        block8: for (int i = 0; i < widgets.length; ++i) {
            switch (widgets[i].discriminator().value()) {
                case 0: {
                    CheckBox cb = widgets[i].cb();
                    Object[] buttons = cb.buttons();
                    String boxlabel = cb.label();
                    ActionListener al = new ActionListener((CheckButton[])buttons, cb, boxlabel){
                        final /* synthetic */ CheckButton[] val$buttons;
                        final /* synthetic */ CheckBox val$cb;
                        final /* synthetic */ String val$boxlabel;
                        {
                            this.val$buttons = checkButtonArray;
                            this.val$cb = checkBox;
                            this.val$boxlabel = string;
                        }

                        public void actionPerformed(ActionEvent e) {
                            int index = Integer.parseInt(e.getActionCommand(), 10);
                            boolean bl = this.val$buttons[index].checked = !this.val$buttons[index].checked;
                            if (Debug.debugging((String)"cspec")) {
                                Debug.output((String)("Checkbutton " + index + " is " + this.val$buttons[index].checked));
                            }
                            try {
                                this.val$cb.selected(this.val$boxlabel, this.val$buttons[index], CSpecPalette.this.clientID);
                            }
                            catch (Throwable t) {
                                CSpecPalette.this.layer.forgetPalette();
                            }
                            CSpecPalette.this.layer.setPaletteIsDirty(true);
                        }
                    };
                    String[] buttonLabels = new String[buttons.length];
                    boolean[] checked = new boolean[buttons.length];
                    for (int j = 0; j < buttons.length; ++j) {
                        buttonLabels[j] = ((CheckButton)buttons[j]).button_label;
                        checked[j] = ((CheckButton)buttons[j]).checked;
                    }
                    JPanel jp = PaletteHelper.createCheckbox((String)boxlabel, (String[])buttonLabels, (boolean[])checked, (ActionListener)al);
                    this.gridbag.setConstraints(jp, this.constraints);
                    this.add(jp);
                    continue block8;
                }
                case 1: {
                    final RadioBox rb = widgets[i].rb();
                    Object[] buttons = rb.buttons();
                    final String boxlabel = rb.label();
                    String selected_button = rb.selected_button();
                    JPanel jp = PaletteHelper.createPaletteJPanel((String)boxlabel);
                    ActionListener al = new ActionListener((String[])buttons){
                        final /* synthetic */ String[] val$buttons;
                        {
                            this.val$buttons = stringArray;
                        }

                        public void actionPerformed(ActionEvent e) {
                            int index = Integer.parseInt(e.getActionCommand(), 10);
                            if (Debug.debugging((String)"cspec")) {
                                Debug.output((String)("Radiobutton " + index + " is selected"));
                            }
                            try {
                                rb.selected(boxlabel, this.val$buttons[index], CSpecPalette.this.clientID);
                            }
                            catch (Throwable t) {
                                CSpecPalette.this.layer.forgetPalette();
                            }
                            CSpecPalette.this.layer.setPaletteIsDirty(true);
                        }
                    };
                    ButtonGroup group = new ButtonGroup();
                    for (int j = 0; j < buttons.length; ++j) {
                        JRadioButton jrb = new JRadioButton((String)buttons[j]);
                        if (((String)buttons[j]).equals(selected_button)) {
                            jrb.setSelected(true);
                        }
                        jrb.setActionCommand("" + j);
                        jrb.addActionListener(al);
                        group.add(jrb);
                        jp.add(jrb);
                    }
                    this.gridbag.setConstraints(jp, this.constraints);
                    this.add(jp);
                    continue block8;
                }
                case 2: {
                    final Slider slide = widgets[i].slide();
                    final String boxlabel = slide.label();
                    short start = slide.start();
                    short end = slide.end();
                    short value = slide.value();
                    boolean vertical = slide.vertical();
                    JPanel jp = PaletteHelper.createPaletteJPanel((String)boxlabel);
                    final JSlider jslide = new JSlider(vertical ? 1 : 0, start, end, value);
                    jslide.addChangeListener(new ChangeListener(){

                        public void stateChanged(ChangeEvent e) {
                            int val = jslide.getValue();
                            if (Debug.debugging((String)"cspec")) {
                                Debug.output((String)("Slider value is " + val));
                            }
                            try {
                                slide.set(boxlabel, (short)val, CSpecPalette.this.clientID);
                            }
                            catch (Throwable t) {
                                CSpecPalette.this.layer.forgetPalette();
                            }
                            CSpecPalette.this.layer.setPaletteIsDirty(true);
                        }
                    });
                    jp.add(jslide);
                    this.gridbag.setConstraints(jp, this.constraints);
                    this.add(jp);
                    continue block8;
                }
                case 3: {
                    final ButtonBox bb = widgets[i].bb();
                    Object[] buttons = bb.buttons();
                    final String boxlabel = bb.label();
                    JPanel jp = PaletteHelper.createPaletteJPanel((String)boxlabel);
                    ActionListener al = new ActionListener((String[])buttons){
                        final /* synthetic */ String[] val$buttons;
                        {
                            this.val$buttons = stringArray;
                        }

                        public void actionPerformed(ActionEvent e) {
                            int index = Integer.parseInt(e.getActionCommand(), 10);
                            if (Debug.debugging((String)"cspec")) {
                                Debug.output((String)("ButtonBox " + index + " pressed"));
                            }
                            try {
                                bb.pressed(boxlabel, this.val$buttons[index], CSpecPalette.this.clientID);
                            }
                            catch (Throwable t) {
                                CSpecPalette.this.layer.forgetPalette();
                            }
                            CSpecPalette.this.layer.setPaletteIsDirty(true);
                        }
                    };
                    for (int j = 0; j < buttons.length; ++j) {
                        JButton jb = new JButton((String)buttons[j]);
                        jb.setActionCommand("" + j);
                        jb.addActionListener(al);
                        jp.add(jb);
                    }
                    this.gridbag.setConstraints(jp, this.constraints);
                    this.add(jp);
                    continue block8;
                }
                case 4: {
                    final ListBox lb = widgets[i].lb();
                    String[] data = lb.contents();
                    final String boxlabel = lb.label();
                    String selected = lb.highlighted_item();
                    final JList<String> jlist = new JList<String>(data);
                    jlist.setPreferredSize(new Dimension(150, 150));
                    JScrollPane jsp = new JScrollPane(jlist);
                    jsp.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), boxlabel));
                    jlist.addListSelectionListener(new ListSelectionListener(){

                        public void valueChanged(ListSelectionEvent e) {
                            String sel = (String)jlist.getSelectedValue();
                            if (Debug.debugging((String)"cspec")) {
                                Debug.output((String)("ListBox " + sel + " selected"));
                            }
                            try {
                                lb.selected(boxlabel, sel, CSpecPalette.this.clientID);
                            }
                            catch (Throwable t) {
                                CSpecPalette.this.layer.forgetPalette();
                            }
                            CSpecPalette.this.layer.setPaletteIsDirty(true);
                        }
                    });
                    for (int j = 0; j < data.length; ++j) {
                        if (!selected.equals(data[j])) continue;
                        jlist.getSelectedIndex();
                        break;
                    }
                    this.gridbag.setConstraints(jsp, this.constraints);
                    this.add(jsp);
                    continue block8;
                }
                case 5: {
                    final TextBox tb = widgets[i].tb();
                    String contents = tb.contents();
                    final String boxlabel = tb.label();
                    final JTextArea jt = new JTextArea(contents);
                    JScrollPane jsp = new JScrollPane(jt);
                    jsp.setPreferredSize(new Dimension(150, 150));
                    jsp.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), boxlabel));
                    ActionListener al = new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            String cmd = e.getActionCommand();
                            if (cmd.equals("ok")) {
                                try {
                                    Debug.message((String)"cspec", (String)"TextBox pressed.");
                                    tb.pressed(boxlabel, jt.getText(), CSpecPalette.this.clientID);
                                }
                                catch (Throwable t) {
                                    CSpecPalette.this.layer.forgetPalette();
                                }
                                CSpecPalette.this.layer.setPaletteIsDirty(true);
                            } else if (cmd.equals("clear")) {
                                jt.setText("");
                            }
                        }
                    };
                    JPanel buttonsPanel = new JPanel();
                    JButton clear = new JButton("Clear");
                    clear.setActionCommand("clear");
                    clear.addActionListener(al);
                    buttonsPanel.add(clear);
                    JButton ok = new JButton("OK");
                    ok.setActionCommand("ok");
                    ok.addActionListener(al);
                    buttonsPanel.add(ok);
                    this.gridbag.setConstraints(jsp, this.constraints);
                    this.add(jsp);
                    this.gridbag.setConstraints(buttonsPanel, this.constraints);
                    this.add(buttonsPanel);
                    continue block8;
                }
                default: {
                    System.err.println("CSpecPalette(): unknown widget!");
                }
            }
        }
    }
}

