/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist;

import com.bbn.openmap.corba.CSpecialist.ActionUnion;
import com.bbn.openmap.corba.CSpecialist.CProjection;
import com.bbn.openmap.corba.CSpecialist.GraphicChange;
import com.bbn.openmap.corba.CSpecialist.LLPoint;
import com.bbn.openmap.corba.CSpecialist.MouseEvent;
import com.bbn.openmap.corba.CSpecialist.ServerPOA;
import com.bbn.openmap.corba.CSpecialist.UGraphic;
import com.bbn.openmap.corba.CSpecialist.UWidget;
import com.bbn.openmap.corba.CSpecialist.UpdateRecord;
import com.bbn.openmap.corba.CSpecialist.WidgetChange;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.corba.CORBASupport;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.ShortHolder;
import org.omg.CORBA.StringHolder;

public abstract class Specialist
extends ServerPOA {
    protected static String iorfile = null;
    protected static String naming = null;
    Dictionary clientPaletteLists = new Hashtable();
    Dictionary clientGestureActionLists = new Hashtable();
    protected Vector currentPaletteList;
    protected Vector currentGestureActionList;
    private short selectionDistance;
    private boolean wantAreaEvents;
    protected Vector graphicUpdates = new Vector();

    public Specialist() {
        this("Default", 0, false);
    }

    public Specialist(String name) {
        this(name, 0, false);
    }

    public Specialist(String name, short sd, boolean wae) {
        this.setSelectionDistance(sd);
        this.setWantAreaEvents(wae);
    }

    public UGraphic[] getRectangle(CProjection p, LLPoint llnw, LLPoint llse, String staticArgs, StringHolder dynamicArgs, ShortHolder graphicSelectableDistance, BooleanHolder areaEvents, GraphicChange notifyOnChange, String uniqueID) {
        try {
            UGraphic[] gl = this.fillRectangle(p, llnw, llse, staticArgs, dynamicArgs, notifyOnChange, uniqueID);
            graphicSelectableDistance.value = this.selectionDistance;
            areaEvents.value = this.wantAreaEvents;
            return gl;
        }
        catch (Throwable t) {
            Debug.error((String)("Specialist.getRectangle(): " + t));
            t.printStackTrace();
            throw new RuntimeException();
        }
    }

    public void signoff(String uniqueID) {
        this.signOff(uniqueID);
        this.clientPaletteLists.remove(uniqueID);
    }

    public UWidget[] getPaletteConfig(WidgetChange notifyOnChange, String staticArgs, StringHolder dynamicArgs, String uniqueID) {
        this.currentPaletteList = (Vector)this.clientPaletteLists.get(uniqueID);
        if (this.currentPaletteList == null) {
            this.currentPaletteList = new Vector();
            this.clientPaletteLists.put(uniqueID, this.currentPaletteList);
        }
        this.makePalette(notifyOnChange, staticArgs, dynamicArgs, uniqueID);
        return this.packPalette();
    }

    protected UWidget[] packPalette() {
        int num_widgets = this.currentPaletteList.size();
        UWidget[] widgets = new UWidget[num_widgets];
        for (int i = 0; i < num_widgets; ++i) {
            widgets[i] = (UWidget)this.currentPaletteList.elementAt(i);
        }
        return widgets;
    }

    public void addPalette(UWidget uwidget) {
        if (uwidget == null) {
            return;
        }
        this.currentPaletteList.addElement(uwidget);
    }

    public void clearPalette() {
        this.currentPaletteList.removeAllElements();
    }

    public ActionUnion[] sendGesture(MouseEvent gesture, String uniqueID) {
        this.currentGestureActionList = (Vector)this.clientGestureActionLists.get(uniqueID);
        if (this.currentGestureActionList == null) {
            this.currentGestureActionList = new Vector();
            this.clientGestureActionLists.put(uniqueID, this.currentGestureActionList);
        }
        this.graphicUpdates.removeAllElements();
        this.currentGestureActionList.removeAllElements();
        try {
            this.receiveGesture(gesture, uniqueID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int num_graphicUpdates = this.graphicUpdates.size();
        if (num_graphicUpdates > 0) {
            UpdateRecord[] urs = new UpdateRecord[num_graphicUpdates];
            for (int i = 0; i < num_graphicUpdates; ++i) {
                urs[i] = (UpdateRecord)this.graphicUpdates.elementAt(i);
            }
            ActionUnion au = new ActionUnion();
            au.ginfo(urs);
            this.currentGestureActionList.addElement(au);
        }
        return this.packGestures();
    }

    protected ActionUnion[] packGestures() {
        int num_actions = this.currentGestureActionList.size();
        ActionUnion[] actions = new ActionUnion[num_actions];
        for (int i = 0; i < num_actions; ++i) {
            actions[i] = (ActionUnion)this.currentGestureActionList.elementAt(i);
        }
        return actions;
    }

    public void clearGesture() {
        this.currentGestureActionList.removeAllElements();
    }

    public void addInfoText(String itext) {
        ActionUnion ret = new ActionUnion();
        ret.itext(itext);
        this.currentGestureActionList.addElement(ret);
    }

    public void addPlainText(String ptext) {
        ActionUnion ret = new ActionUnion();
        ret.ptext(ptext);
        this.currentGestureActionList.addElement(ret);
    }

    public void addHTMLText(String htext) {
        ActionUnion ret = new ActionUnion();
        ret.htext(htext);
        this.currentGestureActionList.addElement(ret);
    }

    public void addURL(String url) {
        ActionUnion ret = new ActionUnion();
        ret.url(url);
        this.currentGestureActionList.addElement(ret);
    }

    public void addGraphic(UpdateRecord ur) {
        this.graphicUpdates.addElement(ur);
    }

    public abstract UGraphic[] fillRectangle(CProjection var1, LLPoint var2, LLPoint var3, String var4, StringHolder var5, GraphicChange var6, String var7);

    public void receiveGesture(MouseEvent gesture, String uniqueID) {
    }

    public void makePalette(WidgetChange notifyOnChange, String staticArgs, StringHolder dynamicArgs, String uniqueID) {
    }

    protected void setWantAreaEvents(boolean setting) {
        this.wantAreaEvents = setting;
    }

    protected void setSelectionDistance(short value) {
        this.selectionDistance = value;
    }

    protected boolean getWantAreaEvents() {
        return this.wantAreaEvents;
    }

    protected short getSelectionDistance() {
        return this.selectionDistance;
    }

    public abstract void signOff(String var1);

    public void start(String[] args) {
        CORBASupport cs = new CORBASupport();
        if (args != null) {
            this.parseArgs(args);
        }
        cs.start(this, args, iorfile, naming);
    }

    public void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-ior")) {
                iorfile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-name")) {
                naming = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-help")) {
                this.printHelp();
                continue;
            }
            if (!args[i].equalsIgnoreCase("-h")) continue;
            this.printHelp();
        }
        if (iorfile == null && naming == null) {
            Debug.error((String)"IOR file and name service name are null!  Use `-ior' or '-name' flag!");
        }
    }

    public void printHelp() {
        Debug.output((String)"usage: java <specialist> [-ior <file> || -name <NAME>]");
        System.exit(1);
    }
}

