/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.mapTile;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.Layer;
import com.bbn.openmap.dataAccess.mapTile.MapTileCoordinateTransform;
import com.bbn.openmap.dataAccess.mapTile.MapTileMaker;
import com.bbn.openmap.dataAccess.mapTile.ZoomLevelInfo;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.util.PropUtils;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoomLevelMaker
extends ZoomLevelInfo {
    public static final String BOUNDS_PROPERTY = "bounds";
    public static final String NAME_PROPERTY = "name";
    public static final String DESCRIPTION_PROPERTY = "description";
    public static final String ZOOM_LEVEL_PROPERTY = "zoomLevel";
    public static final String LAYERS_PROPERTY = "layers";
    public static final String RANGE_PROPERTY = "range";
    public static final int RANGE_NOT_SET = -1;
    protected String name;
    protected String description;
    protected List<String> layers;
    protected List<Layer> layerList;
    protected int range = -1;
    protected List<Rectangle2D> bounds = new LinkedList<Rectangle2D>();

    public ZoomLevelMaker() {
    }

    public ZoomLevelMaker(String name, String desc, int zoomLevel) {
        this.name = name;
        this.description = desc;
        this.zoomLevel = zoomLevel;
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        Vector<String> layerStrings;
        String layerPropertyStrings;
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.name = props.getProperty(prefix + NAME_PROPERTY, this.name);
        this.description = props.getProperty(prefix + DESCRIPTION_PROPERTY, this.description);
        this.zoomLevel = PropUtils.intFromProperties(props, prefix + ZOOM_LEVEL_PROPERTY, this.zoomLevel);
        this.range = PropUtils.intFromProperties(props, prefix + RANGE_PROPERTY, this.range);
        String boundsPropertyStrings = props.getProperty(prefix + BOUNDS_PROPERTY);
        if (boundsPropertyStrings != null) {
            Vector<String> boundsStrings = PropUtils.parseSpacedMarkers(boundsPropertyStrings);
            int count = 0;
            while (boundsStrings != null && !boundsStrings.isEmpty() && boundsStrings.size() >= count + 4) {
                double lat1 = Double.parseDouble(boundsStrings.get(count));
                double lon1 = Double.parseDouble(boundsStrings.get(count + 1));
                double lat2 = Double.parseDouble(boundsStrings.get(count + 2));
                double lon2 = Double.parseDouble(boundsStrings.get(count + 3));
                this.bounds.add(this.createProperBounds(lon1, lat1, lon2, lat2));
                count += 4;
            }
        }
        if ((layerPropertyStrings = props.getProperty(prefix + LAYERS_PROPERTY)) != null && (layerStrings = PropUtils.parseSpacedMarkers(layerPropertyStrings)) != null && !layerStrings.isEmpty()) {
            this.getLayers().addAll(layerStrings);
        }
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + "class", this.getClass().getName());
        props.put(prefix + NAME_PROPERTY, PropUtils.unnull(this.name));
        props.put(prefix + DESCRIPTION_PROPERTY, PropUtils.unnull(this.description));
        props.put(prefix + ZOOM_LEVEL_PROPERTY, Integer.toString(this.zoomLevel));
        if (this.range != -1) {
            props.put(prefix + RANGE_PROPERTY, Integer.toString(this.range));
        }
        StringBuffer buf = new StringBuffer();
        for (String layerMarkerName : this.layers) {
            buf.append(layerMarkerName).append(" ");
        }
        props.put(prefix + LAYERS_PROPERTY, buf.toString().trim());
        buf = new StringBuffer();
        for (Rectangle2D bound : this.getBounds()) {
            double x = bound.getX();
            double y = bound.getY();
            buf.append(y).append(" ").append(x).append(" ").append(y + bound.getHeight()).append(" ").append(x + bound.getWidth()).append(" ");
        }
        props.put(prefix + BOUNDS_PROPERTY, buf.toString().trim());
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        I18n i18n = Environment.getI18n();
        PropUtils.setI18NPropertyInfo(i18n, props, ZoomLevelMaker.class, NAME_PROPERTY, "Name", "Name for zoom level tiles", null);
        PropUtils.setI18NPropertyInfo(i18n, props, ZoomLevelMaker.class, DESCRIPTION_PROPERTY, "Descroption", "Description for zoom level tiles", null);
        PropUtils.setI18NPropertyInfo(i18n, props, ZoomLevelMaker.class, ZOOM_LEVEL_PROPERTY, "Zoom Level (1-20)", "Number for zoom level", null);
        PropUtils.setI18NPropertyInfo(i18n, props, ZoomLevelMaker.class, BOUNDS_PROPERTY, "Bounds", "Bounds for tile creation (lat lon lat lon)", null);
        PropUtils.setI18NPropertyInfo(i18n, props, ZoomLevelMaker.class, LAYERS_PROPERTY, "Layers", "Space separated marker names for layers used in tiles.", null);
        PropUtils.setI18NPropertyInfo(i18n, props, ZoomLevelMaker.class, RANGE_PROPERTY, "Range", "Zoom level to create tiles down to, using the tiles created at this zoom level.", null);
        return props;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getLayers() {
        if (this.layers == null) {
            this.layers = new LinkedList<String>();
        }
        return this.layers;
    }

    public void setLayers(List<String> layers) {
        this.layers = layers;
    }

    public List<Layer> getLayerList() {
        return this.layerList;
    }

    public void setLayerList(List<Layer> layerList) {
        this.layerList = layerList;
    }

    @Override
    public void setZoomLevel(int zoomLevel) {
        super.setZoomLevel(zoomLevel);
        this.scale = -1.0f;
    }

    public List<Rectangle2D> getBounds() {
        return this.bounds;
    }

    public void addBounds(Rectangle2D bounds) {
        this.bounds.add(bounds);
    }

    public List<Rectangle2D> getUVBounds(MapTileCoordinateTransform mtct, int zoomLevel) {
        LinkedList<Rectangle2D> ret = new LinkedList<Rectangle2D>();
        for (Rectangle2D bounds : this.getBounds()) {
            ret.add(this.getUVBounds(bounds, mtct, zoomLevel));
        }
        if (ret.isEmpty()) {
            int etc = this.getEdgeTileCount();
            ret.add(new Rectangle2D.Double(0.0, 0.0, etc, etc));
        }
        return ret;
    }

    public Rectangle2D createProperBounds(double x1, double y1, double x2, double y2) {
        double x = Math.min(x1, x2);
        double y = Math.min(y1, y2);
        double w = Math.abs(x1 - x2);
        double h = Math.abs(y1 - y2);
        return new Rectangle2D.Double(x, y, w, h);
    }

    public int getRange() {
        if (this.range <= -1) {
            return this.getZoomLevel();
        }
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public byte[] makeTile(double uvx, double uvy, MapTileMaker mapTileMaker, Proj proj) {
        if (this.layerList != null) {
            return mapTileMaker.makeTile(uvx, uvy, this.getZoomLevel(), this.layerList, proj, mapTileMaker.getBackground());
        }
        return mapTileMaker.makeTile(uvx, uvy, this, proj);
    }
}

