/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape.input;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class LittleEndianInputStream
extends DataInputStream {
    DataInputStream in;

    public LittleEndianInputStream(InputStream in) {
        super(in);
        this.in = new DataInputStream(in);
    }

    public String readString(int length) throws IOException {
        byte[] array = new byte[length];
        this.readFully(array);
        String s = new String(array);
        return s.trim();
    }

    public short readLEShort() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1) {
            throw new EOFException();
        }
        return (short)((byte2 << 8) + byte1);
    }

    public int readLEUnsignedShort() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1) {
            throw new EOFException();
        }
        return (byte2 << 8) + byte1;
    }

    public char readLEChar() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1) {
            throw new EOFException();
        }
        return (char)((byte2 << 8) + byte1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readLEInt() throws IOException {
        int byte4;
        int byte3;
        int byte2;
        int byte1;
        LittleEndianInputStream littleEndianInputStream = this;
        synchronized (littleEndianInputStream) {
            byte1 = this.in.read();
            byte2 = this.in.read();
            byte3 = this.in.read();
            byte4 = this.in.read();
        }
        if (byte4 == -1) {
            throw new EOFException();
        }
        return (byte4 << 24) + (byte3 << 16) + (byte2 << 8) + byte1;
    }

    public long readLELong() throws IOException {
        long byte1 = this.in.read();
        long byte2 = this.in.read();
        long byte3 = this.in.read();
        long byte4 = this.in.read();
        long byte5 = this.in.read();
        long byte6 = this.in.read();
        long byte7 = this.in.read();
        long byte8 = this.in.read();
        if (byte8 == -1L) {
            throw new EOFException();
        }
        return (byte8 << 56) + (byte7 << 48) + (byte6 << 40) + (byte5 << 32) + (byte4 << 24) + (byte3 << 16) + (byte2 << 8) + byte1;
    }

    public String readLEUTF() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1) {
            throw new EOFException();
        }
        int numbytes = (byte1 << 8) + byte2;
        char[] result = new char[numbytes];
        int numread = 0;
        int numchars = 0;
        while (numread < numbytes) {
            int c2;
            int c1 = this.readUnsignedByte();
            int test = c1 >> 4;
            if (test < 8) {
                ++numread;
                result[numchars++] = (char)c1;
                continue;
            }
            if (test == 12 || test == 13) {
                if ((numread += 2) > numbytes) {
                    throw new UTFDataFormatException();
                }
                c2 = this.readUnsignedByte();
                if ((c2 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                result[numchars++] = (char)((c1 & 0x1F) << 6 | c2 & 0x3F);
                continue;
            }
            if (test == 14) {
                if ((numread += 3) > numbytes) {
                    throw new UTFDataFormatException();
                }
                c2 = this.readUnsignedByte();
                int c3 = this.readUnsignedByte();
                if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                result[numchars++] = (char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                continue;
            }
            throw new UTFDataFormatException();
        }
        return new String(result, 0, numchars);
    }

    public final double readLEDouble() throws IOException {
        return Double.longBitsToDouble(this.readLELong());
    }

    public final float readLEFloat() throws IOException {
        return Float.intBitsToFloat(this.readLEInt());
    }
}

