/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape.output;

import com.bbn.openmap.dataAccess.shape.EsriGraphic;
import com.bbn.openmap.dataAccess.shape.EsriGraphicList;
import com.bbn.openmap.dataAccess.shape.EsriPointList;
import com.bbn.openmap.dataAccess.shape.EsriPolygonList;
import com.bbn.openmap.dataAccess.shape.EsriPolylineList;
import com.bbn.openmap.dataAccess.shape.output.LittleEndianOutputStream;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.awt.geom.Point2D;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;

public class ShpOutputStream {
    public static Logger logger = Logger.getLogger("com.bbn.openmap.dataAccess.shape.output.ShpOutputStream");
    public static final int ESRI_RECORD_HEADER_LENGTH = 4;
    protected GeoCoordTransformation transform;
    private LittleEndianOutputStream _leos = null;

    public ShpOutputStream(OutputStream os) {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        this._leos = new LittleEndianOutputStream(bos);
    }

    public GeoCoordTransformation getTransform() {
        return this.transform;
    }

    public void setTransform(GeoCoordTransformation transform) {
        this.transform = transform;
    }

    public int[][] writeGeometry(EsriGraphicList list) throws IOException {
        if (list instanceof EsriPolygonList || list instanceof EsriPolylineList) {
            return this.writePolyGeometry(list);
        }
        if (list instanceof EsriPointList) {
            return this.writePointGeometry(list);
        }
        return null;
    }

    protected int[][] createPointIndex(OMGraphicList list) {
        int[][] indexData = new int[2][list.size()];
        int pos = 50;
        for (int i = 0; i < list.size(); ++i) {
            int contentLength = 0;
            contentLength += 2;
            OMGraphic graphic = list.getOMGraphicAt(i);
            if (graphic instanceof EsriGraphicList) {
                EsriGraphicList sublist = (EsriGraphicList)graphic;
                contentLength += 16;
                contentLength += 2;
                contentLength += sublist.size() * 6;
            } else {
                contentLength += 4;
                contentLength += 4;
            }
            indexData[1][i] = contentLength;
            indexData[0][i] = pos;
            pos += contentLength + 4;
        }
        return indexData;
    }

    protected int[][] createPolyIndex(EsriGraphicList list) {
        int[][] indexData = new int[2][list.size()];
        int pos = 50;
        for (int i = 0; i < list.size(); ++i) {
            double[] data;
            int contentLength = 0;
            OMGraphic graphic = list.getOMGraphicAt(i);
            contentLength += 2;
            contentLength += 16;
            contentLength += 2;
            contentLength += 2;
            if (graphic instanceof OMGraphicList) {
                OMGraphicList sublist = (OMGraphicList)graphic;
                contentLength += sublist.size() * 2;
                for (int j = 0; j < sublist.size(); ++j) {
                    OMPoly poly = (OMPoly)sublist.getOMGraphicAt(j);
                    data = poly.getLatLonArray();
                    contentLength += data.length * 4;
                }
            } else {
                contentLength += 2;
                data = ((OMPoly)graphic).getLatLonArray();
                contentLength += data.length * 4;
            }
            indexData[1][i] = contentLength;
            indexData[0][i] = pos;
            pos += contentLength + 4;
        }
        return indexData;
    }

    protected int[] getRecordOffsets(int[] contentLengths) {
        int[] offsets = new int[contentLengths.length];
        int pos = 50;
        for (int i = 0; i < contentLengths.length; ++i) {
            offsets[i] = pos;
            pos += contentLengths[i] + 4;
        }
        return offsets;
    }

    protected int[] getPartOffsets(OMGraphicList sublist) {
        int pos = 0;
        int[] offsets = new int[sublist.size()];
        for (int j = 0; j < sublist.size(); ++j) {
            OMPoly poly = (OMPoly)sublist.getOMGraphicAt(j);
            double[] data = poly.getLatLonArray();
            offsets[j] = pos / 2;
            pos += data.length;
        }
        return offsets;
    }

    protected int getPointsPerShape(OMGraphicList sublist) {
        int numPoints = 0;
        for (int i = 0; i < sublist.size(); ++i) {
            OMPoly poly = (OMPoly)sublist.getOMGraphicAt(i);
            double[] data = poly.getLatLonArray();
            numPoints += data.length;
        }
        return numPoints /= 2;
    }

    protected void writeExtents(double[] extents) throws IOException {
        if (this._leos == null) {
            return;
        }
        if (extents[0] == 90.0 && extents[1] == 180.0 && extents[2] == -90.0 && extents[3] == -180.0) {
            this._leos.writeLEDouble(-180.0);
            this._leos.writeLEDouble(-90.0);
            this._leos.writeLEDouble(180.0);
            this._leos.writeLEDouble(90.0);
        } else if (this.transform == null) {
            this._leos.writeLEDouble(extents[1]);
            this._leos.writeLEDouble(extents[0]);
            this._leos.writeLEDouble(extents[3]);
            this._leos.writeLEDouble(extents[2]);
        } else {
            Point2D pnt = this.transform.forward(extents[0], extents[1]);
            this._leos.writeLEDouble(pnt.getX());
            this._leos.writeLEDouble(pnt.getY());
            pnt = this.transform.forward(extents[2], extents[3], pnt);
            this._leos.writeLEDouble(pnt.getX());
            this._leos.writeLEDouble(pnt.getY());
        }
    }

    public int[][] writePolyGeometry(EsriGraphicList list) throws IOException {
        this._leos.writeInt(9994);
        this._leos.writeInt(0);
        this._leos.writeInt(0);
        this._leos.writeInt(0);
        this._leos.writeInt(0);
        this._leos.writeInt(0);
        int[][] indexData = this.createPolyIndex(list);
        int contentLength = 50;
        if (!list.isEmpty()) {
            contentLength = indexData[0][indexData[0].length - 1] + indexData[1][indexData[0].length - 1] + 4;
        }
        this._leos.writeInt(contentLength);
        this._leos.writeLEInt(1000);
        this._leos.writeLEInt(list.getType());
        double[] extents = list.getExtents();
        this.writeExtents(extents);
        this._leos.writeDouble(0.0);
        this._leos.writeDouble(0.0);
        this._leos.writeDouble(0.0);
        this._leos.writeDouble(0.0);
        Point2D.Double pnt = new Point2D.Double();
        for (int i = 0; i < list.size(); ++i) {
            OMPoly poly;
            OMGraphic graphic = list.getOMGraphicAt(i);
            this._leos.writeInt(i + 1);
            this._leos.writeInt(indexData[1][i]);
            this._leos.writeLEInt(list.getType());
            if (graphic instanceof EsriGraphicList) {
                int j;
                EsriGraphicList sublist = (EsriGraphicList)graphic;
                extents = sublist.getExtents();
                this.writeExtents(extents);
                int numParts = sublist.size();
                this._leos.writeLEInt(numParts);
                int numPoints = this.getPointsPerShape(sublist);
                this._leos.writeLEInt(numPoints);
                int[] offsets = this.getPartOffsets(sublist);
                for (j = 0; j < offsets.length; ++j) {
                    this._leos.writeLEInt(offsets[j]);
                }
                for (j = 0; j < sublist.size(); ++j) {
                    poly = (OMPoly)sublist.getOMGraphicAt(j);
                    double[] data = poly.getLatLonArray();
                    int n = 0;
                    while (n < data.length) {
                        double lat = Math.toDegrees(data[n++]);
                        double lon = Math.toDegrees(data[n++]);
                        if (this.transform == null) {
                            this._leos.writeLEDouble(lon);
                            this._leos.writeLEDouble(lat);
                            continue;
                        }
                        this.transform.forward(lat, lon, pnt);
                        this._leos.writeLEDouble(((Point2D)pnt).getX());
                        this._leos.writeLEDouble(((Point2D)pnt).getY());
                    }
                }
                continue;
            }
            extents = ((EsriGraphic)((Object)graphic)).getExtents();
            this.writeExtents(extents);
            this._leos.writeLEInt(1);
            poly = (OMPoly)graphic;
            double[] data = poly.getLatLonArray();
            this._leos.writeLEInt(data.length / 2);
            this._leos.writeLEInt(0);
            int n = 0;
            while (n < data.length) {
                double lat = Math.toDegrees(data[n++]);
                double lon = Math.toDegrees(data[n++]);
                if (this.transform == null) {
                    this._leos.writeLEDouble(lon);
                    this._leos.writeLEDouble(lat);
                    continue;
                }
                this.transform.forward(lat, lon, pnt);
                this._leos.writeLEDouble(((Point2D)pnt).getX());
                this._leos.writeLEDouble(((Point2D)pnt).getY());
            }
        }
        this._leos.flush();
        this._leos.close();
        return indexData;
    }

    public int[][] writePointGeometry(EsriGraphicList list) throws IOException {
        this._leos.writeInt(9994);
        this._leos.writeInt(0);
        this._leos.writeInt(0);
        this._leos.writeInt(0);
        this._leos.writeInt(0);
        this._leos.writeInt(0);
        int[][] indexData = this.createPointIndex(list);
        int contentLength = 50;
        if (!list.isEmpty()) {
            contentLength = indexData[0][indexData[0].length - 1] + indexData[1][indexData[0].length - 1] + 4;
        }
        this._leos.writeInt(contentLength);
        this._leos.writeLEInt(1000);
        this._leos.writeLEInt(list.getType());
        double[] extents = list.getExtents();
        this.writeExtents(extents);
        this._leos.writeDouble(0.0);
        this._leos.writeDouble(0.0);
        this._leos.writeDouble(0.0);
        this._leos.writeDouble(0.0);
        Point2D.Double pnt = new Point2D.Double();
        OMPoint point = null;
        for (int i = 0; i < list.size(); ++i) {
            OMGraphic graphic = list.get(i);
            this._leos.writeInt(i + 1);
            this._leos.writeInt(indexData[1][i]);
            this._leos.writeLEInt(list.getType());
            if (graphic instanceof OMGraphicList) {
                EsriGraphicList sublist = (EsriGraphicList)graphic;
                extents = sublist.getExtents();
                this.writeExtents(extents);
                this._leos.writeLEInt(sublist.size());
                for (int j = 0; j < sublist.size(); ++j) {
                    point = (OMPoint)sublist.getOMGraphicAt(j);
                    LatLonPoint.Double pt = new LatLonPoint.Double(point.getLat(), point.getLon());
                    double lat = ((Point2D)pt).getY();
                    double lon = ((Point2D)pt).getX();
                    if (this.transform == null) {
                        this._leos.writeLEDouble(lon);
                        this._leos.writeLEDouble(lat);
                        continue;
                    }
                    this.transform.forward(lat, lon, pnt);
                    this._leos.writeLEDouble(((Point2D)pnt).getX());
                    this._leos.writeLEDouble(((Point2D)pnt).getY());
                }
                continue;
            }
            point = (OMPoint)graphic;
            LatLonPoint.Double pt = new LatLonPoint.Double(point.getLat(), point.getLon());
            double lat = ((Point2D)pt).getY();
            double lon = ((Point2D)pt).getX();
            if (this.transform == null) {
                this._leos.writeLEDouble(lon);
                this._leos.writeLEDouble(lat);
                continue;
            }
            this.transform.forward(lat, lon, pnt);
            this._leos.writeLEDouble(((Point2D)pnt).getX());
            this._leos.writeLEDouble(((Point2D)pnt).getY());
        }
        this._leos.flush();
        this._leos.close();
        return indexData;
    }
}

