/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.CoordMouseMode;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Properties;

public class NavMouseMode
extends CoordMouseMode {
    public static final transient String modeID = "Navigation";
    protected Point point1;
    protected Point point2;
    protected boolean autoZoom = false;
    MapBean theMap = null;
    protected DrawingAttributes rectAttributes = DrawingAttributes.getDefaultClone();

    public NavMouseMode() {
        this(true);
        this.rectAttributes.setLinePaint(Color.GRAY);
        this.rectAttributes.setMattingPaint(Color.LIGHT_GRAY);
        this.rectAttributes.setMatted(true);
    }

    public NavMouseMode(boolean shouldConsumeEvents) {
        super(modeID, shouldConsumeEvents);
        this.setModeCursor(Cursor.getPredefinedCursor(1));
        this.rectAttributes.setLinePaint(Color.GRAY);
        this.rectAttributes.setMattingPaint(Color.LIGHT_GRAY);
        this.rectAttributes.setMatted(true);
    }

    public void mousePressed(MouseEvent e) {
        if (Debug.debugging("mousemode")) {
            Debug.output(this.getID() + "|NavMouseMode.mousePressed()");
        }
        e.getComponent().requestFocus();
        if (!this.mouseSupport.fireMapMousePressed(e) && e.getSource() instanceof MapBean) {
            this.point1 = e.getPoint();
            this.point2 = null;
            this.autoZoom = true;
        }
    }

    public void mouseClicked(MouseEvent e) {
        Object obj = e.getSource();
        super.mouseClicked(e);
        if (!(obj instanceof MapBean) || this.point1 == null) {
            return;
        }
        MapBean map = (MapBean)obj;
        Projection projection = map.getProjection();
        Proj p = (Proj)projection;
        Point2D llp = map.getCoordinates(e);
        boolean shift = e.isShiftDown();
        boolean control = e.isControlDown();
        if (control) {
            if (shift) {
                p.setScale(p.getScale() * 2.0f);
            } else {
                p.setScale(p.getScale() / 2.0f);
            }
        }
        this.cleanUp();
        p.setCenter(llp);
        map.setProjection(p);
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        if (this.theMap != null) {
            this.cleanUp();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (Debug.debugging("mousemode")) {
            Debug.output(this.getID() + "|NavMouseMode.mouseReleased()");
        }
        if (!this.mouseSupport.fireMapMouseReleased(e)) {
            this.handleMouseReleased(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMouseReleased(MouseEvent e) {
        Object obj = e.getSource();
        MapBean map = this.theMap;
        Point firstPoint = this.point1;
        Point secondPoint = this.point2;
        if (obj != map || !this.autoZoom || firstPoint == null || secondPoint == null) {
            return;
        }
        Projection projection = map.getProjection();
        Proj p = (Proj)projection;
        NavMouseMode navMouseMode = this;
        synchronized (navMouseMode) {
            secondPoint = this.point2 = this.getRatioPoint((MapBean)e.getSource(), firstPoint, e.getPoint());
            int dx = Math.abs(secondPoint.x - firstPoint.x);
            int dy = Math.abs(secondPoint.y - firstPoint.y);
            if (dx < 5 || dy < 5) {
                if (dx < 5 && dy < 5) {
                    Point2D llp = map.getCoordinates(e);
                    boolean shift = e.isShiftDown();
                    boolean control = e.isControlDown();
                    if (control) {
                        if (shift) {
                            p.setScale(p.getScale() * 2.0f);
                        } else {
                            p.setScale(p.getScale() / 2.0f);
                        }
                    }
                    this.cleanUp();
                    p.setCenter(llp);
                    map.setProjection(p);
                } else {
                    this.cleanUp();
                    map.repaint();
                }
                return;
            }
            float newScale = ProjMath.getScale(firstPoint, secondPoint, projection);
            int centerx = Math.min(firstPoint.x, secondPoint.x) + dx / 2;
            int centery = Math.min(firstPoint.y, secondPoint.y) + dy / 2;
            Point2D center = map.inverse(centerx, centery, null);
            p.setScale(newScale);
            p.setCenter(center);
            this.cleanUp();
            map.setProjection(p);
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (Debug.debugging("mousemodedetail")) {
            Debug.output(this.getID() + "|NavMouseMode.mouseEntered()");
        }
        super.mouseEntered(e);
        this.autoZoom = true;
    }

    public void mouseExited(MouseEvent e) {
        if (Debug.debugging("mousemodedetail")) {
            Debug.output(this.getID() + "|NavMouseMode.mouseExited()");
        }
        super.mouseExited(e);
        if (this.theMap == e.getSource()) {
            this.autoZoom = false;
            this.point2 = null;
            this.theMap.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (Debug.debugging("mousemodedetail")) {
            Debug.output(this.getID() + "|NavMouseMode.mouseDragged()");
        }
        super.mouseDragged(e);
        Object obj = e.getSource();
        if (obj instanceof MapBean && this.theMap == null) {
            this.theMap = (MapBean)obj;
            this.theMap.addPaintListener(this);
        }
        MapBean map = this.theMap;
        Point firstPoint = this.point1;
        if (map != null) {
            if (!this.autoZoom) {
                return;
            }
            this.point2 = this.getRatioPoint(map, firstPoint, e.getPoint());
            map.repaint();
        }
    }

    protected void cleanUp() {
        if (this.theMap != null) {
            this.theMap.removePaintListener(this);
            this.theMap = null;
        }
        this.point1 = null;
        this.point2 = null;
    }

    protected Point getRatioPoint(MapBean map, Point pt1, Point pt2) {
        return ProjMath.getRatioPoint(map.getProjection(), pt1, pt2);
    }

    protected void paintRectangle(Graphics g, Point pt1, Point pt2) {
        if (pt1 != null && pt2 != null) {
            int width = Math.abs(pt2.x - pt1.x);
            int height = Math.abs(pt2.y - pt1.y);
            if (width == 0) {
                ++width;
            }
            if (height == 0) {
                ++height;
            }
            Rectangle2D.Double rect1 = new Rectangle2D.Double(pt1.x < pt2.x ? (double)pt1.x : (double)pt2.x, pt1.y < pt2.y ? (double)pt1.y : (double)pt2.y, width, height);
            Rectangle2D.Double rect2 = new Rectangle2D.Double(pt1.x < pt2.x ? (double)(pt1.x + (pt2.x - pt1.x) / 2 - 1) : (double)(pt2.x + (pt1.x - pt2.x) / 2 - 1), pt1.y < pt2.y ? (double)(pt1.y + (pt2.y - pt1.y) / 2 - 1) : (double)(pt2.y + (pt1.y - pt2.y) / 2 - 1), 2.0, 2.0);
            if (this.theMap != null) {
                this.rectAttributes.render((Graphics2D)g, this.theMap.getNonRotatedShape(rect1));
                this.rectAttributes.render((Graphics2D)g, this.theMap.getNonRotatedShape(rect2));
            }
        }
    }

    public void listenerPaint(Object obj, Graphics g) {
        if (this.theMap == null && obj instanceof MapBean) {
            ((MapBean)obj).removePaintListener(this);
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        if (this.point1 != null && this.point2 != null) {
            this.paintRectangle(graphics, this.point1, this.point2);
        }
        graphics.dispose();
    }

    public DrawingAttributes getRectAttributes() {
        return this.rectAttributes;
    }

    public void setRectAttributes(DrawingAttributes rectAttributes) {
        this.rectAttributes = rectAttributes;
    }

    public void setProperties(String prefix, Properties setList) {
        super.setProperties(prefix, setList);
        this.rectAttributes.setProperties(prefix, setList);
    }

    public Properties getProperties(Properties getList) {
        return this.rectAttributes.getProperties(getList);
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        this.rectAttributes.getPropertyInfo(list);
        list.put("initProperties", "lineColor mattingColor matted");
        return list;
    }
}

