/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.gui.menu.MapHandlerMenuItem;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.DataBounds;
import com.bbn.openmap.util.DataBoundsProvider;
import com.bbn.openmap.util.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;

public class DataBoundsViewMenuItem
extends MapHandlerMenuItem
implements ActionListener {
    protected MapBean map;
    protected InformationDelegator infoDelegator;
    protected DataBoundsProvider provider;

    public DataBoundsViewMenuItem(DataBoundsProvider dbp) {
        super(dbp.getName());
        this.provider = dbp;
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.map != null) {
            Proj proj = (Proj)this.map.getProjection();
            DataBounds bounds = this.provider.getDataBounds();
            if (bounds != null) {
                Point2D center = bounds.getCenter();
                if (center != null) {
                    proj.setCenter(center.getY(), center.getX());
                    LatLonPoint.Double llp1 = new LatLonPoint.Double(bounds.getMax().getY(), bounds.getMin().getX());
                    LatLonPoint.Double llp2 = new LatLonPoint.Double(bounds.getMin().getY(), bounds.getMax().getX());
                    float scale = ProjMath.getScale(llp1, llp2, (Projection)proj);
                    proj.setScale(scale);
                    Point2D ul = proj.getUpperLeft();
                    Point2D lr = proj.getLowerRight();
                    double factor1 = (bounds.getMax().getY() - bounds.getMin().getY()) / (ul.getY() - lr.getY());
                    double factor2 = (bounds.getMax().getX() - bounds.getMin().getX()) / (lr.getX() - ul.getX());
                    scale = (float)((double)scale * Math.max(factor1, factor2));
                    proj.setScale(scale * 1.1f);
                    this.map.setProjection(proj);
                }
            } else {
                String complaint = "Can't move map over data: " + this.provider.getName() + " isn't ready.  Add to map?";
                if (this.infoDelegator != null) {
                    this.infoDelegator.displayMessage("Go Over Data", complaint);
                } else {
                    Debug.error(complaint);
                }
            }
        }
    }

    public void findAndInit(Object someObj) {
        super.findAndInit(someObj);
        if (someObj instanceof MapHandler) {
            this.map = (MapBean)this.mapHandler.get("com.bbn.openmap.MapBean");
            this.infoDelegator = (InformationDelegator)this.mapHandler.get("com.bbn.openmap.InformationDelegator");
        }
        if (someObj instanceof MapBean) {
            this.map = (MapBean)someObj;
        }
        if (someObj instanceof InformationDelegator) {
            this.infoDelegator = (InformationDelegator)someObj;
        }
    }

    public void findAndUndo(Object someObj) {
        super.findAndUndo(someObj);
        if (someObj instanceof MapBean && this.map == someObj) {
            this.map = null;
        }
        if (someObj instanceof InformationDelegator && this.infoDelegator == someObj) {
            this.infoDelegator = null;
        }
    }
}

