/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.time;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.event.CenterListener;
import com.bbn.openmap.event.CenterSupport;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.ZoomListener;
import com.bbn.openmap.event.ZoomSupport;
import com.bbn.openmap.gui.MapPanelChild;
import com.bbn.openmap.gui.time.ITimeBoundsUserActionsListener;
import com.bbn.openmap.gui.time.TimePanel;
import com.bbn.openmap.gui.time.TimelineLayer;
import com.bbn.openmap.gui.time.TimelinePanel;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.StandardPCPolicy;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.omGraphics.OMScalingIcon;
import com.bbn.openmap.proj.Cartesian;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.time.Clock;
import com.bbn.openmap.time.TimeBounds;
import com.bbn.openmap.time.TimeBoundsEvent;
import com.bbn.openmap.time.TimeBoundsListener;
import com.bbn.openmap.time.TimeEvent;
import com.bbn.openmap.time.TimeEventListener;
import com.bbn.openmap.time.TimerStatus;
import com.bbn.openmap.tools.icon.BasicIconPart;
import com.bbn.openmap.tools.icon.OMIconFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TimeSliderLayer
extends OMGraphicHandlerLayer
implements PropertyChangeListener,
MapMouseListener,
ComponentListener,
TimeBoundsListener,
TimeEventListener {
    protected static Logger logger = Logger.getLogger("com.bbn.openmap.gui.time.TimeSliderLayer");
    protected CenterSupport centerDelegate;
    protected ZoomSupport zoomDelegate;
    long currentTime = 0L;
    long gameStartTime = 0L;
    long gameEndTime = 0L;
    double selectionWidthMinutes = 1.0;
    double maxSelectionWidthMinutes = 1.0;
    double selectionCenter = 0.0;
    OMRect boundsRectLeftHandle;
    OMRect boundsRectRightHandle;
    Color selectionPointLineColor = TimelineLayer.tint;
    Color selectionPointFillColor = TimelineLayer.tint;
    Color leftHandleFillColor = Color.black;
    Color rightHandleFillColor = Color.black;
    OMLine baseLine;
    OMPoly contextPoly;
    int sliderPointHalfWidth = 5;
    TimelinePanel timelinePanel;
    TimelineLayer timelineLayer;
    public static double magicScaleFactor = 1.0E8;
    Clock clock;
    LabelPanel labelPanel;
    private boolean isNoTime = true;
    private final boolean realTimeMode;
    private boolean userHasChangedScale = false;
    private final List<ITimeBoundsUserActionsListener> timeBoundsUserActionsListeners = new ArrayList<ITimeBoundsUserActionsListener>();
    private final JButton zoomToSelection = new JButton("Zoom to Selection");
    private final JButton renderFixedSelection = new JButton("Show Entire Selection");
    DragState dragState = DragState.NONE;

    public TimeSliderLayer(boolean realTimeMode) {
        this.realTimeMode = realTimeMode;
        this.setName("TimeSlider");
        this.setProjectionChangePolicy(new StandardPCPolicy(this, false));
        this.setMouseModeIDsForEvents(new String[]{"Gestures"});
        this.centerDelegate = new CenterSupport(this);
        this.zoomDelegate = new ZoomSupport(this);
        this.addComponentListener(this);
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof Clock) {
            this.clock = (Clock)someObj;
            this.clock.addTimeEventListener(this);
            this.clock.addTimeBoundsListener(this);
            this.gameStartTime = ((Clock)someObj).getStartTime();
            this.gameEndTime = ((Clock)someObj).getEndTime();
            this.updateTimeBounds(this.gameStartTime, this.gameEndTime);
        }
        if (someObj instanceof CenterListener) {
            this.centerDelegate.add((CenterListener)someObj);
        }
        if (someObj instanceof ZoomListener) {
            this.zoomDelegate.add((ZoomListener)someObj);
        }
        if (someObj instanceof TimelinePanel.Wrapper) {
            this.timelinePanel = ((TimelinePanel.Wrapper)someObj).getTimelinePanel();
            this.timelinePanel.getMapBean().addPropertyChangeListener(this);
            this.timelineLayer = this.timelinePanel.getTimelineLayer();
        }
    }

    public synchronized OMGraphicList prepare() {
        OMGraphicList list = this.getList();
        if (list == null) {
            list = new OMGraphicList();
        } else {
            list.clear();
        }
        TimeDrape drape = new TimeDrape(0, 0, -1, -1);
        drape.setVisible(this.isNoTime);
        drape.setFillPaint(Color.gray);
        drape.generate(this.getProjection());
        list.add(drape);
        list.add(this.getControlWidgetList(this.getProjection()));
        return list;
    }

    public synchronized OMGraphicList getControlWidgetList(Projection proj) {
        Projection projection = this.getProjection();
        OMGraphicList controlWidgetList = new OMGraphicList();
        DrawingAttributes da = new DrawingAttributes();
        da.setFillPaint(this.selectionPointFillColor);
        da.setLinePaint(this.selectionPointLineColor);
        BasicIconPart ip = new BasicIconPart((Shape)new Polygon(new int[]{50, 90, 10, 50}, new int[]{10, 90, 90, 10}, 4), da);
        ImageIcon selectionPointImage = OMIconFactory.getIcon(32, 32, ip);
        OMScalingIcon selectionPoint = new OMScalingIcon(0.0, 0.0, 0, 6, selectionPointImage, 1.0f);
        float selectionPointScale = 1.8f;
        selectionPoint.setMaxScale(1.8f);
        selectionPoint.setMinScale(1.8f);
        controlWidgetList.add(selectionPoint);
        this.boundsRectLeftHandle = new OMRect(0, 0, 0, 0);
        this.boundsRectLeftHandle.setFillPaint(this.leftHandleFillColor);
        controlWidgetList.add(this.boundsRectLeftHandle);
        this.boundsRectRightHandle = new OMRect(0, 0, 0, 0);
        this.boundsRectRightHandle.setFillPaint(this.rightHandleFillColor);
        controlWidgetList.add(this.boundsRectRightHandle);
        int[] xs = new int[8];
        int[] ys = new int[8];
        this.contextPoly = new OMPoly(xs, ys);
        this.contextPoly.setFillPaint(Color.white);
        controlWidgetList.add(this.contextPoly);
        this.baseLine = new OMLine(0, 0, 0, 0);
        this.baseLine.setLinePaint(Color.black);
        this.baseLine.setStroke(new BasicStroke(2.0f));
        controlWidgetList.add(this.baseLine);
        if (projection == null) {
            return controlWidgetList;
        }
        double screenWidth = projection.getWidth();
        float scale = (float)(magicScaleFactor * TimelineLayer.forwardProjectMillis(this.gameEndTime - this.gameStartTime) / screenWidth);
        Object projCenter = projection.getCenter();
        if (((Point2D)projCenter).getX() > this.selectionWidthMinutes || scale != projection.getScale()) {
            double nCenterLon = TimelineLayer.forwardProjectMillis(this.gameEndTime - this.gameStartTime) / 2.0;
            ((Point2D)projCenter).setLocation(nCenterLon, 0.0);
            projection = new Cartesian((Point2D)projCenter, scale, projection.getWidth(), projection.getHeight());
            this.setProjection(projection);
        }
        int contextBuffer = (int)((double)projection.getHeight() * 0.4);
        if (this.selectionCenter * 60.0 * (double)TimeUnit.SECONDS.toMillis(1L) > (double)(this.gameEndTime - this.gameStartTime) || this.selectionCenter < 0.0) {
            this.selectionCenter = TimelineLayer.forwardProjectMillis(this.currentTime);
        }
        if (this.selectionCenter * (double)TimeUnit.MILLISECONDS.toMillis(60000L) > (double)(this.gameEndTime - this.gameStartTime)) {
            this.selectionCenter = (this.gameEndTime - this.gameStartTime) / TimeUnit.MILLISECONDS.toMillis(60000L);
        }
        if (this.selectionCenter < 0.0) {
            this.selectionCenter = 0.0;
        }
        int x = (int)projection.forward(0.0, this.selectionCenter).getX();
        Point2D sliderEndPoint = projection.forward(0.0, this.selectionWidthMinutes);
        Point2D origin = projection.forward(0.0f, 0.0f);
        int selectionHalfWidth = (int)((sliderEndPoint.getX() - origin.getX()) / 2.0);
        int north = contextBuffer;
        int west = x - selectionHalfWidth;
        int south = projection.getHeight() - 1;
        int east = x + selectionHalfWidth;
        int mid = contextBuffer + 1 + (south - contextBuffer) / 2;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("selectionCenter:" + this.selectionCenter + ", selectionWidthMinutes:" + this.selectionWidthMinutes + ", x:" + x + ", origin:" + origin);
            logger.fine("  projection:" + projection);
        }
        selectionPoint.setLon((float)this.selectionCenter);
        selectionPoint.generate(projection);
        int handleWest = west - this.sliderPointHalfWidth;
        int handleEast = west + this.sliderPointHalfWidth;
        int sliderPointHalfHeight = 2;
        this.boundsRectLeftHandle.setLocation(handleWest, north + 2, handleEast, south - 2);
        this.boundsRectLeftHandle.generate(projection);
        handleWest = east - this.sliderPointHalfWidth;
        handleEast = east + this.sliderPointHalfWidth;
        this.boundsRectRightHandle.setLocation(handleWest, north + 2, handleEast, south - 2);
        this.boundsRectRightHandle.generate(projection);
        xs = this.contextPoly.getXs();
        ys = this.contextPoly.getYs();
        xs[0] = 0;
        ys[0] = -1;
        xs[1] = 0;
        ys[1] = north;
        xs[2] = west;
        ys[2] = north;
        xs[3] = west;
        ys[3] = south;
        xs[4] = east;
        ys[4] = south;
        xs[5] = east;
        ys[5] = north;
        xs[6] = projection.getWidth() - 1;
        ys[6] = north;
        xs[7] = projection.getWidth() - 1;
        ys[7] = -1;
        this.contextPoly.generate(projection);
        this.baseLine.setPts(new int[]{0, mid, projection.getWidth(), mid});
        this.baseLine.generate(projection);
        return controlWidgetList;
    }

    protected void updateTimeline() {
        if (this.timelinePanel != null) {
            float scale = (float)(magicScaleFactor * this.selectionWidthMinutes / (double)this.getProjection().getWidth());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Updating timeline with scale: " + scale);
            }
            this.timelinePanel.getMapBean().setScale(scale);
        }
    }

    public String getName() {
        return "TimelineLayer";
    }

    public void setSelectionPointFillColor(Color color) {
        this.selectionPointFillColor = color;
    }

    public void setSelectionPointLineColor(Color color) {
        this.selectionPointLineColor = color;
    }

    public void setLeftHandleFillColor(Color color) {
        this.leftHandleFillColor = color;
    }

    public void setRightHandleFillColor(Color color) {
        this.rightHandleFillColor = color;
    }

    protected void finalizeProjection() {
        Cartesian cartesian;
        Projection projection = this.getProjection();
        Cartesian cartesian2 = cartesian = projection instanceof Cartesian ? (Cartesian)projection : null;
        if (cartesian != null) {
            double screenWidth = cartesian.getWidth();
            cartesian.setLeftLimit(TimelineLayer.forwardProjectMillis(this.gameStartTime));
            cartesian.setRightLimit(TimelineLayer.forwardProjectMillis(this.gameEndTime));
            cartesian.setLimitAnchorPoint(new Point2D.Double(TimelineLayer.forwardProjectMillis(-this.gameStartTime), 0.0));
            float scale = (float)(magicScaleFactor * TimelineLayer.forwardProjectMillis(this.gameEndTime - this.gameStartTime) / screenWidth);
            this.zoomDelegate.fireZoom(302, scale);
            double nCenterLon = TimelineLayer.forwardProjectMillis(this.gameEndTime - this.gameStartTime) / 2.0;
            logger.fine("Telling the center delegate that the new center is 0, " + nCenterLon);
            this.centerDelegate.fireCenter(0.0, nCenterLon);
            double x = cartesian.getCenter().getX();
            if (!MoreMath.approximately_equal(x, nCenterLon)) {
                ((MapHandler)this.getBeanContext()).get(MapBean.class).setCenter(0.0, nCenterLon);
            }
            this.repaint();
        }
    }

    public void updateTime(TimeEvent te) {
        if (this.checkAndSetForNoTime(te)) {
            return;
        }
        TimerStatus timerStatus = te.getTimerStatus();
        if (timerStatus.equals(TimerStatus.STEP_FORWARD) || timerStatus.equals(TimerStatus.STEP_BACKWARD) || timerStatus.equals(TimerStatus.UPDATE)) {
            this.currentTime = te.getSystemTime();
            this.currentTime -= this.gameStartTime;
            this.selectionCenter = TimelineLayer.forwardProjectMillis(this.currentTime);
            this.doPrepare();
        }
        if (timerStatus.equals(TimerStatus.FORWARD) || timerStatus.equals(TimerStatus.BACKWARD) || timerStatus.equals(TimerStatus.STOPPED)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("updated time: " + te);
            }
            if (this.realTimeMode || ((Clock)te.getSource()).isRunning()) {
                this.currentTime = te.getSystemTime();
                this.currentTime -= this.gameStartTime;
                this.selectionCenter = TimelineLayer.forwardProjectMillis(this.currentTime);
                this.doPrepare();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName == "MapBean.projection") {
            logger.fine(propertyName + " from " + evt.getSource());
            Projection timeLineProj = (Projection)evt.getNewValue();
            if (!this.realTimeMode || !this.userHasChangedScale) {
                this.selectionWidthMinutes = (double)(timeLineProj.getScale() * (float)this.getProjection().getWidth()) / magicScaleFactor;
            }
            if (this.selectionWidthMinutes > this.maxSelectionWidthMinutes + 1.0E-4) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("resetting selectionWidthMinutes to max (projection change property change), was " + this.selectionWidthMinutes + ", now " + this.maxSelectionWidthMinutes);
                }
                this.selectionWidthMinutes = this.maxSelectionWidthMinutes;
            }
            this.doPrepare();
        }
    }

    public boolean getUserHasChangedScale() {
        return this.userHasChangedScale;
    }

    public void setUserHasChangedScale(boolean userHasChangedScale) {
        this.userHasChangedScale = userHasChangedScale;
    }

    protected boolean checkAndSetForNoTime(TimeEvent te) {
        this.isNoTime = te == TimeEvent.NO_TIME;
        return this.isNoTime;
    }

    public MapMouseListener getMapMouseListener() {
        return this;
    }

    public String[] getMouseModeServiceList() {
        return this.getMouseModeIDsForEvents();
    }

    public boolean mousePressed(MouseEvent e) {
        this.updateMouseTimeDisplay(e);
        this.clearFixedRenderRange();
        int x = e.getPoint().x;
        int y = e.getPoint().y;
        if (this.boundsRectLeftHandle.contains(x, y)) {
            this.dragState = DragState.LEFT_HANDLE;
            this.userHasChangedScale = true;
        } else if (this.boundsRectRightHandle.contains(x, y)) {
            this.dragState = DragState.RIGHT_HANDLE;
            this.userHasChangedScale = true;
        } else {
            this.dragState = DragState.PRIMARY_HANDLE;
            Projection projection = this.getProjection();
            if (projection != null) {
                Object invPnt = projection.inverse(x, y);
                this.setSelectionCenter(((Point2D)invPnt).getX());
                this.updateTimeline();
            }
        }
        return true;
    }

    public boolean mouseReleased(MouseEvent e) {
        this.updateMouseTimeDisplay(e);
        this.dragState = DragState.NONE;
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        this.updateMouseTimeDisplay(e);
        return false;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.timelineLayer.updateMouseTimeDisplay(new Long(-1L));
    }

    void setSelectionCenter(double newCenter) {
        double offsetEnd;
        this.selectionCenter = newCenter;
        if (this.selectionCenter < 0.0) {
            this.selectionCenter = 0.0;
        }
        if (this.selectionCenter > (offsetEnd = (double)(this.gameEndTime - this.gameStartTime) / 1000.0 / 60.0)) {
            this.selectionCenter = offsetEnd;
        }
        this.clock.setTime(this.gameStartTime + (long)(this.selectionCenter * 60.0 * 1000.0));
    }

    public boolean mouseDragged(MouseEvent e) {
        this.updateMouseTimeDisplay(e);
        Projection projection = this.getProjection();
        if (projection == null) {
            return false;
        }
        int x = e.getPoint().x;
        int y = e.getPoint().y;
        int selectionCenterX = (int)projection.forward(0.0, this.selectionCenter).getX();
        boolean scaleChange = false;
        switch (this.dragState) {
            case PRIMARY_HANDLE: {
                Object invPnt = projection.inverse(x, y);
                this.setSelectionCenter(((Point2D)invPnt).getX());
                break;
            }
            case LEFT_HANDLE: {
                if (x >= selectionCenterX - this.sliderPointHalfWidth) {
                    x = selectionCenterX - this.sliderPointHalfWidth;
                }
                Object invPnt = projection.inverse(x, y);
                double worldMouse = ((Point2D)invPnt).getX();
                this.selectionWidthMinutes = 2.0 * (this.selectionCenter - worldMouse);
                scaleChange = true;
                break;
            }
            case RIGHT_HANDLE: {
                if (x <= selectionCenterX + this.sliderPointHalfWidth) {
                    x = selectionCenterX + this.sliderPointHalfWidth;
                }
                Object invPnt = projection.inverse(x, y);
                double worldMouse = ((Point2D)invPnt).getX();
                this.selectionWidthMinutes = 2.0 * (worldMouse - this.selectionCenter);
                scaleChange = true;
            }
        }
        if (scaleChange) {
            if (this.selectionWidthMinutes > this.maxSelectionWidthMinutes) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("resetting selectionWidthMinutes to max, was " + this.selectionWidthMinutes + ", now " + this.maxSelectionWidthMinutes);
                }
                this.selectionWidthMinutes = this.maxSelectionWidthMinutes;
            }
            this.updateTimeline();
            this.timelineLayer.doPrepare();
        }
        this.doPrepare();
        return true;
    }

    public boolean mouseMoved(MouseEvent e) {
        this.updateMouseTimeDisplay(e);
        return true;
    }

    public void mouseMoved() {
    }

    protected double updateMouseTimeDisplay(MouseEvent e) {
        Projection proj = this.getProjection();
        Object latLong = proj.inverse(e.getPoint());
        double lon = ((Point2D)latLong).getX();
        double endTime = TimelineLayer.forwardProjectMillis(this.gameEndTime - this.gameStartTime);
        if (lon < 0.0) {
            lon = 0.0;
        } else if (lon > endTime) {
            lon = endTime;
        }
        long offsetMillis = TimelineLayer.inverseProjectMillis(lon);
        this.timelineLayer.updateMouseTimeDisplay(new Long(offsetMillis));
        return lon;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.finalizeProjection();
    }

    public void componentShown(ComponentEvent e) {
    }

    public LabelPanel getTimeLabels() {
        if (this.labelPanel == null) {
            this.labelPanel = new LabelPanel();
        }
        return this.labelPanel;
    }

    public void updateTimeLabels(long startTime, long endTime) {
        LabelPanel lp = this.getTimeLabels();
        lp.updateTimeLabels(startTime, endTime);
    }

    public void paint(Graphics g) {
        block2: {
            try {
                super.paint(g);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void updateTimeBounds(TimeBoundsEvent tbe) {
        TimeBounds timeBounds;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("updating time bounds: " + tbe);
        }
        if ((timeBounds = tbe.getNewTimeBounds()) != null) {
            this.updateTimeBounds(timeBounds.getStartTime(), timeBounds.getEndTime());
        }
    }

    public void updateTimeBounds(long start, long end) {
        long boundsStartOffset = start - this.gameStartTime;
        this.currentTime -= boundsStartOffset;
        this.selectionCenter = TimelineLayer.forwardProjectMillis(this.currentTime);
        this.gameStartTime = start;
        this.gameEndTime = end;
        this.updateTimeLabels(this.gameStartTime, this.gameEndTime);
        this.maxSelectionWidthMinutes = TimelineLayer.forwardProjectMillis(this.gameEndTime - this.gameStartTime);
        if (this.realTimeMode && !this.userHasChangedScale) {
            this.selectionWidthMinutes = this.maxSelectionWidthMinutes;
        } else if (this.selectionWidthMinutes > this.maxSelectionWidthMinutes || this.selectionWidthMinutes < 1.0E-4) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("resetting selectionWidthMinutes to max (time bounds property change), was " + this.selectionWidthMinutes + ", now " + this.maxSelectionWidthMinutes);
            }
            this.selectionWidthMinutes = this.maxSelectionWidthMinutes;
        }
        this.finalizeProjection();
        this.updateTimeline();
        this.doPrepare();
        this.repaint();
    }

    public void adjustZoomFromMouseWheel(int rot) {
        Projection projection = this.getProjection();
        if (projection == null) {
            return;
        }
        this.setUserHasChangedScale(true);
        Object minutesPnt0 = projection.inverse(0.0, 0.0);
        Object minutesPnt1 = projection.inverse(1.0, 0.0);
        double minutesPerPixel = ((Point2D)minutesPnt1).getX() - ((Point2D)minutesPnt0).getX();
        double minSelectionWidthMinutes = minutesPerPixel * (double)this.sliderPointHalfWidth * 2.0;
        double selectionWidthPixels = this.selectionWidthMinutes / minutesPerPixel;
        double multiplier = selectionWidthPixels / 40.0;
        this.selectionWidthMinutes += (double)rot * minutesPerPixel * multiplier;
        if (this.selectionWidthMinutes < minSelectionWidthMinutes) {
            this.selectionWidthMinutes = minSelectionWidthMinutes;
        }
        if (this.selectionWidthMinutes > this.maxSelectionWidthMinutes) {
            this.selectionWidthMinutes = this.maxSelectionWidthMinutes;
        }
        this.updateTimeline();
        this.doPrepare();
    }

    public void addTimeBoundsUserActionsListener(ITimeBoundsUserActionsListener timeBoundsUserActionsListener) {
        this.timeBoundsUserActionsListeners.add(timeBoundsUserActionsListener);
    }

    public void removeTimeBoundsUserActionsListener(ITimeBoundsUserActionsListener timeBoundsUserActionsListener) {
        this.timeBoundsUserActionsListeners.remove(timeBoundsUserActionsListener);
    }

    public void clearFixedRenderRange() {
        for (ITimeBoundsUserActionsListener listener : this.timeBoundsUserActionsListeners) {
            listener.clearFixedRenderRange();
        }
    }

    void setSelectionValid(boolean valid) {
        this.zoomToSelection.setEnabled(valid);
        this.renderFixedSelection.setEnabled(valid);
    }

    public static class TimeDrape
    extends OMRect {
        int lo;
        int to;
        int ro;
        int bo;

        public TimeDrape(int leftOffset, int topOffset, int rightOffset, int bottomOffset) {
            super(0, 0, 0, 0);
            this.lo = leftOffset;
            this.to = topOffset;
            this.ro = rightOffset;
            this.bo = bottomOffset;
        }

        public boolean generate(Projection proj) {
            this.setLocation(0 + this.lo, 0 + this.to, proj.getWidth() + this.ro, proj.getHeight() + this.bo);
            return super.generate(proj);
        }
    }

    class LabelPanel
    extends JPanel
    implements MapPanelChild {
        protected JComponent timeStartLabel;
        protected JComponent timeEndLabel;
        public static final String NO_TIME_STRING = "--/--/-- (--:--:--)";

        public LabelPanel() {
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridbag);
            if (TimeSliderLayer.this.realTimeMode) {
                JButton timeStartLabelButton = new JButton(NO_TIME_STRING);
                timeStartLabelButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        for (ITimeBoundsUserActionsListener listener : TimeSliderLayer.this.timeBoundsUserActionsListeners) {
                            listener.invokeDateSelectionGUI(false);
                        }
                    }
                });
                this.timeStartLabel = timeStartLabelButton;
                Font f = this.timeStartLabel.getFont();
                f = new Font(f.getFamily(), f.getStyle(), f.getSize() - 1);
                this.timeStartLabel.setFont(f);
                gridbag.setConstraints(this.timeStartLabel, c);
                this.add(this.timeStartLabel);
                c.fill = 2;
                c.weightx = 1.0;
                JLabel buffer = new JLabel();
                gridbag.setConstraints(buffer, c);
                this.add(buffer);
                TimeSliderLayer.this.renderFixedSelection.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        long selectionStart = TimeSliderLayer.this.timelineLayer.getSelectionStart();
                        long selectionEnd = TimeSliderLayer.this.timelineLayer.getSelectionEnd();
                        if (selectionStart > 0L && selectionEnd > 0L) {
                            for (ITimeBoundsUserActionsListener listener : TimeSliderLayer.this.timeBoundsUserActionsListeners) {
                                listener.setFixedRenderRange(selectionStart, selectionEnd);
                            }
                        }
                    }
                });
                TimeSliderLayer.this.renderFixedSelection.setEnabled(false);
                TimeSliderLayer.this.renderFixedSelection.setFont(f);
                c.weightx = 0.0;
                gridbag.setConstraints(TimeSliderLayer.this.renderFixedSelection, c);
                this.add(TimeSliderLayer.this.renderFixedSelection);
                c.fill = 2;
                c.weightx = 1.0;
                buffer = new JLabel();
                gridbag.setConstraints(buffer, c);
                this.add(buffer);
                TimeSliderLayer.this.zoomToSelection.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        long selectionStart = TimeSliderLayer.this.timelineLayer.getSelectionStart();
                        long selectionEnd = TimeSliderLayer.this.timelineLayer.getSelectionEnd();
                        if (selectionStart > 0L && selectionEnd > 0L) {
                            TimeSliderLayer.this.timelineLayer.clearSelection();
                            TimeSliderLayer.this.userHasChangedScale = false;
                            for (ITimeBoundsUserActionsListener listener : TimeSliderLayer.this.timeBoundsUserActionsListeners) {
                                listener.setTimeBounds(selectionStart, selectionEnd);
                            }
                            TimeSliderLayer.this.updateTimeBounds(selectionStart, selectionEnd);
                            TimeSliderLayer.this.updateTimeline();
                        }
                    }
                });
                TimeSliderLayer.this.zoomToSelection.setEnabled(false);
                TimeSliderLayer.this.zoomToSelection.setFont(f);
                c.weightx = 0.0;
                gridbag.setConstraints(TimeSliderLayer.this.zoomToSelection, c);
                this.add(TimeSliderLayer.this.zoomToSelection);
                c.fill = 2;
                c.weightx = 1.0;
                buffer = new JLabel();
                gridbag.setConstraints(buffer, c);
                this.add(buffer);
                JButton jumpToRealTime = new JButton("Jump to Real Time");
                jumpToRealTime.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TimeSliderLayer.this.userHasChangedScale = false;
                        for (ITimeBoundsUserActionsListener listener : TimeSliderLayer.this.timeBoundsUserActionsListeners) {
                            listener.jumpToRealTime();
                        }
                        TimeSliderLayer.this.updateTimeline();
                    }
                });
                jumpToRealTime.setFont(f);
                c.weightx = 0.0;
                gridbag.setConstraints(jumpToRealTime, c);
                this.add(jumpToRealTime);
                c.fill = 2;
                c.weightx = 1.0;
                buffer = new JLabel();
                gridbag.setConstraints(buffer, c);
                this.add(buffer);
                c.fill = 0;
                c.weightx = 0.0;
                JButton timeEndLabelButton = new JButton(NO_TIME_STRING);
                timeEndLabelButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        for (ITimeBoundsUserActionsListener listener : TimeSliderLayer.this.timeBoundsUserActionsListeners) {
                            listener.invokeDateSelectionGUI(true);
                        }
                    }
                });
                this.timeEndLabel = timeEndLabelButton;
                this.timeEndLabel.setFont(f);
                gridbag.setConstraints(this.timeEndLabel, c);
                this.add(this.timeEndLabel);
            } else {
                this.timeStartLabel = new JLabel(NO_TIME_STRING);
                Font f = this.timeStartLabel.getFont();
                f = new Font(f.getFamily(), f.getStyle(), f.getSize() - 1);
                this.timeStartLabel.setFont(f);
                gridbag.setConstraints(this.timeStartLabel, c);
                this.add(this.timeStartLabel);
                c.fill = 2;
                c.weightx = 1.0;
                JLabel buffer = new JLabel();
                gridbag.setConstraints(buffer, c);
                this.add(buffer);
                c.fill = 0;
                c.weightx = 0.0;
                this.timeEndLabel = new JLabel(NO_TIME_STRING, 4);
                this.timeEndLabel.setFont(f);
                gridbag.setConstraints(this.timeEndLabel, c);
                this.add(this.timeEndLabel);
            }
        }

        public String getPreferredLocation() {
            return "South";
        }

        public void setPreferredLocation(String string) {
        }

        public void updateTimeLabels(long startTime, long endTime) {
            if (TimeSliderLayer.this.realTimeMode) {
                ((JButton)this.timeStartLabel).setText(this.getLabelStringForTime(startTime));
                ((JButton)this.timeEndLabel).setText(this.getLabelStringForTime(endTime));
            } else {
                ((JLabel)this.timeStartLabel).setText(this.getLabelStringForTime(startTime));
                ((JLabel)this.timeEndLabel).setText(this.getLabelStringForTime(endTime));
            }
        }

        public String getLabelStringForTime(long time) {
            String ret = NO_TIME_STRING;
            if (time != Long.MAX_VALUE && time != Long.MIN_VALUE) {
                Date date = new Date(time);
                ret = TimePanel.dateFormat.format(date);
            }
            return ret;
        }

        public String getParentName() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DragState {
        NONE,
        PRIMARY_HANDLE,
        LEFT_HANDLE,
        RIGHT_HANDLE;

    }
}

