/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.Layer;
import com.bbn.openmap.event.OverviewMapStatusListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.geo.Geo;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.Properties;

public class OverviewMapAreaLayer
extends Layer
implements OverviewMapStatusListener {
    protected float overviewScale;
    protected OMGraphic poly;
    protected Projection sourceMapProjection;
    protected DrawingAttributes areaAttributes = DrawingAttributes.getDefaultClone();

    public void projectionChanged(ProjectionEvent pEvent) {
        if (this.sourceMapProjection == null) {
            return;
        }
        Projection proj = pEvent.getProjection();
        this.overviewScale = proj.getScale();
        boolean cylindrical = this.sourceMapProjection instanceof Cylindrical;
        double[] llarr = ProjMath.getProjectionScreenOutlineCoords(this.sourceMapProjection);
        if (llarr != null) {
            boolean northPoleVisible = ProjMath.isVisible(this.sourceMapProjection, new LatLonPoint.Double(90.0, 0.0));
            boolean southPoleVisible = ProjMath.isVisible(this.sourceMapProjection, new LatLonPoint.Double(-90.0, 0.0));
            if (northPoleVisible || southPoleVisible) {
                Object center = this.sourceMapProjection.getCenter();
                Object ul = this.sourceMapProjection.getUpperLeft();
                double dist = Geo.distance(((Point2D)center).getY(), ((Point2D)center).getX(), ((Point2D)ul).getY(), ((Point2D)ul).getX());
                this.poly = new OMCircle(((Point2D)center).getY(), ((Point2D)center).getX(), dist, Length.RADIAN);
            } else {
                this.poly = new OMPoly(llarr, 0, cylindrical ? 1 : 3);
            }
            this.areaAttributes.setTo(this.poly);
            this.poly.generate(proj);
        }
    }

    public void setSourceMapProjection(Projection proj) {
        this.sourceMapProjection = proj;
    }

    public void paint(Graphics g) {
        if (this.poly != null && this.overviewScale > this.sourceMapProjection.getScale()) {
            this.poly.render(g);
        }
    }

    public DrawingAttributes getAreaAttributes() {
        return this.areaAttributes;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        this.areaAttributes.setProperties(prefix, props);
        this.poly = null;
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        this.areaAttributes.getProperties(props);
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        this.areaAttributes.getPropertyInfo(props);
        return props;
    }
}

