/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.layer.dted.DTEDCacheHandler;
import com.bbn.openmap.layer.dted.DTEDFrameSubframeInfo;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.geom.Point2D;

public class DTEDCacheManager {
    public static final int SMALL_CACHE_SIZE = 20;
    public static final int MAX_NUM_BOXES = 4;
    protected DTEDCacheHandler[] caches = new DTEDCacheHandler[4];
    protected DTEDFrameSubframeInfo subframeInfo;
    protected String[] dtedDirPaths;
    protected int numColors;
    protected int opaqueness = 255;
    protected int cacheSize = 20;

    public DTEDCacheManager() {
        this(null, 216, 255);
    }

    public DTEDCacheManager(String[] DTEDPaths) {
        this(DTEDPaths, 216, 255);
    }

    public DTEDCacheManager(String[] DTEDPaths, int num_colors, int opaque) {
        this.dtedDirPaths = DTEDPaths;
        this.numColors = num_colors;
        this.opaqueness = opaque;
    }

    public void setDtedDirPaths(String[] paths) {
        this.dtedDirPaths = paths;
        this.resetCaches();
    }

    public void resetCaches() {
        this.caches = new DTEDCacheHandler[4];
    }

    public void setCacheSize(int size) {
        this.cacheSize = size;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public int getElevation(float lat, float lon) {
        if (this.caches[0] == null) {
            this.caches[0] = new DTEDCacheHandler(this.dtedDirPaths, this.numColors, this.opaqueness);
            this.caches[0].setSubframeInfo(this.subframeInfo);
        }
        return this.caches[0].getElevation(lat, lon);
    }

    public void setSubframeInfo(DTEDFrameSubframeInfo dfsi) {
        this.subframeInfo = dfsi;
        for (int i = 0; i < 4; ++i) {
            if (this.caches[i] == null) continue;
            this.caches[i].setSubframeInfo(dfsi);
        }
    }

    public DTEDFrameSubframeInfo getSubframeInfo() {
        return this.subframeInfo;
    }

    public OMGraphicList getRectangle(Projection proj) {
        float[] lat = new float[3];
        float[] lon = new float[3];
        int xa = 2;
        int ya = 2;
        int lat_minus = 2;
        int lon_minus = 2;
        Object ll1 = proj.getUpperLeft();
        Object ll2 = proj.getLowerRight();
        lat[0] = (float)((Point2D)ll1).getY();
        lon[0] = (float)((Point2D)ll1).getX();
        lat[1] = (float)((Point2D)ll2).getY();
        lon[1] = (float)((Point2D)ll2).getX();
        lat[2] = (float)((Point2D)ll2).getY();
        lon[2] = (float)((Point2D)ll2).getX();
        if (lon[0] > 0.0f && lon[2] < 0.0f) {
            lon[1] = -179.999f;
            lon_minus = 1;
        }
        if (lat[0] > 0.0f && lat[2] < 0.0f) {
            lat[1] = -1.0E-4f;
            lat_minus = 1;
        }
        if (Debug.debugging("dteddetail")) {
            Debug.output("For :");
            Debug.output("lat[0] " + lat[0]);
            Debug.output("lon[0] " + lon[0]);
            Debug.output("lat[1] " + lat[1]);
            Debug.output("lon[1] " + lon[1]);
            Debug.output("lat[2] " + lat[2]);
            Debug.output("lon[2] " + lon[2]);
            Debug.output("lat_minus = " + lat_minus);
            Debug.output("lon_minus = " + lon_minus);
        }
        if (this.caches[0] == null) {
            this.caches[0] = new DTEDCacheHandler(this.dtedDirPaths, this.numColors, this.opaqueness, this.cacheSize);
            this.caches[0].setSubframeInfo(this.subframeInfo);
        }
        this.caches[0].setProjection(proj, lat[ya - lat_minus], lon[xa - lon_minus], lat[ya], lon[xa]);
        if (lon_minus == 1) {
            if (this.caches[1] == null) {
                this.caches[1] = new DTEDCacheHandler(this.dtedDirPaths, this.numColors, this.opaqueness, this.cacheSize);
                this.caches[1].setSubframeInfo(this.subframeInfo);
            }
            this.caches[1].setProjection(proj, lat[ya - lat_minus], lon[0], lat[ya], -1.0f * lon[1]);
        } else {
            this.caches[1] = null;
        }
        if (lat_minus == 1) {
            if (this.caches[2] == null) {
                this.caches[2] = new DTEDCacheHandler(this.dtedDirPaths, this.numColors, this.opaqueness, this.cacheSize);
                this.caches[2].setSubframeInfo(this.subframeInfo);
            }
            this.caches[2].setProjection(proj, lat[0], lon[xa - lon_minus], -1.0f * lat[1], lon[xa]);
        } else {
            this.caches[2] = null;
        }
        if (lon_minus == 1 && lat_minus == 1) {
            if (this.caches[3] == null) {
                this.caches[3] = new DTEDCacheHandler(this.dtedDirPaths, this.numColors, this.opaqueness, this.cacheSize);
                this.caches[3].setSubframeInfo(this.subframeInfo);
            }
            this.caches[3].setProjection(proj, lat[0], lon[0], -1.0f * lat[1], -1.0f * lon[1]);
        } else {
            this.caches[3] = null;
        }
        OMGraphicList graphics = new OMGraphicList();
        if (Debug.debugging("dted")) {
            Debug.output("--- DTEDCacheManager: getting images: ---");
        }
        for (int nbox = 0; nbox < 4; ++nbox) {
            if (this.caches[nbox] == null) continue;
            OMGraphic image = this.caches[nbox].getNextImage(proj);
            while (image != null) {
                graphics.add(image);
                image = this.caches[nbox].getNextImage(proj);
            }
        }
        return graphics;
    }

    public void setNumColors(int numberOfColors) {
        this.numColors = numberOfColors;
    }

    public int getNumColors() {
        return this.numColors;
    }

    public void setOpaqueness(int setting) {
        this.opaqueness = setting;
    }

    public int getOpaqueness() {
        return this.opaqueness;
    }

    public DTEDCacheHandler[] getCaches() {
        return this.caches;
    }
}

