/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.dted;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.wanderer.Wanderer;
import com.bbn.openmap.util.wanderer.WandererCallback;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DTEDCoverageManager
extends OMGraphicList
implements PropertyConsumer {
    protected I18n i18n = Environment.getI18n();
    public static Logger logger = Logger.getLogger("com.bbn.openmap.layer.dted.DTEDCoverageManager");
    protected String[] paths;
    public static final String DEFAULT_LEVEL0_COLOR_STRING = "CE4F3F";
    public static final String DEFAULT_LEVEL1_COLOR_STRING = "339159";
    public static final String DEFAULT_LEVEL2_COLOR_STRING = "0C75D3";
    public static final String COVERAGE_FILE_PROPERTY = "coverageFile";
    protected boolean[][][] coverage = null;
    protected CoverageDataFile coverageFile = null;
    protected DrawingAttributes[] attributes = null;
    protected OMGraphicList[] levelRects = null;
    protected String prefix;
    protected JPanel panel;

    public DTEDCoverageManager(String[] paths) {
        this.paths = paths;
        this.attributes = new DrawingAttributes[3];
        this.attributes[0] = DrawingAttributes.getDefaultClone();
        this.attributes[0].setLinePaint(PropUtils.parseColor(DEFAULT_LEVEL0_COLOR_STRING));
        this.attributes[1] = DrawingAttributes.getDefaultClone();
        this.attributes[1].setLinePaint(PropUtils.parseColor(DEFAULT_LEVEL1_COLOR_STRING));
        this.attributes[2] = DrawingAttributes.getDefaultClone();
        this.attributes[2].setLinePaint(PropUtils.parseColor(DEFAULT_LEVEL2_COLOR_STRING));
        this.levelRects = new OMGraphicList[3];
        this.levelRects[0] = new OMGraphicList();
        this.levelRects[1] = new OMGraphicList();
        this.levelRects[2] = new OMGraphicList();
    }

    public void reset() {
        this.coverage = null;
        this.clear();
    }

    public boolean[][][] checkOutCoverage(String[] paths) {
        if (paths == null || paths.length == 0) {
            logger.warning("No paths for DTED data given.");
            return null;
        }
        logger.fine("checking out DTED at paths:");
        for (int d1 = 0; d1 < paths.length; ++d1) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("       " + paths[d1]);
            }
            if (BinaryFile.exists(paths[d1])) continue;
            paths[d1] = null;
            logger.fine("       - path invalid, ignoring.");
        }
        CoverageWandererCallback callback = new CoverageWandererCallback();
        Wanderer wanderer = new Wanderer(callback);
        for (int pathNum = 0; pathNum < paths.length; ++pathNum) {
            wanderer.handleEntry(new File(paths[pathNum]));
        }
        return callback.getCoverage();
    }

    public OMGraphicList getCoverageRects(Projection proj) {
        if (this.coverage == null) {
            if (this.coverageFile != null) {
                this.coverage = this.coverageFile.readCoverage();
            }
            if (this.coverage == null) {
                logger.fine("Scanning for frames - This could take several minutes!");
                this.coverage = this.checkOutCoverage(this.paths);
                if (this.coverageFile != null) {
                    this.coverageFile.writeFile(this.coverage);
                }
            }
        }
        if (this.isEmpty()) {
            this.getCoverageRects(-180, -90, 179, 89, 2, proj);
        } else {
            this.generate(proj);
        }
        return this;
    }

    public float[] getCoverage(Projection proj) {
        float[] ret = new float[3];
        if (this.coverage != null) {
            Point pnt1 = new Point();
            Point pnt2 = new Point();
            int height = proj.getHeight();
            int width = proj.getWidth();
            int total = 0;
            for (int x = -180; x < 180; ++x) {
                for (int y = -90; y < 89; ++y) {
                    boolean onMap;
                    proj.forward(y, x, (Point2D)pnt1);
                    proj.forward(y + 1, x + 1, (Point2D)pnt2);
                    double x1 = pnt1.getX();
                    double y1 = pnt1.getY();
                    double x2 = pnt2.getX();
                    double y2 = pnt2.getY();
                    boolean someX = x1 >= 0.0 && x1 <= (double)width || x2 >= 0.0 && x2 <= (double)width;
                    boolean someY = y1 >= 0.0 && y1 <= (double)height || y2 >= 0.0 && y2 <= (double)height;
                    boolean bl = onMap = someX && someY;
                    if (!onMap) continue;
                    int xIndex = x + 180;
                    int yIndex = y + 90;
                    ++total;
                    if (this.coverage[0][yIndex][xIndex]) {
                        ret[0] = ret[0] + 1.0f;
                    }
                    if (this.coverage[1][yIndex][xIndex]) {
                        ret[1] = ret[1] + 1.0f;
                    }
                    if (!this.coverage[2][yIndex][xIndex]) continue;
                    ret[2] = ret[2] + 1.0f;
                }
            }
            logger.info("Total frames: " + total + " " + ret[0] + ", " + ret[1] + ", " + ret[2]);
            ret[0] = ret[0] / (float)total * 100.0f;
            ret[1] = ret[1] / (float)total * 100.0f;
            ret[2] = ret[2] / (float)total * 100.0f;
        }
        return ret;
    }

    public OMGraphicList getCoverageRects(int startx, int starty, int endx, int endy, int lineType, Projection proj) {
        this.clear();
        for (int level = 0; level < 3; ++level) {
            OMGraphicList rectangles = this.levelRects[level];
            rectangles.clear();
            rectangles.setVague(true);
            for (int lat = starty; lat <= endy && lat < 90; ++lat) {
                for (int lon = startx; lon <= endx && lon < 180; ++lon) {
                    if (!this.coverage[level][lat + 90][lon + 180]) continue;
                    double offset = (double)level * 0.1;
                    double up = (double)lat + offset;
                    double left = (double)lon + offset;
                    double down = (double)lat + 1.0 - offset;
                    double right = (double)lon + 1.0 - offset;
                    OMRect rect = new OMRect(up, left, down, right, lineType);
                    this.attributes[level].setTo(rect);
                    rect.generate(proj);
                    rectangles.add(rect);
                }
            }
            this.add(rectangles);
        }
        return this;
    }

    public Properties getProperties(Properties getList) {
        if (getList == null) {
            getList = new Properties();
        }
        for (DrawingAttributes atts : this.attributes) {
            atts.getProperties(getList);
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        if (this.coverageFile != null) {
            getList.put(prefix + COVERAGE_FILE_PROPERTY, this.coverageFile.getAbsolutePath());
        }
        if (this.paths != null) {
            StringBuilder sBuilder = new StringBuilder();
            for (String path : this.paths) {
                if (sBuilder.length() != 0) {
                    sBuilder.append(";");
                }
                sBuilder.append(path);
            }
            getList.put(prefix + "paths", sBuilder.toString());
        }
        return getList;
    }

    public Properties getPropertyInfo(Properties list) {
        return list;
    }

    public String getPropertyPrefix() {
        return this.prefix;
    }

    public void setProperties(Properties setList) {
        this.setProperties(null, setList);
    }

    public void setProperties(String prefix, Properties setList) {
        this.setPropertyPrefix(prefix);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.attributes[0].setProperties(prefix + "0", setList);
        this.attributes[1].setProperties(prefix + "1", setList);
        this.attributes[2].setProperties(prefix + "2", setList);
        String coverageFileString = setList.getProperty(prefix + COVERAGE_FILE_PROPERTY);
        if (coverageFileString != null) {
            this.coverageFile = new CoverageDataFile(coverageFileString);
        }
    }

    public void setPropertyPrefix(String prefix) {
        this.prefix = prefix;
    }

    public CoverageDataFile getCoverageFile() {
        return this.coverageFile;
    }

    public void setCoverageFile(CoverageDataFile coverageFile) {
        this.coverageFile = coverageFile;
    }

    public Component getGUI(final OMGraphicHandlerLayer layer) {
        if (this.panel == null) {
            this.panel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            this.panel.setLayout(gridbag);
            ActionListener aListener = new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    int level = Integer.parseInt(ae.getActionCommand());
                    DTEDCoverageManager.this.levelRects[level].setVisible(((JCheckBox)ae.getSource()).isSelected());
                    layer.doPrepare();
                }
            };
            int level = 0;
            while (level < 3) {
                JPanel pane = new JPanel();
                String interString = this.i18n.get(DTEDCoverageManager.class, "level" + level + "title", "Level " + level + ": ");
                pane.add(new JLabel(interString));
                String showString = this.i18n.get(DTEDCoverageManager.class, "show", "Show");
                JCheckBox jcb = new JCheckBox(showString, this.levelRects[level].isVisible());
                jcb.addActionListener(aListener);
                jcb.setActionCommand(Integer.toString(level));
                pane.add(jcb);
                pane.add(this.attributes[level].getGUI());
                c.gridy = level++;
                gridbag.setConstraints(pane, c);
                this.panel.add(pane);
            }
        }
        return this.panel;
    }

    public static class CoverageDataFile {
        File coverageFile = null;

        public CoverageDataFile(String path) {
            this.coverageFile = new File(path);
        }

        public boolean exists() {
            return this.coverageFile != null && this.coverageFile.exists();
        }

        public String getAbsolutePath() {
            if (this.coverageFile != null) {
                return this.coverageFile.getAbsolutePath();
            }
            return "";
        }

        public boolean[][][] readCoverage() {
            if (this.exists()) {
                try {
                    RandomAccessFile raf = new RandomAccessFile(this.coverageFile, "rw");
                    boolean[][][] coverage = new boolean[3][180][360];
                    for (int level = 0; level < 3; ++level) {
                        for (int y = 0; y < 180; ++y) {
                            for (int x = 0; x < 360; ++x) {
                                coverage[level][y][x] = raf.readBoolean();
                            }
                        }
                    }
                    raf.close();
                    return coverage;
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }

        public void writeFile(boolean[][][] coverage) {
            try {
                RandomAccessFile raf = new RandomAccessFile(this.coverageFile, "rw");
                for (int level = 0; level < 3; ++level) {
                    for (int y = 0; y < 180; ++y) {
                        for (int x = 0; x < 360; ++x) {
                            raf.writeBoolean(coverage[level][y][x]);
                        }
                    }
                }
                raf.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    static class CoverageWandererCallback
    implements WandererCallback {
        boolean[][][] cov;
        protected int curLon = Integer.MAX_VALUE;

        CoverageWandererCallback() {
            this.cov = new boolean[3][180][360];
        }

        public boolean handleDirectory(File directory) {
            String name = directory.getName().toLowerCase();
            char hemi = name.charAt(0);
            if (name.length() == 4 && (hemi == 'e' || hemi == 'w')) {
                try {
                    this.curLon = (hemi == 'w' ? -1 : 1) * Integer.parseInt(name.substring(1)) + 180;
                }
                catch (NumberFormatException nfe) {
                    this.curLon = Integer.MAX_VALUE;
                    logger.warning("Can't process " + name);
                }
            }
            return true;
        }

        public boolean handleFile(File file) {
            if (this.curLon != Integer.MAX_VALUE) {
                String name = file.getName().toLowerCase();
                char hemi = name.charAt(0);
                char level = name.charAt(name.length() - 1);
                if (name.length() == 7 && name.charAt(name.length() - 4) == '.' && (hemi == 'n' || hemi == 's')) {
                    try {
                        int curLat = (hemi == 's' ? -1 : 1) * Integer.parseInt(name.substring(1, name.length() - 4)) + 90;
                        if (level == '0') {
                            this.cov[0][curLat][this.curLon] = true;
                        } else if (level == '1') {
                            this.cov[1][curLat][this.curLon] = true;
                        } else if (level == '2') {
                            this.cov[2][curLat][this.curLon] = true;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        logger.warning("Can't process " + name);
                    }
                }
            }
            return true;
        }

        boolean[][][] getCoverage() {
            return this.cov;
        }
    }
}

