/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.e00;

import com.bbn.openmap.omGraphics.OMGraphicAdapter;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class TX7
extends OMGraphicAdapter {
    double w = 1.0;
    double angle = 0.0;
    LatLonPoint llp1 = new LatLonPoint.Double();
    LatLonPoint llp2 = new LatLonPoint.Double();
    Point pt1 = new Point();
    Point pt2 = new Point();
    AffineTransform at = new AffineTransform();
    double[] llpoints;
    String str;
    Font font = defaultFont;
    GlyphVector gv;
    double distance;
    boolean badprojection;
    static final Font defaultFont = new Font("Arial", 0, 10);

    public TX7(double[] llpoints, String str, boolean isRadian) {
        this(llpoints, str, isRadian, null);
    }

    public TX7(double[] llpoints, String str, boolean isRadian, Font font) {
        this.str = str == null ? " " : str;
        this.font = font == null ? defaultFont : font;
        this.setLocation(llpoints, isRadian);
    }

    public TX7(double[] llpoints, String str) {
        this(llpoints, str, true, null);
    }

    public void setText(String S) {
        this.str = S;
        this.compute();
    }

    public void setFont(Font f) {
        this.font = f;
        this.compute();
    }

    public void setLocation(double[] llpoints, boolean isRadian) {
        this.llpoints = llpoints;
        if (!isRadian) {
            float cv = (float)Math.PI / 180;
            int i = 0;
            while (i < llpoints.length) {
                int n = i++;
                llpoints[n] = llpoints[n] * (double)cv;
            }
        }
        this.compute();
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        return this.str;
    }

    public double[] getLocation() {
        return this.llpoints;
    }

    public boolean generate(Projection proj) {
        proj.forward(this.llp1, this.pt1);
        proj.forward(this.llp2, this.pt2);
        double dx = this.pt2.x - this.pt1.x;
        double dy = this.pt2.y - this.pt1.y;
        this.at.setToTranslation(this.pt1.x, this.pt1.y);
        this.at.rotate(Math.atan2(dy, dx) - this.angle, 0.0, 0.0);
        double sc = Math.sqrt(dx * dx + dy * dy);
        boolean bl = this.badprojection = Double.isNaN(sc) || sc / this.distance * (double)proj.getScale() > 1000000.0;
        if (this.badprojection) {
            Debug.message("e00", "badprojection " + this.str);
        } else {
            this.at.scale(sc /= this.w, sc);
        }
        return true;
    }

    public void render(Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.badprojection) {
            return;
        }
        g.setColor(Color.red);
        Graphics2D g2d = (Graphics2D)g;
        if (this.selected) {
            g2d.setPaint(this.selectPaint);
        } else {
            g2d.setPaint(this.linePaint);
        }
        AffineTransform saveAT = g2d.getTransform();
        g2d.transform(this.at);
        g2d.drawGlyphVector(this.gv, 0.0f, 0.0f);
        g.setColor(Color.blue);
        g2d.setTransform(saveAT);
    }

    void compute() {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        this.gv = this.font.createGlyphVector(frc, this.str);
        Rectangle2D r = this.gv.getLogicalBounds();
        this.w = r.getWidth();
        this.angle = 0.0;
        int nseg = this.llpoints.length / 2 - 1;
        double lt1 = this.llpoints[0];
        double ln1 = this.llpoints[1];
        this.llp1.setLatLon(lt1, ln1, true);
        double lt2 = this.llpoints[2 * nseg];
        double ln2 = this.llpoints[2 * nseg + 1];
        this.llp2.setLatLon(lt2, ln2, true);
        this.distance = GreatCircle.sphericalDistance(lt1, ln1, lt2, ln2) * 6378137.0;
        this.setNeedToRegenerate(true);
        this.visible = false;
        double[] ds = new double[nseg];
        double[] az = new double[nseg];
        double[] cs = new double[nseg];
        int j = 2;
        double s = 0.0;
        double corr = 0.0;
        double az0 = 0.0;
        for (int i = 0; i < nseg; ++i) {
            double dz;
            lt2 = (float)this.llpoints[j++];
            ln2 = (float)this.llpoints[j++];
            if (lt2 == lt1 && ln2 == ln1) {
                --i;
                --nseg;
                continue;
            }
            ds[i] = s += GreatCircle.sphericalDistance(lt1, ln1, lt2, ln2);
            az[i] = GreatCircle.sphericalAzimuth(lt1, ln1, lt2, ln2);
            if (i > 0 && (dz = (double)((float)Math.tan((az[i] - az0) / 2.0))) < 0.0) {
                cs[i - 1] = -dz;
                corr -= 2.0 * dz;
            }
            az0 = az[i];
            lt1 = lt2;
            ln1 = ln2;
        }
        if (nseg <= 1) {
            return;
        }
        this.visible = true;
        LineMetrics lm = this.font.getLineMetrics("MM", frc);
        if (lm == null) {
            System.out.println("null metrics");
            return;
        }
        float h = lm.getAscent();
        corr = 0.0;
        this.w -= corr * (double)h;
        float sc = (float)(this.w / s);
        int i = 0;
        while (i < nseg) {
            int n = i++;
            ds[n] = ds[n] * (double)sc;
        }
        int m = this.gv.getNumGlyphs();
        float[] gp = this.gv.getGlyphPositions(0, m, null);
        if (gp == null) {
            System.out.println("gp null");
        }
        double x = 0.0;
        double y = 0.0;
        double s0 = 0.0;
        double ch0 = 0.0;
        j = 0;
        for (int i2 = 0; i2 < m; ++i2) {
            double ya;
            double xa;
            s = i2 == m - 1 || gp == null ? (double)((float)this.w) : (double)gp[2 * i2 + 2];
            double ps = s - s0;
            double theta = az[j];
            double cos1 = Math.cos(theta);
            double sin1 = Math.sin(theta);
            float ch = (float)(cs[j] * (double)h);
            if (s + ch0 < ds[j] - (double)ch || j == nseg - 1) {
                xa = x;
                ya = y;
                x += ps * cos1;
                y += ps * sin1;
            } else {
                double theta2 = az[j + 1];
                double cos2 = Math.cos(theta2);
                double sin2 = Math.sin(theta2);
                double dtheta = theta2 - theta;
                double s1 = ds[j] - (double)ch - ch0 - s0;
                double s2 = s1 * Math.sin(dtheta);
                s2 = ps * ps - s2 * s2;
                s2 = Math.sqrt(s2) - s1 * Math.cos(dtheta);
                double dx = s1 * cos1 + s2 * cos2;
                double dy = s1 * sin1 + s2 * sin2;
                double thetai = Math.atan2(dy, dx);
                if (ch == 0.0f) {
                    xa = x;
                    ya = y;
                } else {
                    dx += (double)ch * cos1 + (double)ch * cos2;
                    dy += (double)ch * sin1 + (double)ch * sin2;
                    xa = x + (double)h * sin1 - (double)h * Math.sin(thetai);
                    ya = y - (double)h * cos1 + (double)h * Math.cos(thetai);
                }
                x += dx;
                y += dy;
                ++j;
                ch0 = ch;
                theta = thetai;
            }
            this.gv.setGlyphPosition(i2, new Point2D.Double(xa, ya));
            if (theta != 0.0) {
                AffineTransform at = new AffineTransform();
                at.rotate(theta);
                this.gv.setGlyphTransform(i2, at);
            }
            s0 = s;
        }
        this.angle = Math.atan2(y, x);
        this.w = Math.sqrt(x * x + y * y);
    }
}

