/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location.csv;

import com.bbn.openmap.layer.location.Link;
import com.bbn.openmap.layer.location.Location;
import com.bbn.openmap.layer.location.csv.CSVLocationHandler;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.quadtree.QuadTree;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVLinkHandler
extends CSVLocationHandler {
    public static final String Lat2IndexProperty = "lat2Index";
    public static final String Lon2IndexProperty = "lon2Index";
    protected int lat2Index = -1;
    protected int lon2Index = -1;

    @Override
    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        String realPrefix = PropUtils.getScopedPropertyPrefix(this);
        this.lat2Index = PropUtils.intFromProperties(properties, realPrefix + Lat2IndexProperty, this.lat2Index);
        this.lon2Index = PropUtils.intFromProperties(properties, realPrefix + Lon2IndexProperty, this.lon2Index);
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + Lat2IndexProperty, this.lat2Index != -1 ? Integer.toString(this.lat2Index) : "");
        props.put(prefix + Lon2IndexProperty, this.lon2Index != -1 ? Integer.toString(this.lon2Index) : "");
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list.remove("latIndex");
        list.remove("lonIndex");
        list.put("latIndex", "The column index, in the location file, of the first node latitude.");
        list.put("lonIndex", "The column index, in the location file, of the first node longitude.");
        list.put(Lat2IndexProperty, "The column index, in the location file, of the second node latitude.");
        list.put(Lon2IndexProperty, "The column index, in the location file, of the second node longitude.");
        return list;
    }

    @Override
    protected boolean checkIndexSettings() {
        if (this.latIndex == -1 || this.lonIndex == -1 || this.lat2Index == -1 || this.lon2Index == -1) {
            logger.warning("CSVLocationHandler: createData(): Index properties for Lat/Lon/Name are not set properly! lat index:" + this.latIndex + ", lon index:" + this.lonIndex);
            return false;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("CSVLinkHandler: Reading File:" + this.locationFile + " lat1Index: " + this.latIndex + " lon1Index: " + this.lonIndex + " lat2Index: " + this.lat2Index + " lon2Index: " + this.lon2Index);
        }
        return true;
    }

    @Override
    public Component getGUI() {
        JCheckBox showCSVLinkCheck = new JCheckBox("Show Links", this.isShowLocations());
        showCSVLinkCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JCheckBox locationCheck = (JCheckBox)ae.getSource();
                CSVLinkHandler.this.setShowLocations(locationCheck.isSelected());
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("CSVLocationHandler::actionPerformed showLocations is " + CSVLinkHandler.this.isShowLocations());
                }
                CSVLinkHandler.this.getLayer().repaint();
            }
        });
        JButton rereadFilesButton = new JButton("Re-Read Data File");
        rereadFilesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Re-reading Locations file");
                }
                CSVLinkHandler.this.quadtree = null;
                CSVLinkHandler.this.getLayer().doPrepare();
            }
        });
        Box box = Box.createVerticalBox();
        box.add(showCSVLinkCheck);
        box.add(rereadFilesButton);
        return box;
    }

    @Override
    protected void createLocation(List recordList, QuadTree<Location> qt) {
        String name = this.tokenToString(recordList, this.nameIndex, "");
        double lat = this.tokenToDouble(recordList, this.latIndex, 0.0);
        double lon = this.tokenToDouble(recordList, this.lonIndex, 0.0, this.eastIsNeg);
        String iconURL = this.tokenToString(recordList, this.iconIndex, this.defaultIconURL);
        double lat2 = this.tokenToDouble(recordList, this.lat2Index, 0.0);
        double lon2 = this.tokenToDouble(recordList, this.lon2Index, 0.0, this.eastIsNeg);
        Link link = new Link(lat, lon, lat2, lon2, "No details");
        this.getLocationDrawingAttributes().setTo(link);
        link.setLocationHandler(this);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("CSVLinkHandler: " + link.getDetails());
        }
        qt.put(lat, lon, link);
        qt.put(lat2, lon2, link);
        qt.put(lat, lon, this.createLocation(lat, lon, name, iconURL, recordList));
    }
}

