/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.nitf;

import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class NitfHeader {
    public static final int NITF_IMAGE_DES_SIZE = 16;
    public static final int NITF_SYMBOLS_DES_SIZE = 10;
    public static final int NITF_LABELS_DES_SIZE = 7;
    public static final int NITF_TEXT_DES_SIZE = 9;
    public static final int NITF_DATAEXT_DES_SIZE = 13;
    public static final int NITF_RESEXT_DES_SIZE = 11;
    public static final int NITF_USERDEF_SIZE = 19;
    public String FHDR;
    public String CLEVEL;
    public String STYPE;
    public String OSTAID;
    public String FDT;
    public String FTITLE;
    public String FSCLAS;
    public String FSCODE;
    public String FSCTLH;
    public String FSREL;
    public String FSCAUT;
    public String FSCTLN;
    public String FSDWNG;
    public String FSDEVT;
    public String FSCOP;
    public String FSCPYS;
    public String ENCRYP;
    public String ONAME;
    public String OPHONE;
    public String FL;
    public String HL;
    public NitfHeaderAmounts nha = new NitfHeaderAmounts();
    public NitfUserDef nud = new NitfUserDef();

    public boolean read(BinaryFile binFile) {
        try {
            binFile.seek(0L);
            this.FHDR = binFile.readFixedLengthString(9);
            if (!this.FHDR.startsWith("NITF")) {
                return false;
            }
            this.CLEVEL = binFile.readFixedLengthString(2);
            this.STYPE = binFile.readFixedLengthString(4);
            this.OSTAID = binFile.readFixedLengthString(10);
            this.FDT = binFile.readFixedLengthString(14);
            this.FTITLE = binFile.readFixedLengthString(80);
            this.FSCLAS = binFile.readFixedLengthString(1);
            this.FSCODE = binFile.readFixedLengthString(40);
            this.FSCTLH = binFile.readFixedLengthString(40);
            this.FSREL = binFile.readFixedLengthString(40);
            this.FSCAUT = binFile.readFixedLengthString(20);
            this.FSCTLN = binFile.readFixedLengthString(20);
            this.FSDWNG = binFile.readFixedLengthString(6);
            if (this.FSDWNG.startsWith("999998")) {
                this.FSDEVT = binFile.readFixedLengthString(40);
            }
            this.FSCOP = binFile.readFixedLengthString(5);
            this.FSCPYS = binFile.readFixedLengthString(5);
            this.ENCRYP = binFile.readFixedLengthString(1);
            this.ONAME = binFile.readFixedLengthString(27);
            this.OPHONE = binFile.readFixedLengthString(18);
            this.FL = binFile.readFixedLengthString(12);
            this.HL = binFile.readFixedLengthString(6);
            this.nha = this.readSectionInfo(binFile);
            this.nud.UDHDL = binFile.readFixedLengthString(5);
            this.nud.UDHOFL = binFile.readFixedLengthString(3);
            this.nud.RETAG = binFile.readFixedLengthString(6);
            this.nud.REL = binFile.readFixedLengthString(5);
        }
        catch (IOException e) {
            System.err.println("NitfHeader: File IO Error while reading header information:");
            System.err.println(e);
            return false;
        }
        catch (FormatException f) {
            System.err.println("NitfHeader: File IO Format error while reading header information:");
            System.err.println(f);
            return false;
        }
        return true;
    }

    protected NitfHeaderAmounts readSectionInfo(BinaryFile binFile) {
        try {
            this.nha.NUMI = binFile.readFixedLengthString(3);
            binFile.seek(binFile.getFilePointer() + (long)(Integer.parseInt(this.nha.NUMI) * 16));
            this.nha.NUMS = binFile.readFixedLengthString(3);
            binFile.seek(binFile.getFilePointer() + (long)(Integer.parseInt(this.nha.NUMS) * 10));
            this.nha.NUML = binFile.readFixedLengthString(3);
            binFile.seek(binFile.getFilePointer() + (long)(Integer.parseInt(this.nha.NUML) * 7));
            this.nha.NUMT = binFile.readFixedLengthString(3);
            binFile.seek(binFile.getFilePointer() + (long)(Integer.parseInt(this.nha.NUMT) * 9));
            this.nha.NUMDES = binFile.readFixedLengthString(3);
            binFile.seek(binFile.getFilePointer() + (long)(Integer.parseInt(this.nha.NUMDES) * 13));
            this.nha.NUMRES = binFile.readFixedLengthString(3);
        }
        catch (IOException e) {
            System.err.println("NitfHeader: File IO Error while reading header information:");
            System.err.println(e);
            return null;
        }
        catch (FormatException f) {
            System.err.println("NitfHeader: File IO Format error while reading header information:");
            System.err.println(f);
            return null;
        }
        return this.nha;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("\n\nNITF Information about ").append(this.FTITLE).append("\n");
        s.append("-------------------\n");
        s.append("File Type: ").append(this.FHDR).append("\n");
        s.append("Compliance Level: ").append(this.CLEVEL).append("\n");
        s.append("System Type: ").append(this.STYPE).append("\n");
        s.append("Originating Station: ").append(this.OSTAID).append("\n");
        s.append("File Date and Time: ").append(this.FDT).append("\n");
        s.append("Originator's Name: ").append(this.ONAME).append("\n");
        s.append("File Length: ").append(this.FL).append("\n\n");
        s.append(this.nha.NUMI).append(" image\n");
        s.append(this.nha.NUMS).append(" symbol\n");
        s.append(this.nha.NUML).append(" label\n");
        s.append(this.nha.NUMT).append(" text\n");
        s.append(this.nha.NUMDES).append(" dataext\n");
        s.append(this.nha.NUMRES).append(" resext\n");
        return s.toString();
    }

    public static final void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java NitfHeader <path to NITF file>");
            return;
        }
        File file = new File(args[0]);
        BinaryBufferedFile binFile = null;
        try {
            binFile = new BinaryBufferedFile(file);
            NitfHeader header = new NitfHeader();
            if (header.read(binFile)) {
                System.out.println(header);
            } else {
                System.out.println("NitfHeader: NOT read successfully!");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("NitfHeader: file " + args[0] + " not found");
            System.exit(1);
        }
        catch (IOException ioe) {
            System.err.println("NitfHeader: File IO Error while handling NITF header:");
            System.err.println(ioe);
        }
    }

    public static class NitfUserDef {
        public String UDHDL;
        public String UDHOFL;
        public String RETAG;
        public String REL;
    }

    public static class NitfResExtDescription {
        public String LRSH;
        public String LR;
    }

    public static class NitfDataExtDescription {
        public String LDSH;
        public String LD;
    }

    public static class NitfTextDescription {
        public String LTSH;
        public String LT;
    }

    public static class NitfLabelDescription {
        public String LLSH;
        public String LL;
    }

    public static class NitfSymbolsDescription {
        public String LSSH;
        public String LS;
    }

    public static class NitfImageDescription {
        public String LISH;
        public String LI;
    }

    public static class NitfHeaderAmounts {
        public String NUMI;
        public String NUMS;
        public String NUML;
        public String NUMT;
        public String NUMDES;
        public String NUMRES;
    }
}

