/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.layer.rpf.RpfCacheManager;
import com.bbn.openmap.layer.rpf.RpfConstants;
import com.bbn.openmap.layer.rpf.RpfCoverage;
import com.bbn.openmap.layer.rpf.RpfCoverageBox;
import com.bbn.openmap.layer.rpf.RpfFrameCacheHandler;
import com.bbn.openmap.layer.rpf.RpfFrameProvider;
import com.bbn.openmap.layer.rpf.RpfViewAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.event.MapMouseInterpreter;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.cacheHandler.CacheHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RpfLayer
extends OMGraphicHandlerLayer
implements ActionListener,
RpfConstants,
Serializable {
    protected static Logger logger = Logger.getLogger("com.bbn.openmap.layer.rpf.RpfLayer");
    protected static Logger rpfLogger = Logger.getLogger("RPF");
    private static final long serialVersionUID = 1L;
    protected transient RpfCacheManager cache = null;
    protected String[] paths;
    protected RpfViewAttributes viewAttributes;
    protected boolean killCache = true;
    protected RpfFrameProvider frameProvider;
    protected RpfCoverage coverage;
    protected int subframeCacheSize = 20;
    protected int auxSubframeCacheSize = 10;
    private transient JPanel box = null;

    public RpfLayer() {
        this.setName("RPF");
        this.viewAttributes = new RpfViewAttributes();
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
        this.setMouseModeIDsForEvents(new String[]{"Gestures"});
        this.showSubframes(false);
    }

    public RpfLayer(String[] pathsToRPFDirs) {
        this();
        this.setPaths(pathsToRPFDirs);
    }

    public void setPaths(String[] pathsToRPFDirs) {
        if (this.paths != null && pathsToRPFDirs != null && this.paths.length == pathsToRPFDirs.length) {
            boolean same = true;
            for (int i = 0; i < this.paths.length; ++i) {
                same = same && this.paths[i].equals(pathsToRPFDirs[i]);
            }
            if (same && this.frameProvider != null) {
                return;
            }
        }
        if (pathsToRPFDirs != null) {
            this.setFrameProvider(new RpfFrameCacheHandler(pathsToRPFDirs));
        } else {
            logger.warning("Need RPF directory paths.");
            this.frameProvider = null;
        }
        this.paths = pathsToRPFDirs;
        this.setCoverage(new RpfCoverage(this, this.frameProvider));
        this.cache = null;
    }

    public String[] getPaths() {
        return this.paths;
    }

    @Override
    public void removed(Container cont) {
        if (this.killCache) {
            rpfLogger.fine("emptying cache!");
            this.clearCache();
        }
        this.setProjection((Projection)null);
    }

    protected void setDefaultValues() {
        this.paths = null;
    }

    @Override
    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.setPaths(PropUtils.initPathsFromProperties(properties, prefix + "paths", this.paths));
        this.viewAttributes.setProperties(prefix, properties);
        this.showSubframes(this.viewAttributes.showInfo);
        this.subframeCacheSize = PropUtils.intFromProperties(properties, prefix + "subframeCacheSize", this.subframeCacheSize);
        this.auxSubframeCacheSize = PropUtils.intFromProperties(properties, prefix + "subframeCacheSize", this.auxSubframeCacheSize);
        if (this.viewAttributes.chartSeries == null) {
            this.viewAttributes.chartSeries = "ANY";
        }
        this.killCache = PropUtils.booleanFromProperties(properties, prefix + "killCache", this.killCache);
        if (this.coverage != null) {
            this.coverage.setProperties(prefix, properties);
        }
        this.resetPalette();
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        String[] p = this.getPaths();
        StringBuffer pathString = new StringBuffer();
        if (p != null) {
            for (int i = 0; i < p.length; ++i) {
                if (p[i] == null) continue;
                pathString.append(p[i]);
                if (i >= p.length - 1) continue;
                pathString.append(";");
            }
            props.put(prefix + "paths", pathString.toString());
        } else {
            props.put(prefix + "paths", "");
        }
        props.put(prefix + "killCache", new Boolean(this.killCache).toString());
        props.put(prefix + "subframeCacheSize", Integer.toString(this.subframeCacheSize));
        props.put(prefix + "auxSubframeCacheSize", Integer.toString(this.auxSubframeCacheSize));
        this.viewAttributes.setPropertyPrefix(prefix);
        this.viewAttributes.getProperties(props);
        if (this.coverage == null) {
            RpfCoverage cov = new RpfCoverage(this, this.frameProvider);
            cov.setProperties(prefix, new Properties());
            cov.getProperties(props);
        } else {
            this.coverage.getProperties(props);
        }
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        String interString = this.i18n.get(RpfLayer.class, "paths", 3, "Paths to RPF directories.  Semi-colon separated paths.");
        list.put("paths", interString);
        list.put("paths.editor", "com.bbn.openmap.util.propertyEditor.MultiDirectoryPropertyEditor");
        interString = this.i18n.get(RpfLayer.class, "paths", "Data Path");
        list.put("paths.label", interString);
        interString = this.i18n.get(RpfLayer.class, "killCache", 3, "Flag to trigger the cache to be cleared when layer is removed from the map.");
        list.put("killCache", interString);
        list.put("killCache.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        interString = this.i18n.get(RpfLayer.class, "killCache", "Clear Cache");
        list.put("killCache.label", interString);
        interString = this.i18n.get(RpfLayer.class, "subframeCacheSize", 3, "Number of frames to hold in the frame cache.");
        list.put("subframeCacheSize", interString);
        interString = this.i18n.get(RpfLayer.class, "subframeCacheSize", "Frame Cache Size");
        list.put("subframeCacheSize.label", interString);
        interString = this.i18n.get(RpfLayer.class, "auxSubframeCacheSize", 3, "Number of frames to hold in aux. frame caches.");
        list.put("auxSubframeCacheSize", interString);
        interString = this.i18n.get(RpfLayer.class, "auxSubframeCacheSize", "Aux Frame Cache Size");
        list.put("auxSubframeCacheSize.label", interString);
        this.viewAttributes.getPropertyInfo(list);
        RpfCoverage tmpCov = this.coverage;
        if (tmpCov == null) {
            tmpCov = new RpfCoverage(this, this.frameProvider);
        }
        tmpCov.getPropertyInfo(list);
        list.put("initProperties", "paths killCache subframeCacheSize auxSubframeCacheSize " + this.viewAttributes.getInitPropertiesOrder() + " " + "addToBeanContext" + " " + "background" + " " + "removable" + " " + "coverage" + " " + tmpCov.getInitPropertiesOrder());
        return list;
    }

    @Override
    public void resetPalette() {
        this.box = null;
        super.resetPalette();
    }

    public void clearCache() {
        if (this.frameProvider instanceof CacheHandler) {
            ((CacheHandler)((Object)this.frameProvider)).resetCache();
        }
        if (this.cache != null) {
            this.cache.setViewAttributes(null);
            this.cache.setFrameProvider(null);
            this.cache.clearCaches();
        }
        this.frameProvider = null;
        this.setList(null);
        this.cache = null;
    }

    public void setViewAttributes(RpfViewAttributes rva) {
        this.viewAttributes = rva;
        if (this.cache != null) {
            this.cache.setViewAttributes(rva);
        }
    }

    public RpfViewAttributes getViewAttributes() {
        return this.viewAttributes;
    }

    public void setCoverage(RpfCoverage cov) {
        this.coverage = cov;
        if (this.coverage != null) {
            if (this.viewAttributes != null && !this.viewAttributes.chartSeries.equalsIgnoreCase("ANY")) {
                this.coverage.setShowPalette(false);
            }
            this.coverage.coverageManager = null;
        }
    }

    public RpfCoverage getCoverage() {
        return this.coverage;
    }

    public void setFrameProvider(RpfFrameProvider fp) {
        this.frameProvider = fp;
        if (this.cache != null) {
            this.cache.setFrameProvider(this.frameProvider);
        }
    }

    public RpfFrameProvider getFrameProvider() {
        return this.frameProvider;
    }

    public List<RpfCoverageBox> getCoverageBoxes() {
        return this.cache.getCoverageBoxes();
    }

    @Override
    public synchronized OMGraphicList prepare() {
        Projection projection = this.getProjection();
        OMGraphicList retList = new OMGraphicList();
        retList.setTraverseMode(1);
        if (this.frameProvider == null) {
            this.setPaths(this.paths);
            if (this.frameProvider == null) {
                logger.warning(this.getName() + ": null frame provider - either no RPF paths were set, or no frame provider was assigned.  The RpfLayer has no way to get RPF data.");
                return retList;
            }
        }
        if (this.coverage != null && this.coverage.isInUse()) {
            this.coverage.prepare(projection, this.viewAttributes.chartSeries);
            retList.add(this.coverage);
        }
        if (!this.isProjectionOK(projection)) {
            return retList;
        }
        if (this.cache == null) {
            rpfLogger.fine(this.getName() + ": Creating cache!");
            this.cache = new RpfCacheManager(this.frameProvider, this.viewAttributes, this.subframeCacheSize, this.auxSubframeCacheSize);
        }
        if (projection instanceof EqualArc || this.viewAttributes.showMaps || this.viewAttributes.showInfo) {
            // empty if block
        }
        rpfLogger.fine(this.getName() + " doing it");
        if (rpfLogger.isLoggable(Level.FINE)) {
            rpfLogger.fine(this.getName() + "calling getRectangle  with projection: " + projection + " ul = " + projection.getUpperLeft() + " lr = " + projection.getLowerRight());
        }
        if (this.frameProvider.needViewAttributeUpdates()) {
            this.frameProvider.setViewAttributes(this.viewAttributes);
        }
        try {
            retList.addAll(this.cache.getRectangle(projection));
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.getName() + ": finished with " + retList.size() + " graphics");
            }
        }
        catch (NullPointerException npe) {
            logger.warning(this.getName() + ": Something really bad happened - \n " + npe);
            npe.printStackTrace();
            retList = new OMGraphicList();
            this.cache = null;
        }
        return retList;
    }

    @Override
    public boolean isHighlightable(OMGraphic omg) {
        return this.viewAttributes.showInfo && omg instanceof OMRaster && omg.isSelected();
    }

    @Override
    public String getToolTipTextFor(OMGraphic omg) {
        return (String)omg.getAttribute("Tooltip");
    }

    @Override
    public void highlight(OMGraphic omg) {
    }

    @Override
    public void unhighlight(OMGraphic omg) {
    }

    @Override
    public Component getGUI() {
        if (this.box == null) {
            this.box = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.box.setLayout(gridbag);
            c.anchor = 18;
            c.gridx = 0;
            JCheckBox showInfoCheck = new JCheckBox("Show Attributes", this.viewAttributes.showInfo);
            showInfoCheck.setActionCommand("infoCheckCmd");
            showInfoCheck.addActionListener(this);
            String tmpCS = this.viewAttributes.chartSeries;
            if (tmpCS == null) {
                tmpCS = "ANY";
            }
            boolean locked = !tmpCS.equalsIgnoreCase("ANY");
            String lockedTitle = locked ? "Displaying Only - " + tmpCS : "Limit Chart Selection";
            JCheckBox lockSeriesCheck = new JCheckBox(lockedTitle, locked);
            lockSeriesCheck.setActionCommand("lockSeriesCmd");
            lockSeriesCheck.addActionListener(this);
            gridbag.setConstraints(showInfoCheck, c);
            this.box.add(showInfoCheck);
            gridbag.setConstraints(lockSeriesCheck, c);
            this.box.add(lockSeriesCheck);
            if (this.coverage != null) {
                JCheckBox showCoverageCheck = new JCheckBox("Show Coverage", this.coverage.isInUse());
                showCoverageCheck.setActionCommand("coverageCheckCmd");
                showCoverageCheck.addActionListener(this);
                gridbag.setConstraints(showCoverageCheck, c);
                this.box.add(showCoverageCheck);
            }
            JPanel layerStuff = this.getDefaultSettingsPanel(RpfLayer.class, (float)this.viewAttributes.opaqueness / 255.0f);
            gridbag.setConstraints(layerStuff, c);
            this.box.add(layerStuff);
        }
        return this.box;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String cmd = e.getActionCommand();
        if (cmd == "mapsCheckCmd") {
            JCheckBox mapCheck = (JCheckBox)e.getSource();
            this.viewAttributes.showMaps = mapCheck.isSelected();
            this.repaint();
        } else if (cmd == "infoCheckCmd") {
            boolean showInfo;
            JCheckBox infoCheck = (JCheckBox)e.getSource();
            this.viewAttributes.showInfo = showInfo = infoCheck.isSelected();
            this.showSubframes(showInfo);
            this.doPrepare();
        } else if (cmd == "lockSeriesCmd") {
            JCheckBox lockCheck = (JCheckBox)e.getSource();
            boolean locked = lockCheck.isSelected();
            if (locked) {
                List<RpfCoverageBox> coverageBoxes = this.getCoverageBoxes();
                String seriesName = coverageBoxes == null || coverageBoxes.isEmpty() ? "ANY" : coverageBoxes.get((int)0).chartCode;
                if (seriesName == null) {
                    seriesName = "ANY";
                    this.fireRequestMessage("The " + this.getName() + " Layer is having trouble determining what kind\nof charts are being displayed.  Can't establish lock for charts\ncurrently being viewed.");
                }
                lockCheck.setText("Displaying Only - " + seriesName);
                this.viewAttributes.chartSeries = seriesName;
            } else {
                lockCheck.setText("Limit Chart Selection");
                this.viewAttributes.chartSeries = "ANY";
            }
        } else if (cmd == "coverageCheckCmd") {
            if (this.coverage != null) {
                JCheckBox coverageCheck = (JCheckBox)e.getSource();
                this.coverage.setInUse(coverageCheck.isSelected());
                this.doPrepare();
            }
        } else {
            this.doPrepare();
        }
    }

    protected void showSubframes(boolean show) {
        MapMouseInterpreter mmi;
        OMGraphicList list = this.getList();
        if (list != null) {
            list.setSelected(show);
        }
        if ((mmi = this.getMouseEventInterpreter()) != null) {
            mmi.setActive(show);
        }
    }

    public static void main(String[] argv) {
        System.out.println("#########################################");
        System.out.println("# Properties for the JAVA RpfLayer");
        System.out.println("# Mandatory properties:");
        System.out.println("layer.class=com.bbn.openmap.layer.rpf.RpfLayer");
        System.out.println("layer.prettyName=CADRG");
        System.out.println("# This property should reflect the paths to the RPF directories");
        System.out.println("layer.paths=<Path to RPF dir>;/cdrom/cdrom0/RPF");
        System.out.println("# Optional properties - Defaults will be set for properties not included (defaults are listed):");
        System.out.println("# Number between 0-255: 0 is transparent, 255 is opaque");
        System.out.println("layer.opaque=255");
        System.out.println("# Number of colors to use on the maps - 16, 32, 216");
        System.out.println("layer.numberColors=216");
        System.out.println("# Display maps on startup");
        System.out.println("layer.showMaps=true");
        System.out.println("# Display attribute information on startup");
        System.out.println("layer.showInfo=false");
        System.out.println("# Scale images to match map scale");
        System.out.println("layer.scaleImages=true");
        System.out.println("# The scale factor to allow when scaling images (2x, 4x, also mean 1/2, 1/4).  Default is 4.");
        System.out.println("rpf.imageScaleFactor=4");
        System.out.println("# Reset the cache if layer is removed from map");
        System.out.println("layer.killCache=false");
        System.out.println("# Limit the display to the chart code specified. (GN, JN, ON, TP, etc.)");
        System.out.println("layer.chartSeries=ANY");
        System.out.println("# Set the subframe cache size. (Number of subframes to hold on to, 256x256 pixels");
        System.out.println("layer.subframeCacheSize=128");
        System.out.println("# Get the subframe attribute data from the frame provider.");
        System.out.println("rpf.autofetchAttributes=false");
        System.out.println("#If you want the coverage tool to be available");
        System.out.println("layer.coverage=true");
        System.out.println("#Then add coverage constants as needed.");
    }
}

