/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMScalingRaster;
import com.bbn.openmap.omGraphics.OMWarpingImage;
import com.bbn.openmap.proj.EqualArc;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.proj.coords.LatLonGCT;
import com.bbn.openmap.util.DataBounds;
import java.awt.Color;

public class RpfSubframe {
    public byte version;
    public int nextSubframe;
    public int prevSubframe;
    public static final int PIXEL_EDGE_SIZE = 256;
    protected String data = "";
    protected int opaqueness;
    protected DataBounds bounds = null;
    protected ImageCreator imageCreator = null;

    public void setLocation(double ulat, double wlon, double llat, double elon) {
        this.bounds = new DataBounds();
        this.bounds.add(wlon, ulat);
        this.bounds.add(elon, llat);
    }

    public void setAttributeText(String text) {
        this.data = text;
    }

    public String getAttributeText() {
        return this.data;
    }

    public void setPixels(int[] pixels) {
        this.imageCreator = new Pixels(pixels);
    }

    public void setBitsAndColors(byte[] bits, Color[] colors) {
        this.imageCreator = new BitsAndColors(bits, colors);
    }

    public void setTransparent(int opaqueness) {
        if (this.opaqueness != opaqueness) {
            this.opaqueness = opaqueness;
            this.imageCreator.setTransparent(opaqueness);
        }
    }

    public OMGraphic getImage(Projection proj) {
        if (this.imageCreator != null) {
            return this.imageCreator.getImage(proj);
        }
        return null;
    }

    public class BitsAndColors
    extends ImageCreator {
        byte[] bits;
        Color[] colors;

        protected BitsAndColors(byte[] bits, Color[] colors) {
            this.bits = null;
            this.colors = null;
            this.bits = bits;
            this.colors = colors;
        }

        protected void setTransparent(int opaqueness) {
        }

        protected OMGraphic getImage(Projection proj) {
            boolean scaling = proj instanceof EqualArc;
            if (RpfSubframe.this.bounds == null || this.bits == null || this.colors == null) {
                return null;
            }
            if (this.image == null) {
                this.image = new OMScalingRaster(RpfSubframe.this.bounds.getMax().getY(), RpfSubframe.this.bounds.getMin().getX(), RpfSubframe.this.bounds.getMin().getY(), RpfSubframe.this.bounds.getMax().getX(), 256, 256, this.bits, this.colors, RpfSubframe.this.opaqueness);
                this.image.generate(proj);
                if (!scaling) {
                    this.image = new OMWarpingImage((OMScalingRaster)this.image, null);
                }
            } else if (scaling) {
                if (!(this.image instanceof OMScalingRaster)) {
                    this.image = new OMScalingRaster(RpfSubframe.this.bounds.getMax().getY(), RpfSubframe.this.bounds.getMin().getX(), RpfSubframe.this.bounds.getMin().getY(), RpfSubframe.this.bounds.getMax().getX(), 256, 256, this.bits, this.colors, RpfSubframe.this.opaqueness);
                }
            } else if (this.image instanceof OMScalingRaster) {
                this.image = new OMWarpingImage((OMScalingRaster)this.image, null);
            }
            this.image.setSelectPaint(Color.yellow);
            this.image.generate(proj);
            if (RpfSubframe.this.data != null) {
                this.image.putAttribute("Tooltip", RpfSubframe.this.data);
            }
            return this.image;
        }
    }

    public class Pixels
    extends ImageCreator {
        int[] pixels;

        protected Pixels(int[] pixels) {
            this.pixels = null;
            this.pixels = pixels;
        }

        protected void setTransparent(int opaqueness) {
            if (this.pixels != null) {
                for (int i = 0; i < this.pixels.length; ++i) {
                    this.pixels[i] = 0xFFFFFF & this.pixels[i] | opaqueness << 24;
                }
            }
        }

        protected OMGraphic getImage(Projection proj) {
            boolean scaling = proj instanceof EqualArc;
            if (RpfSubframe.this.bounds == null || this.pixels == null) {
                return null;
            }
            if (this.image == null) {
                this.image = scaling ? new OMScalingRaster(RpfSubframe.this.bounds.getMax().getY(), RpfSubframe.this.bounds.getMin().getX(), RpfSubframe.this.bounds.getMin().getY(), RpfSubframe.this.bounds.getMax().getX(), 256, 256, this.pixels) : new OMWarpingImage(this.pixels, 256, 256, (GeoCoordTransformation)new LatLonGCT(), RpfSubframe.this.bounds);
            } else if (scaling) {
                if (!(this.image instanceof OMScalingRaster)) {
                    this.image = new OMScalingRaster(RpfSubframe.this.bounds.getMax().getY(), RpfSubframe.this.bounds.getMin().getX(), RpfSubframe.this.bounds.getMin().getY(), RpfSubframe.this.bounds.getMax().getX(), 256, 256, this.pixels);
                }
            } else if (this.image instanceof OMScalingRaster) {
                this.image = new OMWarpingImage((OMScalingRaster)this.image, null);
            }
            this.image.setSelectPaint(Color.yellow);
            this.image.generate(proj);
            if (RpfSubframe.this.data != null) {
                this.image.putAttribute("Tooltip", RpfSubframe.this.data);
            }
            return this.image;
        }
    }

    public abstract class ImageCreator {
        OMGraphic image;

        protected abstract OMGraphic getImage(Projection var1);

        protected abstract void setTransparent(int var1);
    }
}

