/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.util.Debug;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;

public class DcwThematicIndex {
    private BinaryFile inputFile = null;
    private final int headerSize;
    private final int numberOfCodes;
    private final int numberOfRows;
    private final char typeOfIndex;
    private final char fieldTypeOfIndex;
    private final int numberOfDataElement;
    private final char dataTypeSpecifier;
    private final String tableIndexed;
    private final String columnIndexed;
    private final boolean sorted;
    private IndexRecord[] indexData;
    protected final String filename;
    protected boolean byteOrder;

    public DcwThematicIndex(String filename, boolean border) throws FormatException {
        this(filename, border, false);
    }

    public DcwThematicIndex(String filename, boolean border, boolean vpf2407) throws FormatException {
        this.filename = filename;
        this.byteOrder = border;
        this.reopen(0);
        if (Debug.debugging("vpfserver")) {
            System.out.println("DTI: opened the file " + filename);
        }
        try {
            this.headerSize = this.inputFile.readInteger();
            this.numberOfCodes = this.inputFile.readInteger();
            this.numberOfRows = this.inputFile.readInteger();
            this.typeOfIndex = this.inputFile.readChar();
            this.fieldTypeOfIndex = this.inputFile.readChar();
            this.numberOfDataElement = this.inputFile.readInteger();
            this.dataTypeSpecifier = this.inputFile.readChar();
            this.tableIndexed = this.trim(this.inputFile.readFixedLengthString(12)).toLowerCase();
            this.columnIndexed = this.trim(this.inputFile.readFixedLengthString(25)).toLowerCase();
            this.sorted = this.inputFile.readChar() == 'S' && vpf2407;
            this.inputFile.seek(60L);
            this.indexData = new IndexRecord[this.numberOfCodes];
            if (Debug.debugging("vpfserver")) {
                System.out.println("HeaderSize = " + this.headerSize);
                System.out.println("Number of Codes = " + this.numberOfCodes);
                System.out.println("Number of Rows = " + this.numberOfRows);
                System.out.println("Type of Index = " + this.typeOfIndex);
                System.out.println("Field Type of Index = " + this.fieldTypeOfIndex);
                System.out.println("Number of Data Element = " + this.numberOfDataElement);
                System.out.println("Data Type Specifier = " + this.dataTypeSpecifier);
                System.out.println("Table Indexed  = " + this.tableIndexed);
                System.out.println("Column Indexed = " + this.columnIndexed);
                System.out.println("Sorted = " + this.sorted);
            }
            StringBuffer pr = new StringBuffer();
            for (int i = 0; i < this.numberOfCodes; ++i) {
                this.indexData[i] = new IndexRecord(this.readIndexField(this.fieldTypeOfIndex, this.numberOfDataElement), this.inputFile.readInteger(), this.inputFile.readInteger());
                if (!Debug.debugging("vpfserver")) continue;
                pr = new StringBuffer("i = ").append(i);
                pr.append("; val = ").append(this.indexData[i].index.toString());
                pr.append("; offset = ").append(this.indexData[i].offset);
                pr.append("; number of elts = ").append(this.indexData[i].numvals);
                if (i >= 40) continue;
                System.out.println(pr.toString());
            }
            if (!this.sorted) {
                Arrays.sort(this.indexData);
            }
            if (Debug.debugging("vpfserver") && this.numberOfCodes > 40) {
                System.out.println(pr.toString());
            }
            Debug.message("vpfserver", "*** Finished Header Read ***");
            if (Debug.debugging("vpfserver")) {
                if (this.typeOfIndex == 'T' || this.typeOfIndex == 'I') {
                    Debug.output("Normal Inverted Index Format");
                } else if (this.typeOfIndex == 'B' || this.typeOfIndex == 'G') {
                    Debug.output("Scary Bitmap Index Format");
                } else {
                    throw new FormatException("Unidentified TMI format");
                }
                Object[] indexes = this.getValueIndexes();
                for (int j = 0; j < indexes.length; ++j) {
                }
            }
            this.close();
        }
        catch (EOFException e) {
            throw new FormatException("Hit Premature EOF in thematic index");
        }
        catch (IOException i) {
            throw new FormatException("Encountered IO Exception: " + i.getMessage());
        }
    }

    public Object[] getValueIndexes() {
        Object[] values = null;
        if (this.indexData != null) {
            values = new Object[this.indexData.length];
            for (int i = 0; i < this.indexData.length; ++i) {
                values[i] = this.indexData[i].index;
            }
        }
        return values;
    }

    public synchronized int[] get(Object valueIndex) throws FormatException {
        int[] values;
        block14: {
            values = null;
            try {
                int index = Arrays.binarySearch(this.indexData, valueIndex);
                if (index < 0) break block14;
                IndexRecord ir = this.indexData[index];
                int offset = ir.offset;
                int numvals = ir.numvals;
                if (this.typeOfIndex == 'T' || this.typeOfIndex == 'I') {
                    if (numvals == 0) {
                        values = new int[]{offset};
                    } else {
                        values = new int[numvals];
                        this.reopen(offset);
                        for (int j = 0; j < numvals; ++j) {
                            values[j] = this.readIndexWithFieldType(this.dataTypeSpecifier);
                        }
                    }
                    return values;
                }
                if (this.typeOfIndex == 'B' || this.typeOfIndex == 'G') {
                    int shortread = this.numberOfRows / 16;
                    if (this.numberOfRows % 16 != 0) {
                        ++shortread;
                    }
                    if (Debug.debugging("vpfserver")) {
                        System.out.println("Reading a bunch of shorts: " + shortread);
                        System.out.println("Starting at offset: " + this.inputFile.getFilePointer());
                    }
                    BitSet bits = new BitSet(this.numberOfRows);
                    int cnt = 0;
                    for (int shortcnt = 0; shortcnt < shortread; ++shortcnt) {
                        short s = this.inputFile.readShort();
                        for (int k = 0; k < 16; ++k) {
                            ++cnt;
                            if ((s & 1) == 1) {
                                bits.set(cnt);
                            }
                            s = (short)(s >> 1);
                        }
                    }
                    StringBuffer prt = new StringBuffer();
                    for (int j = 1; j <= bits.size(); ++j) {
                        if (!bits.get(j)) continue;
                        prt.append(", ").append(j);
                    }
                    System.out.println(prt);
                    break block14;
                }
                throw new FormatException("Unidentified TMI format");
            }
            catch (EOFException e) {
                throw new FormatException("Hit Premature EOF in thematic index");
            }
            catch (IOException i) {
                throw new FormatException("Encountered IO Exception: " + i.getMessage());
            }
        }
        return values;
    }

    private int readIndexWithFieldType(char ft) throws EOFException, FormatException {
        switch (ft) {
            case 'S': {
                return this.inputFile.readShort();
            }
            case 'I': {
                return this.inputFile.readInteger();
            }
        }
        throw new FormatException("Unrecognized FieldTypeOfIndex");
    }

    private Object readIndexField(char dts, int textlen) throws EOFException, FormatException {
        switch (dts) {
            case 'I': {
                return new Integer(this.inputFile.readInteger());
            }
            case 'T': {
                return this.inputFile.readFixedLengthString(textlen);
            }
            case 'S': {
                return new Short(this.inputFile.readShort());
            }
            case 'F': {
                return new Float(this.inputFile.readFloat());
            }
            case 'R': {
                return new Double(this.inputFile.readDouble());
            }
        }
        throw new FormatException("Unrecognized field index type");
    }

    private String trim(String s) {
        StringBuffer ns = new StringBuffer();
        char[] foo = s.toCharArray();
        for (int i = 0; i < foo.length && foo[i] != ' ' && foo[i] != '\u0000'; ++i) {
            ns.append(foo[i]);
        }
        return ns.toString();
    }

    public int getNumberOfCodes() {
        return this.numberOfCodes;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public char getTypeOfIndex() {
        return this.typeOfIndex;
    }

    public char getFieldTypeOfIndex() {
        return this.fieldTypeOfIndex;
    }

    public int getNumberOfDataElements() {
        return this.numberOfDataElement;
    }

    public char getDataTypeSpecifier() {
        return this.dataTypeSpecifier;
    }

    public String getTableIndexed() {
        return this.tableIndexed;
    }

    public String getColumnIndexed() {
        return this.columnIndexed;
    }

    public boolean getSorted() {
        return this.sorted;
    }

    public synchronized void close() throws FormatException {
        try {
            if (this.inputFile != null) {
                this.inputFile.close();
            }
            this.inputFile = null;
        }
        catch (IOException i) {
            throw new FormatException("DcwThematicIndex: Can't close file " + this.filename + ": " + i.getMessage());
        }
    }

    public synchronized void reopen(int offset) throws FormatException {
        try {
            if (this.inputFile == null) {
                this.inputFile = new BinaryBufferedFile(this.filename);
                this.inputFile.byteOrder(this.byteOrder);
            }
            if (offset > 0) {
                this.inputFile.seek(offset);
            }
        }
        catch (IOException i) {
            throw new FormatException("DcwThematicIndex: Can't open file " + this.filename + ": " + i.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IndexRecord
    implements Comparable<Object> {
        final Object index;
        final int offset;
        final int numvals;

        public IndexRecord(Object index, int offset, int numvals) {
            this.index = index;
            this.offset = offset;
            this.numvals = numvals;
        }

        @Override
        public int compareTo(Object obj) {
            Object realobj = obj instanceof IndexRecord ? ((IndexRecord)obj).index : obj;
            return ((Comparable)this.index).compareTo(realobj);
        }
    }
}

