/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.AreaTable;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.DcwRecordFile;
import com.bbn.openmap.layer.vpf.EdgeTable;
import com.bbn.openmap.layer.vpf.LayerGraphicWarehouseSupport;
import com.bbn.openmap.layer.vpf.MutableInt;
import com.bbn.openmap.layer.vpf.NodeTable;
import com.bbn.openmap.layer.vpf.TextTable;
import com.bbn.openmap.layer.vpf.VPFUtil;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPFLayerGraphicWarehouse
extends LayerGraphicWarehouseSupport {
    String areaFeatures = null;
    int[] areaSkipFeatures = null;
    String edgeFeatures = null;
    int[] edgeSkipFeatures = null;
    String textFeatures = null;
    int[] textSkipFeatures = null;
    String epointFeatures = null;
    int[] epointSkipFeatures = null;
    String cpointFeatures = null;
    int[] cpointSkipFeatures = null;
    static final transient Color aaronscolor = new Color(12443267);

    @Override
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.areaFeatures = props.getProperty(realPrefix + "area");
        this.areaSkipFeatures = (int[])(this.areaFeatures == null ? new int[0] : null);
        this.textFeatures = props.getProperty(realPrefix + "text");
        this.textSkipFeatures = (int[])(this.textFeatures == null ? new int[0] : null);
        this.edgeFeatures = props.getProperty(realPrefix + "edge");
        this.edgeSkipFeatures = (int[])(this.edgeFeatures == null ? new int[0] : null);
        this.epointFeatures = props.getProperty(realPrefix + "epoint");
        this.epointSkipFeatures = (int[])(this.epointFeatures == null ? new int[0] : null);
        this.cpointFeatures = props.getProperty(realPrefix + "cpoint");
        this.cpointSkipFeatures = (int[])(this.cpointFeatures == null ? new int[0] : null);
    }

    @Override
    public List<String> getFeatures() {
        StringTokenizer t;
        ArrayList<String> retval = new ArrayList<String>();
        if (this.areaFeatures != null) {
            t = new StringTokenizer(this.areaFeatures);
            while (t.hasMoreTokens()) {
                retval.add(t.nextToken());
            }
        }
        if (this.textFeatures != null) {
            t = new StringTokenizer(this.textFeatures);
            while (t.hasMoreTokens()) {
                retval.add(t.nextToken());
            }
        }
        if (this.edgeFeatures != null) {
            t = new StringTokenizer(this.edgeFeatures);
            while (t.hasMoreTokens()) {
                retval.add(t.nextToken());
            }
        }
        if (this.epointFeatures != null) {
            t = new StringTokenizer(this.epointFeatures);
            while (t.hasMoreTokens()) {
                retval.add(t.nextToken());
            }
        }
        if (this.cpointFeatures != null) {
            t = new StringTokenizer(this.cpointFeatures);
            while (t.hasMoreTokens()) {
                retval.add(t.nextToken());
            }
        }
        return retval;
    }

    protected int[] getSkipArray(String featureString, DcwRecordFile table, String colAppend) {
        ArrayList<Integer> tmpvec = new ArrayList<Integer>();
        if (featureString != null) {
            StringTokenizer t = new StringTokenizer(featureString);
            while (t.hasMoreTokens()) {
                int colnum;
                String colname = t.nextToken();
                if (colAppend != null) {
                    colname = colname + colAppend;
                }
                if ((colnum = table.whatColumn(colname)) == -1) continue;
                tmpvec.add(new Integer(colnum));
            }
        }
        int[] retval = new int[tmpvec.size()];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = (Integer)tmpvec.get(i);
        }
        return retval;
    }

    @Override
    public void resetForCAT() {
        this.areaSkipFeatures = null;
        this.textSkipFeatures = null;
        this.edgeSkipFeatures = null;
        this.epointSkipFeatures = null;
        this.cpointSkipFeatures = null;
    }

    protected boolean createFeature(List<Object> prim, int[] skipArray) {
        if (skipArray.length == 0) {
            return true;
        }
        for (int i = 0; i < skipArray.length; ++i) {
            int val = VPFUtil.objectToInt(prim.get(skipArray[i]));
            if (val == Integer.MIN_VALUE) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createArea(CoverageTable covtable, AreaTable areatable, List<Object> facevec, LatLonPoint ll1, LatLonPoint ll2, double dpplat, double dpplon) {
        if (this.areaSkipFeatures == null) {
            this.areaSkipFeatures = this.getSkipArray(this.areaFeatures, areatable, ".aft_id");
        }
        if (!this.createFeature(facevec, this.areaSkipFeatures)) {
            return;
        }
        ArrayList<CoordFloatString> ipts = new ArrayList<CoordFloatString>();
        int totalSize = 0;
        try {
            totalSize = areatable.computeEdgePoints(facevec, ipts);
        }
        catch (FormatException f) {
            Debug.output("FormatException in computeEdgePoints: " + f);
            return;
        }
        if (totalSize == 0) {
            return;
        }
        OMPoly py = VPFLayerGraphicWarehouse.createAreaOMPoly(ipts, totalSize, ll1, ll2, dpplat, dpplon, covtable.doAntarcticaWorkaround);
        this.drawingAttributes.setTo(py);
        py.setLinePaint(OMColor.clear);
        py.setSelectPaint(OMColor.clear);
        this.addArea(py);
    }

    @Override
    public void createEdge(CoverageTable c, EdgeTable edgetable, List<Object> edgevec, LatLonPoint ll1, LatLonPoint ll2, double dpplat, double dpplon, CoordFloatString coords) {
        if (this.edgeSkipFeatures == null) {
            if (Debug.debugging("vpf")) {
                Debug.output("Warehouse.createEdge(): edgeFeatures = " + this.edgeFeatures);
                MutableInt lineType = new MutableInt(-1);
                Debug.output("Warehouse: " + c.getLineDescription(edgevec, lineType));
            }
            String columnName = ".lft_id";
            this.edgeSkipFeatures = this.getSkipArray(this.edgeFeatures, edgetable, columnName);
        }
        if (!this.createFeature(edgevec, this.edgeSkipFeatures)) {
            return;
        }
        OMPoly py = VPFLayerGraphicWarehouse.createEdgeOMPoly(coords, ll1, ll2, dpplat, dpplon);
        this.drawingAttributes.setTo(py);
        py.setFillPaint(OMColor.clear);
        py.setIsPolygon(false);
        this.addEdge(py);
    }

    @Override
    public void createText(CoverageTable c, TextTable texttable, List<Object> textvec, double latitude, double longitude, String text) {
        if (this.textSkipFeatures == null) {
            this.textSkipFeatures = this.getSkipArray(this.textFeatures, texttable, ".tft_id");
        }
        if (!this.createFeature(textvec, this.textSkipFeatures)) {
            return;
        }
        OMText txt = VPFLayerGraphicWarehouse.createOMText(text, latitude, longitude);
        this.drawingAttributes.setTo(txt);
        this.addText(txt);
    }

    @Override
    public void createNode(CoverageTable c, NodeTable nt, List<Object> nodeprim, double latitude, double longitude, boolean isEntityNode) {
        int[] skipFeatures = null;
        if (isEntityNode) {
            if (this.epointSkipFeatures == null) {
                this.epointSkipFeatures = this.getSkipArray(this.epointFeatures, nt, ".pft_id");
            }
            skipFeatures = this.epointSkipFeatures;
        } else {
            if (this.cpointSkipFeatures == null) {
                this.cpointSkipFeatures = this.getSkipArray(this.cpointFeatures, nt, ".pft_id");
            }
            skipFeatures = this.cpointSkipFeatures;
        }
        if (!this.createFeature(nodeprim, skipFeatures)) {
            return;
        }
        OMPoint pt = VPFLayerGraphicWarehouse.createOMPoint(latitude, longitude);
        this.drawingAttributes.setTo(pt);
        this.addPoint(pt);
    }

    public static void main(String[] argv) {
        new VPFLayerGraphicWarehouse();
    }
}

